/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
implements Configuration {
    private WebAppContext _context;

    @Override
    public void setWebAppContext(WebAppContext webAppContext) {
        this._context = webAppContext;
    }

    @Override
    public WebAppContext getWebAppContext() {
        return this._context;
    }

    @Override
    public void configureClassLoader() throws Exception {
    }

    @Override
    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureWebApp() throws Exception {
        Resource resource;
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Configuring web-jetty.xml");
        }
        if ((resource = this.getWebAppContext().getWebInf()) != null && resource.isDirectory()) {
            Resource resource2 = resource.addPath("jetty6-web.xml");
            if (!resource2.exists()) {
                resource2 = resource.addPath("jetty-web.xml");
            }
            if (!resource2.exists()) {
                resource2 = resource.addPath("web-jetty.xml");
            }
            if (resource2.exists()) {
                String[] stringArray = this._context.getServerClasses();
                try {
                    this._context.setServerClasses(null);
                    if (Log.isDebugEnabled()) {
                        Log.debug("Configure: " + resource2);
                    }
                    XmlConfiguration xmlConfiguration = new XmlConfiguration(resource2.getURL());
                    xmlConfiguration.configure(this.getWebAppContext());
                }
                finally {
                    if (this._context.getServerClasses() == null) {
                        this._context.setServerClasses(stringArray);
                    }
                }
            }
        }
    }

    @Override
    public void deconfigureWebApp() throws Exception {
    }
}

