/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.StringUtil;

public class WebAppClassLoader
extends URLClassLoader {
    private String _name;
    private WebAppContext _context;
    private ClassLoader _parent = this.getParent();
    private HashSet _extensions;

    public WebAppClassLoader(WebAppContext webAppContext) throws IOException {
        this(null, webAppContext);
    }

    public WebAppClassLoader(ClassLoader classLoader, WebAppContext webAppContext) throws IOException {
        super(new URL[]{}, classLoader != null ? classLoader : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._context = webAppContext;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions = new HashSet();
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String string = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                this._extensions.add(stringTokenizer.nextToken().trim());
            }
        }
        if (webAppContext.getExtraClasspath() != null) {
            this.addClassPath(webAppContext.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public ContextHandler getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPath(String string) throws IOException {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Resource resource;
            block9: {
                File file;
                File file2;
                resource = Resource.newResource(stringTokenizer.nextToken());
                if (Log.isDebugEnabled()) {
                    Log.debug("Path resource=" + resource);
                }
                if ((file2 = resource.getFile()) != null) {
                    object = resource.getURL();
                    this.addURL((URL)object);
                    continue;
                }
                if (resource.isDirectory() || file2 != null) break block9;
                object = resource.getInputStream();
                File file3 = this._context.getTempDirectory();
                if (file3 == null) {
                    file3 = File.createTempFile("jetty.cl.lib", null);
                    file3.mkdir();
                    file3.deleteOnExit();
                }
                if (!(file = new File(file3, "lib")).exists()) {
                    file.mkdir();
                    file.deleteOnExit();
                }
                File file4 = File.createTempFile("Jetty-", ".jar", file);
                file4.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug("Extract " + resource + " to " + file4);
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file4);
                    IO.copy((InputStream)object, fileOutputStream);
                }
                catch (Throwable throwable) {
                    IO.close(fileOutputStream);
                    throw throwable;
                }
                IO.close(fileOutputStream);
                URL uRL = file4.toURL();
                this.addURL(uRL);
                continue;
            }
            object = resource.getURL();
            this.addURL((URL)object);
        }
    }

    private boolean isFileSupported(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 && this._extensions.contains(string.substring(n));
    }

    public void addJars(Resource resource) {
        if (resource.exists() && resource.isDirectory()) {
            String[] stringArray = resource.list();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    Resource resource2 = resource.addPath(stringArray[i]);
                    String string = resource2.getName().toLowerCase();
                    if (!this.isFileSupported(string)) continue;
                    String string2 = resource2.toString();
                    string2 = StringUtil.replace(string2, ",", "%2C");
                    string2 = StringUtil.replace(string2, ";", "%3B");
                    this.addClassPath(string2);
                    continue;
                }
                catch (Exception exception) {
                    Log.warn("EXCEPTION ", exception);
                }
            }
        }
    }

    public void destroy() {
        this._parent = null;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this._context.getPermissions();
        PermissionCollection permissionCollection2 = permissionCollection == null ? super.getPermissions(codeSource) : permissionCollection;
        return permissionCollection2;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        boolean bl = false;
        if (this._context.isParentLoaderPriority() || this.isSystemPath(string)) {
            bl = true;
            if (this._parent != null) {
                uRL = this._parent.getResource(string);
            }
        }
        if (uRL == null && (uRL = this.findResource(string)) == null && string.startsWith("/")) {
            if (Log.isDebugEnabled()) {
                Log.debug("HACK leading / off " + string);
            }
            uRL = this.findResource(string.substring(1));
        }
        if (uRL == null && !bl && this._parent != null) {
            uRL = this._parent.getResource(string);
        }
        if (uRL != null && Log.isDebugEnabled()) {
            Log.debug("getResource(" + string + ")=" + uRL);
        }
        return uRL;
    }

    public boolean isServerPath(String string) {
        string = string.replace('/', '.');
        while (string.startsWith(".")) {
            string = string.substring(1);
        }
        String[] stringArray = this._context.getServerClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = true;
                String string2 = stringArray[i];
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                    bl = false;
                }
                if (!(string2.endsWith(".") ? string.startsWith(string2) : string.equals(string2))) continue;
                return bl;
            }
        }
        return false;
    }

    public boolean isSystemPath(String string) {
        string = string.replace('/', '.');
        while (string.startsWith(".")) {
            string = string.substring(1);
        }
        String[] stringArray = this._context.getSystemClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = true;
                String string2 = stringArray[i];
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                    bl = false;
                }
                if (!(string2.endsWith(".") ? string.startsWith(string2) : string.equals(string2))) continue;
                return bl;
            }
        }
        return false;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        ClassNotFoundException classNotFoundException = null;
        boolean bl2 = false;
        if (clazz == null && this._parent != null && (this._context.isParentLoaderPriority() || this.isSystemPath(string))) {
            bl2 = true;
            try {
                clazz = this._parent.loadClass(string);
                if (Log.isDebugEnabled()) {
                    Log.debug("loaded " + clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                classNotFoundException = classNotFoundException3;
            }
        }
        if (clazz == null && this._parent != null && !bl2 && !this.isServerPath(string)) {
            clazz = this._parent.loadClass(string);
        }
        if (clazz == null) {
            throw classNotFoundException;
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        if (Log.isDebugEnabled()) {
            Log.debug("loaded " + clazz + " from " + clazz.getClassLoader());
        }
        return clazz;
    }

    public String toString() {
        if (Log.isDebugEnabled()) {
            return "ContextLoader@" + this._name + "(" + LazyList.array2List(this.getURLs()) + ") / " + this._parent;
        }
        return "ContextLoader@" + this._name;
    }
}

