/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.security.PermissionCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.WebAppDeployer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.log.Log;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class WebAppContext
extends Context {
    public static final String WEB_DEFAULTS_XML = "org/mortbay/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.mortbay.jetty.error_page";
    private static String[] __dftConfigurationClasses = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration"};
    private String[] _configurationClasses = __dftConfigurationClasses;
    private Configuration[] _configurations;
    private String _defaultsDescriptor = "org/mortbay/jetty/webapp/webdefault.xml";
    private String _descriptor = null;
    private String _overrideDescriptor = null;
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.mortbay.jetty.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay.", "org.xml.", "org.w3c.", "com.google.appengine.repackaged.org.apache.commons.logging.", "org.apache.log4j."};
    private String[] _serverClasses = new String[]{"-org.mortbay.jetty.plus.jaas.", "org.mortbay.jetty.", "org.slf4j."};
    private File _tmpDir;
    private boolean _isExistingTmpDir;
    private String _war;
    private String _extraClasspath;
    private Throwable _unavailableException;
    private transient Map _resourceAliases;
    private transient boolean _ownClassLoader = false;
    private transient boolean _unavailable;

    public static ContextHandler getCurrentWebAppContext() {
        ContextHandler contextHandler;
        ContextHandler.SContext sContext = ContextHandler.getCurrentContext();
        if (sContext != null && (contextHandler = sContext.getContextHandler()) instanceof WebAppContext) {
            return contextHandler;
        }
        return null;
    }

    public static void addWebApplications(Server server, String string, String string2, boolean bl, boolean bl2) throws IOException {
        WebAppContext.addWebApplications(server, string, string2, __dftConfigurationClasses, bl, bl2);
    }

    public static void addWebApplications(Server server, String string, String string2, String[] stringArray, boolean bl, boolean bl2) throws IOException {
        HandlerCollection handlerCollection = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (handlerCollection == null) {
            handlerCollection = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        WebAppContext.addWebApplications(handlerCollection, string, string2, stringArray, bl, bl2);
    }

    public static void addWebApplications(HandlerContainer handlerContainer, String string, String string2, boolean bl, boolean bl2) throws IOException {
        WebAppContext.addWebApplications(handlerContainer, string, string2, __dftConfigurationClasses, bl, bl2);
    }

    public static void addWebApplications(HandlerContainer handlerContainer, String string, String string2, String[] stringArray, boolean bl, boolean bl2) throws IOException {
        Log.warn("Deprecated configuration used for " + string);
        WebAppDeployer webAppDeployer = new WebAppDeployer();
        webAppDeployer.setContexts(handlerContainer);
        webAppDeployer.setWebAppDir(string);
        webAppDeployer.setConfigurationClasses(stringArray);
        webAppDeployer.setExtract(bl);
        webAppDeployer.setParentLoaderPriority(bl2);
        try {
            webAppDeployer.start();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public WebAppContext() {
        this(null, null, null, null);
    }

    public WebAppContext(String string, String string2) {
        super(null, string2, 3);
        this.setContextPath(string2);
        this.setWar(string);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(HandlerContainer handlerContainer, String string, String string2) {
        super(handlerContainer, string2, 3);
        this.setWar(string);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super(null, sessionHandler != null ? sessionHandler : new SessionHandler(), securityHandler != null ? securityHandler : new SecurityHandler(), servletHandler != null ? servletHandler : new ServletHandler(), null);
        this.setErrorHandler(errorHandler != null ? errorHandler : new ErrorPageErrorHandler());
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String string, String string2) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(string, string2);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String string) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(string);
    }

    public String removeResourceAlias(String string) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(string);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        if (classLoader != null && classLoader instanceof WebAppClassLoader) {
            ((WebAppClassLoader)classLoader).setName(this.getDisplayName());
        }
    }

    @Override
    public Resource getResource(String string) throws MalformedURLException {
        IOException iOException = null;
        Resource resource = null;
        int n = 0;
        while (string != null && n++ < 100) {
            try {
                resource = super.getResource(string);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                string = this.getResourceAlias(string);
            }
            catch (IOException iOException2) {
                Log.ignore(iOException2);
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (iOException != null && iOException instanceof MalformedURLException) {
            throw (MalformedURLException)iOException;
        }
        return resource;
    }

    @Override
    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws IOException, ServletException {
        if (this._unavailable) {
            httpServletResponse.sendError(503);
        } else {
            super.handle(string, httpServletRequest, httpServletResponse, n);
        }
    }

    @Override
    protected void doStart() throws Exception {
        try {
            File file;
            int n;
            this.loadConfigurations();
            for (n = 0; n < this._configurations.length; ++n) {
                this._configurations[n].setWebAppContext(this);
            }
            this._ownClassLoader = false;
            if (this.getClassLoader() == null) {
                WebAppClassLoader webAppClassLoader = new WebAppClassLoader(this);
                this.setClassLoader(webAppClassLoader);
                this._ownClassLoader = true;
            }
            if (Log.isDebugEnabled()) {
                ClassLoader classLoader = this.getClassLoader();
                Log.debug("Thread Context class loader is: " + classLoader);
                for (classLoader = classLoader.getParent(); classLoader != null; classLoader = classLoader.getParent()) {
                    Log.debug("Parent class loader is: " + classLoader);
                }
            }
            for (n = 0; n < this._configurations.length; ++n) {
                this._configurations[n].configureClassLoader();
            }
            this.getTempDirectory();
            if (!(this._tmpDir == null || this._isExistingTmpDir || this.isTempWorkDirectory() || (file = new File(this._tmpDir, ".active")).exists())) {
                file.mkdir();
            }
            super.doStart();
            if (this.isLogUrlOnStart()) {
                this.dumpUrl();
            }
        }
        catch (Exception exception) {
            Log.warn("Failed startup of context " + this, exception);
            this._unavailableException = exception;
            this._unavailable = true;
        }
    }

    public void dumpUrl() {
        Connector[] connectorArray = this.getServer().getConnectors();
        for (int i = 0; i < connectorArray.length; ++i) {
            String string = connectorArray[i].getName();
            String string2 = this.getDisplayName();
            if (string2 == null) {
                string2 = "WebApp@" + connectorArray.hashCode();
            }
            Log.info(string2 + " at http://" + string + this.getContextPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int n = this._configurations.length;
            while (n-- > 0) {
                this._configurations[n].deconfigureWebApp();
            }
            this._configurations = null;
            if (this._securityHandler.getHandler() == null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            }
            if (this._tmpDir != null && !this._isExistingTmpDir && !this.isTempWorkDirectory()) {
                IO.delete(this._tmpDir);
                this._tmpDir = null;
            }
        }
        finally {
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
            this._unavailable = false;
            this._unavailableException = null;
        }
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        return this._overrideDescriptor;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public File getTempDirectory() {
        Object object;
        Object object2;
        if (this._tmpDir != null && this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
            return this._tmpDir;
        }
        Object object3 = this.getAttribute("javax.servlet.context.tempdir");
        if (object3 != null && object3 instanceof File) {
            this._tmpDir = (File)object3;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (object3 != null && object3 instanceof String) {
            try {
                this._tmpDir = new File((String)object3);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Converted to File " + this._tmpDir + " for " + this);
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception exception) {
                Log.warn("EXCEPTION ", exception);
            }
        }
        Object object4 = null;
        try {
            object2 = new File(System.getProperty("jetty.home"), "work");
            if (((File)object2).exists() && ((File)object2).canWrite() && ((File)object2).isDirectory()) {
                object4 = object2;
            } else if (this.getBaseResource() != null && (object = this.getWebInf()) != null && ((Resource)object).exists() && ((File)(object2 = new File(((Resource)object).getFile(), "work"))).exists() && ((File)object2).canWrite() && ((File)object2).isDirectory()) {
                object4 = object2;
            }
        }
        catch (Exception exception) {
            Log.ignore(exception);
        }
        try {
            object2 = this.getCanonicalNameForWebAppTmpDir();
            if (object4 != null) {
                this._tmpDir = new File((File)object4, (String)object2);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), (String)object2);
                if (this._tmpDir.exists()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Delete existing temp dir " + this._tmpDir + " for " + this);
                    }
                    if (!IO.delete(this._tmpDir) && Log.isDebugEnabled()) {
                        Log.debug("Failed to delete temp dir " + this._tmpDir);
                    }
                    if (this._tmpDir.exists()) {
                        object = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile((String)object2 + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        Log.warn("Can't reuse " + (String)object + ", using " + this._tmpDir);
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (!this.isTempWorkDirectory()) {
                this._tmpDir.deleteOnExit();
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Created temp dir " + this._tmpDir + " for " + this);
            }
        }
        catch (Exception exception) {
            this._tmpDir = null;
            Log.ignore(exception);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug("Created temp dir " + this._tmpDir + " for " + this);
                }
            }
            catch (IOException iOException) {
                Log.warn("tmpdir", iOException);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public boolean isTempWorkDirectory() {
        if (this._tmpDir == null) {
            return false;
        }
        if (this._tmpDir.getName().equalsIgnoreCase("work")) {
            return true;
        }
        File file = this._tmpDir.getParentFile();
        if (file == null) {
            return false;
        }
        return file.getName().equalsIgnoreCase("work");
    }

    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        this.resolveWebApp();
        Resource resource = super.getBaseResource().addPath("WEB-INF/");
        if (!resource.exists() || !resource.isDirectory()) {
            return null;
        }
        return resource;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations != null) {
            return;
        }
        if (this._configurationClasses == null) {
            this._configurationClasses = __dftConfigurationClasses;
        }
        this._configurations = new Configuration[this._configurationClasses.length];
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i] = (Configuration)Loader.loadClass(this.getClass(), this._configurationClasses[i]).newInstance();
        }
    }

    @Override
    protected boolean isProtectedTarget(String string) {
        while (string.startsWith("//")) {
            string = URIUtil.compactPath(string);
        }
        return StringUtil.startsWithIgnoreCase(string, "/web-inf") || StringUtil.startsWithIgnoreCase(string, "/meta-inf");
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + (this._war == null ? this.getResourceBase() : this._war) + "}";
    }

    protected void resolveWebApp() throws IOException {
        Serializable serializable = super.getBaseResource();
        if (serializable == null) {
            Serializable serializable2;
            if (this._war == null || this._war.length() == 0) {
                this._war = this.getResourceBase();
            }
            if (((Resource)(serializable = Resource.newResource(this._war))).getAlias() != null) {
                Log.debug(serializable + " anti-aliased to " + ((Resource)serializable).getAlias());
                serializable = Resource.newResource(((Resource)serializable).getAlias());
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Try webapp=" + serializable + ", exists=" + ((Resource)serializable).exists() + ", directory=" + ((Resource)serializable).isDirectory());
            }
            if (((Resource)serializable).exists() && !((Resource)serializable).isDirectory() && !serializable.toString().startsWith("jar:") && ((Resource)(serializable2 = Resource.newResource("jar:" + serializable + "!/"))).exists() && ((Resource)serializable2).isDirectory()) {
                serializable = serializable2;
            }
            if (((Resource)serializable).exists() && (this._copyDir && ((Resource)serializable).getFile() != null && ((Resource)serializable).getFile().isDirectory() || this._extractWAR && ((Resource)serializable).getFile() != null && !((Resource)serializable).getFile().isDirectory() || this._extractWAR && ((Resource)serializable).getFile() == null || !((Resource)serializable).isDirectory())) {
                serializable2 = new File(this.getTempDirectory(), "webapp");
                if (((Resource)serializable).getFile() != null && ((Resource)serializable).getFile().isDirectory()) {
                    Log.info("Copy " + ((Resource)serializable).getFile() + " to " + serializable2);
                    IO.copyDir(((Resource)serializable).getFile(), (File)serializable2);
                } else if (!((File)serializable2).exists()) {
                    ((File)serializable2).mkdir();
                    Log.info("Extract " + this._war + " to " + serializable2);
                    JarResource.extract((Resource)serializable, (File)serializable2, false);
                } else if (((Resource)serializable).lastModified() > ((File)serializable2).lastModified()) {
                    ((File)serializable2).delete();
                    ((File)serializable2).mkdir();
                    Log.info("Extract " + this._war + " to " + serializable2);
                    JarResource.extract((Resource)serializable, (File)serializable2, false);
                }
                serializable = Resource.newResource(((File)serializable2).getCanonicalPath());
            }
            if (!((Resource)serializable).exists() || !((Resource)serializable).isDirectory()) {
                Log.warn("Web application not found " + this._war);
                throw new FileNotFoundException(this._war);
            }
            if (Log.isDebugEnabled()) {
                Log.debug("webapp=" + serializable);
            }
            super.setBaseResource((Resource)serializable);
        }
    }

    public void setConfigurationClasses(String[] stringArray) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._configurationClasses = stringArray == null ? null : (String[])stringArray.clone();
    }

    public void setConfigurations(Configuration[] configurationArray) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._configurations = configurationArray == null ? null : (Configuration[])configurationArray.clone();
    }

    public void setDefaultsDescriptor(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._defaultsDescriptor = string;
    }

    public void setOverrideDescriptor(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._overrideDescriptor = string;
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._descriptor = string;
    }

    public void setDistributable(boolean bl) {
        this._distributable = bl;
    }

    @Override
    public void setEventListeners(EventListener[] eventListenerArray) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListenerArray);
        for (int i = 0; eventListenerArray != null && i < eventListenerArray.length; ++i) {
            EventListener eventListener = eventListenerArray[i];
            if (!(eventListener instanceof HttpSessionActivationListener) && !(eventListener instanceof HttpSessionAttributeListener) && !(eventListener instanceof HttpSessionBindingListener) && !(eventListener instanceof HttpSessionListener) || this._sessionHandler == null) continue;
            this._sessionHandler.addEventListener(eventListener);
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.setEventListeners((EventListener[])LazyList.addToArray(this.getEventListeners(), eventListener, EventListener.class));
    }

    public void setExtractWAR(boolean bl) {
        this._extractWAR = bl;
    }

    public void setCopyWebDir(boolean bl) {
        this._copyDir = bl;
    }

    public void setParentLoaderPriority(boolean bl) {
        this._parentLoaderPriority = bl;
    }

    public void setPermissions(PermissionCollection permissionCollection) {
        this._permissions = permissionCollection;
    }

    public void setServerClasses(String[] stringArray) {
        this._serverClasses = stringArray == null ? null : (String[])stringArray.clone();
    }

    public void setSystemClasses(String[] stringArray) {
        this._systemClasses = stringArray == null ? null : (String[])stringArray.clone();
    }

    public void setTempDirectory(File file) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (file != null) {
            try {
                file = new File(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                Log.warn("EXCEPTION ", iOException);
            }
        }
        if (file != null && !file.exists()) {
            file.mkdir();
            file.deleteOnExit();
        } else if (file != null) {
            this._isExistingTmpDir = true;
        }
        if (!(file == null || file.exists() && file.isDirectory() && file.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + file);
        }
        this._tmpDir = file;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public void setWar(String string) {
        this._war = string;
    }

    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public void setExtraClasspath(String string) {
        this._extraClasspath = string;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean bl) {
        this._logUrlOnStart = bl;
    }

    @Override
    protected void startContext() throws Exception {
        Resource resource;
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureDefaults();
        }
        Resource resource2 = this.getWebInf();
        if (resource2 != null && (resource = resource2.addPath("work")).exists() && resource.isDirectory() && resource.getFile() != null && resource.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
            this.setAttribute("javax.servlet.context.tempdir", resource.getFile());
        }
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureWebApp();
        }
        super.startContext();
    }

    private String getCanonicalNameForWebAppTmpDir() {
        String[] stringArray;
        Object object;
        int n;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Jetty");
        Connector[] connectorArray = this.getServer().getConnectors();
        stringBuffer.append("_");
        String string2 = string = connectorArray == null || connectorArray[0] == null ? "" : connectorArray[0].getHost();
        if (string == null) {
            string = "0.0.0.0";
        }
        stringBuffer.append(string.replace('.', '_'));
        stringBuffer.append("_");
        int n2 = n = connectorArray == null || connectorArray[0] == null ? 0 : connectorArray[0].getLocalPort();
        if (n < 0) {
            n = connectorArray[0].getPort();
        }
        stringBuffer.append(n);
        stringBuffer.append("_");
        try {
            object = super.getBaseResource();
            if (object == null) {
                if (this._war == null || this._war.length() == 0) {
                    object = Resource.newResource(this.getResourceBase());
                }
                object = Resource.newResource(this._war);
            }
            if ((stringArray = URIUtil.decodePath(((Resource)object).getURL().getPath())).endsWith("/")) {
                stringArray = stringArray.substring(0, stringArray.length() - 1);
            }
            if (stringArray.endsWith("!")) {
                stringArray = stringArray.substring(0, stringArray.length() - 1);
            }
            int n3 = stringArray.lastIndexOf("/");
            stringBuffer.append(stringArray.substring(n3 + 1, stringArray.length()));
        }
        catch (Exception exception) {
            Log.warn("Can't generate resourceBase as part of webapp tmp dir name", exception);
        }
        stringBuffer.append("_");
        object = this.getContextPath();
        object = ((String)object).replace('/', '_');
        object = ((String)object).replace('\\', '_');
        stringBuffer.append((String)object);
        stringBuffer.append("_");
        stringArray = this.getVirtualHosts();
        stringBuffer.append(stringArray == null || stringArray[0] == null ? "" : stringArray[0]);
        String string3 = Integer.toString(stringBuffer.toString().hashCode(), 36);
        stringBuffer.append("_");
        stringBuffer.append(string3);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            stringBuffer.setCharAt(i, '.');
        }
        return stringBuffer.toString();
    }
}

