/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class WebInfConfiguration
implements Configuration {
    protected WebAppContext _context;

    @Override
    public void setWebAppContext(WebAppContext webAppContext) {
        this._context = webAppContext;
    }

    @Override
    public WebAppContext getWebAppContext() {
        return this._context;
    }

    @Override
    public void configureClassLoader() throws Exception {
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        Resource resource = this._context.getWebInf();
        if (resource != null && resource.isDirectory() && this._context.getClassLoader() instanceof WebAppClassLoader) {
            Resource resource2;
            Resource resource3 = resource.addPath("classes/");
            if (resource3.exists()) {
                ((WebAppClassLoader)this._context.getClassLoader()).addClassPath(resource3.toString());
            }
            if ((resource2 = resource.addPath("lib/")).exists() || resource2.isDirectory()) {
                ((WebAppClassLoader)this._context.getClassLoader()).addJars(resource2);
            }
        }
    }

    @Override
    public void configureDefaults() throws Exception {
    }

    @Override
    public void configureWebApp() throws Exception {
    }

    @Override
    public void deconfigureWebApp() throws Exception {
    }
}

