/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.ClientCertAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

public class WebXmlConfiguration
implements Configuration {
    protected WebAppContext _context;
    protected XmlParser _xmlParser = WebXmlConfiguration.webXmlParser();
    protected Object _filters;
    protected Object _filterMappings;
    protected Object _servlets;
    protected Object _servletMappings;
    protected Object _welcomeFiles;
    protected Object _constraintMappings;
    protected Object _listeners;
    protected Map _errorPages;
    protected boolean _hasJSP;
    protected String _jspServletName;
    protected String _jspServletClass;
    protected boolean _defaultWelcomeFileList;
    protected ServletHandler _servletHandler;
    protected int _version;

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL uRL = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL uRL2 = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL uRL3 = WebAppContext.class.getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL uRL4 = WebAppContext.class.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        URL uRL5 = WebAppContext.class.getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL uRL6 = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL uRL7 = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_5.xsd");
        URL uRL8 = WebAppContext.class.getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL uRL9 = WebAppContext.class.getResource("/javax/servlet/resources/xml.xsd");
        URL uRL10 = WebAppContext.class.getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL uRL11 = WebAppContext.class.getResource("/javax/servlet/resources/javaee_web_services_client_1_2.xsd");
        URL uRL12 = WebAppContext.class.getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", uRL);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", uRL);
        xmlParser.redirectEntity("web.dtd", uRL2);
        xmlParser.redirectEntity("web-app_2_3.dtd", uRL2);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", uRL2);
        xmlParser.redirectEntity("XMLSchema.dtd", uRL8);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", uRL8);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", uRL8);
        xmlParser.redirectEntity("jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("jsp_2_1.xsd", uRL4);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", uRL4);
        xmlParser.redirectEntity("j2ee_1_4.xsd", uRL5);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", uRL5);
        xmlParser.redirectEntity("web-app_2_4.xsd", uRL6);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", uRL6);
        xmlParser.redirectEntity("web-app_2_5.xsd", uRL7);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", uRL7);
        xmlParser.redirectEntity("xml.xsd", uRL9);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", uRL9);
        xmlParser.redirectEntity("datatypes.dtd", uRL12);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", uRL12);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", uRL10);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", uRL10);
        xmlParser.redirectEntity("javaee_web_services_client_1_2.xsd", uRL11);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", uRL11);
        return xmlParser;
    }

    @Override
    public void setWebAppContext(WebAppContext webAppContext) {
        this._context = webAppContext;
    }

    @Override
    public WebAppContext getWebAppContext() {
        return this._context;
    }

    @Override
    public void configureClassLoader() throws Exception {
    }

    @Override
    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        String string = this.getWebAppContext().getDefaultsDescriptor();
        if (string != null && string.length() > 0) {
            Resource resource = Resource.newSystemResource(string);
            if (resource == null) {
                resource = Resource.newResource(string);
            }
            this.configure(resource.getURL().toString());
            this._defaultWelcomeFileList = this._welcomeFiles != null;
        }
    }

    @Override
    public void configureWebApp() throws Exception {
        String string;
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        URL uRL = this.findWebXml();
        if (uRL != null) {
            this.configure(uRL.toString());
        }
        if ((string = this.getWebAppContext().getOverrideDescriptor()) != null && string.length() > 0) {
            Resource resource = Resource.newSystemResource(string);
            if (resource == null) {
                resource = Resource.newResource(string);
            }
            this._xmlParser.setValidating(false);
            this.configure(resource.getURL().toString());
        }
    }

    protected URL findWebXml() throws IOException, MalformedURLException {
        Resource resource;
        String string = this.getWebAppContext().getDescriptor();
        if (string != null && (resource = Resource.newResource(string)).exists() && !resource.isDirectory()) {
            return resource.getURL();
        }
        resource = this.getWebAppContext().getWebInf();
        if (resource != null && resource.isDirectory()) {
            Resource resource2 = resource.addPath("web.xml");
            if (resource2.exists()) {
                return resource2.getURL();
            }
            Log.debug("No WEB-INF/web.xml in " + this.getWebAppContext().getWar() + ". Serving files and default/dynamic servlets only");
        }
        return null;
    }

    public void configure(String string) throws Exception {
        XmlParser.Node node = null;
        node = this._xmlParser.parse(string);
        this.initialize(node);
    }

    @Override
    public void deconfigureWebApp() throws Exception {
        this._servletHandler = this.getWebAppContext().getServletHandler();
        this._servletHandler.setFilters(null);
        this._servletHandler.setFilterMappings(null);
        this._servletHandler.setServlets(null);
        this._servletHandler.setServletMappings(null);
        this.getWebAppContext().setEventListeners(null);
        this.getWebAppContext().setWelcomeFiles(null);
        if (this.getWebAppContext().getSecurityHandler() != null) {
            this.getWebAppContext().getSecurityHandler().setConstraintMappings(null);
        }
        if (this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(null);
        }
    }

    protected void initialize(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        Object object;
        this._servletHandler = this.getWebAppContext().getServletHandler();
        this._filters = LazyList.array2List(this._servletHandler.getFilters());
        this._filterMappings = LazyList.array2List(this._servletHandler.getFilterMappings());
        this._servlets = LazyList.array2List(this._servletHandler.getServlets());
        this._servletMappings = LazyList.array2List(this._servletHandler.getServletMappings());
        this._listeners = LazyList.array2List(this.getWebAppContext().getEventListeners());
        this._welcomeFiles = LazyList.array2List(this.getWebAppContext().getWelcomeFiles());
        this._constraintMappings = LazyList.array2List(this.getWebAppContext().getSecurityHandler().getConstraintMappings());
        this._errorPages = this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler ? ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).getErrorPages() : null;
        String string = node.getAttribute("version", "DTD");
        if ("2.5".equals(string)) {
            this._version = 25;
        } else if ("2.4".equals(string)) {
            this._version = 24;
        } else if ("DTD".equals(string)) {
            this._version = 23;
            object = this._xmlParser.getDTD();
            if (object != null && ((String)object).indexOf("web-app_2_2") >= 0) {
                this._version = 22;
            }
        }
        object = node.iterator();
        XmlParser.Node node2 = null;
        while (object.hasNext()) {
            try {
                Object e = object.next();
                if (!(e instanceof XmlParser.Node)) continue;
                node2 = (XmlParser.Node)e;
                String string2 = node2.getTag();
                this.initWebXmlElement(string2, node2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                Log.warn("Configuration problem at " + node2 + ": " + exception);
                Log.debug(exception);
                throw new UnavailableException("Configuration problem");
            }
        }
        this._servletHandler.setFilters((FilterHolder[])LazyList.toArray(this._filters, FilterHolder.class));
        this._servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray(this._filterMappings, FilterMapping.class));
        this._servletHandler.setServlets((ServletHolder[])LazyList.toArray(this._servlets, ServletHolder.class));
        this._servletHandler.setServletMappings((ServletMapping[])LazyList.toArray(this._servletMappings, ServletMapping.class));
        this.getWebAppContext().setEventListeners((EventListener[])LazyList.toArray(this._listeners, EventListener.class));
        this.getWebAppContext().setWelcomeFiles((String[])LazyList.toArray(this._welcomeFiles, String.class));
        this.getWebAppContext().getSecurityHandler().setConstraintMappings((ConstraintMapping[])LazyList.toArray(this._constraintMappings, ConstraintMapping.class));
        if (this._errorPages != null && this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(this._errorPages);
        }
    }

    protected void initWebXmlElement(String string, XmlParser.Node node) throws Exception {
        if ("display-name".equals(string)) {
            this.initDisplayName(node);
        } else if (!"description".equals(string)) {
            if ("context-param".equals(string)) {
                this.initContextParam(node);
            } else if ("servlet".equals(string)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(string)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(string)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(string)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(string)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(string)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(string)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(string)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(string)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(string)) {
                if (Log.isDebugEnabled()) {
                    Log.debug("No implementation: " + node);
                }
            } else if ("security-constraint".equals(string)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(string)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(string)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(string)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(string)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(string)) {
                this.initListener(node);
            } else if ("distributable".equals(string)) {
                this.initDistributable(node);
            } else if (Log.isDebugEnabled()) {
                Log.debug("Element {} not handled in {}", string, this);
                Log.debug(node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebAppContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String string = node.getString("param-name", false, true);
        String string2 = node.getString("param-value", false, true);
        if (Log.isDebugEnabled()) {
            Log.debug("ContextParam: " + string + "=" + string2);
        }
        this.getWebAppContext().getInitParams().put(string, string2);
    }

    protected void initFilter(XmlParser.Node node) {
        String string;
        String string2 = node.getString("filter-name", false, true);
        FilterHolder filterHolder = this._servletHandler.getFilter(string2);
        if (filterHolder == null) {
            filterHolder = this._servletHandler.newFilterHolder();
            filterHolder.setName(string2);
            this._filters = LazyList.add(this._filters, filterHolder);
        }
        if ((string = node.getString("filter-class", false, true)) != null) {
            filterHolder.setClassName(string);
        }
        Iterator iterator = node.iterator("init-param");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string3 = node2.getString("param-name", false, true);
            String string4 = node2.getString("param-value", false, true);
            filterHolder.setInitParameter(string3, string4);
        }
    }

    protected void initFilterMapping(XmlParser.Node node) {
        Object object;
        String string = node.getString("filter-name", false, true);
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setFilterName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = node.iterator("url-pattern");
        while (iterator.hasNext()) {
            object = ((XmlParser.Node)iterator.next()).toString(false, true);
            object = this.normalizePattern((String)object);
            arrayList.add((String)object);
        }
        filterMapping.setPathSpecs(arrayList.toArray(new String[arrayList.size()]));
        object = new ArrayList();
        iterator = node.iterator("servlet-name");
        while (iterator.hasNext()) {
            String string2 = ((XmlParser.Node)iterator.next()).toString(false, true);
            ((ArrayList)object).add(string2);
        }
        filterMapping.setServletNames(((ArrayList)object).toArray(new String[((ArrayList)object).size()]));
        int n = 0;
        iterator = node.iterator("dispatcher");
        while (iterator.hasNext()) {
            String string3 = ((XmlParser.Node)iterator.next()).toString(false, true);
            n |= Dispatcher.type(string3);
        }
        filterMapping.setDispatches(n);
        this._filterMappings = LazyList.add(this._filterMappings, filterMapping);
    }

    protected String normalizePattern(String string) {
        if (string != null && string.length() > 0 && !string.startsWith("/") && !string.startsWith("*")) {
            return "/" + string;
        }
        return string;
    }

    protected void initServlet(XmlParser.Node node) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = node.getAttribute("id");
        String string3 = node.getString("servlet-name", false, true);
        ServletHolder servletHolder = this._servletHandler.getServlet(string3);
        if (servletHolder == null) {
            servletHolder = this._servletHandler.newServletHolder();
            servletHolder.setName(string3);
            this._servlets = LazyList.add(this._servlets, servletHolder);
        }
        Iterator iterator = node.iterator("init-param");
        while (iterator.hasNext()) {
            object4 = (XmlParser.Node)iterator.next();
            object3 = ((XmlParser.Node)object4).getString("param-name", false, true);
            object2 = ((XmlParser.Node)object4).getString("param-value", false, true);
            servletHolder.setInitParameter((String)object3, (String)object2);
        }
        object4 = node.getString("servlet-class", false, true);
        if (string2 != null && string2.equals("jsp")) {
            this._jspServletName = string3;
            this._jspServletClass = object4;
            try {
                Loader.loadClass(this.getClass(), (String)object4);
                this._hasJSP = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.info("NO JSP Support for {}, did not find {}", this._context.getContextPath(), object4);
                this._hasJSP = false;
                object4 = "org.mortbay.servlet.NoJspServlet";
                this._jspServletClass = "org.mortbay.servlet.NoJspServlet";
            }
            if (servletHolder.getInitParameter("scratchdir") == null) {
                object3 = this.getWebAppContext().getTempDirectory();
                object2 = new File((File)object3, "jsp");
                if (!((File)object2).exists()) {
                    ((File)object2).mkdir();
                }
                servletHolder.setInitParameter("scratchdir", ((File)object2).getAbsolutePath());
                if ("?".equals(servletHolder.getInitParameter("classpath"))) {
                    object = this.getWebAppContext().getClassPath();
                    Log.debug("classpath=" + (String)object);
                    if (object != null) {
                        servletHolder.setInitParameter("classpath", (String)object);
                    }
                }
            }
        }
        if (object4 != null) {
            servletHolder.setClassName((String)object4);
        }
        if ((object3 = node.getString("jsp-file", false, true)) != null) {
            servletHolder.setForcedPath((String)object3);
            servletHolder.setClassName(this._jspServletClass);
        }
        if ((object2 = node.get("load-on-startup")) != null) {
            object = ((XmlParser.Node)object2).toString(false, true).toLowerCase();
            if (((String)object).startsWith("t")) {
                Log.warn("Deprecated boolean load-on-startup.  Please use integer");
                servletHolder.setInitOrder(1);
            } else {
                int n = 0;
                try {
                    if (object != null && ((String)object).trim().length() > 0) {
                        n = Integer.parseInt((String)object);
                    }
                }
                catch (Exception exception) {
                    Log.warn("Cannot parse load-on-startup " + (String)object + ". Please use integer");
                    Log.ignore(exception);
                }
                servletHolder.setInitOrder(n);
            }
        }
        object = node.iterator("security-role-ref");
        while (object.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)object.next();
            string = node2.getString("role-name", false, true);
            String string4 = node2.getString("role-link", false, true);
            if (string != null && string.length() > 0 && string4 != null && string4.length() > 0) {
                if (Log.isDebugEnabled()) {
                    Log.debug("link role " + string + " to " + string4 + " for " + this);
                }
                servletHolder.setUserRoleLink(string, string4);
                continue;
            }
            Log.warn("Ignored invalid security-role-ref element: servlet-name=" + servletHolder.getName() + ", " + node2);
        }
        XmlParser.Node node3 = node.get("run-as");
        if (node3 != null && (string = node3.getString("role-name", false, true)) != null) {
            servletHolder.setRunAs(string);
        }
    }

    protected void initServletMapping(XmlParser.Node node) {
        String string = node.getString("servlet-name", false, true);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = node.iterator("url-pattern");
        while (iterator.hasNext()) {
            String string2 = ((XmlParser.Node)iterator.next()).toString(false, true);
            string2 = this.normalizePattern(string2);
            arrayList.add(string2);
        }
        servletMapping.setPathSpecs(arrayList.toArray(new String[arrayList.size()]));
        this._servletMappings = LazyList.add(this._servletMappings, servletMapping);
    }

    protected void initListener(XmlParser.Node node) {
        String string = node.getString("listener-class", false, true);
        Object object = null;
        try {
            Class clazz = this.getWebAppContext().loadClass(string);
            object = this.newListenerInstance(clazz);
            if (!(object instanceof EventListener)) {
                Log.warn("Not an EventListener: " + object);
                return;
            }
            this._listeners = LazyList.add(this._listeners, object);
        }
        catch (Exception exception) {
            Log.warn("Could not instantiate listener " + string, exception);
            return;
        }
    }

    protected Object newListenerInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    protected void initDistributable(XmlParser.Node node) {
        WebAppContext webAppContext = this.getWebAppContext();
        if (!webAppContext.isDistributable()) {
            webAppContext.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node node2 = node.get("session-timeout");
        if (node2 != null) {
            int n = Integer.parseInt(node2.toString(false, true));
            this.getWebAppContext().getSessionHandler().getSessionManager().setMaxInactiveInterval(n * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String string = node.getString("extension", false, true);
        if (string != null && string.startsWith(".")) {
            string = string.substring(1);
        }
        String string2 = node.getString("mime-type", false, true);
        this.getWebAppContext().getMimeTypes().addMimeMapping(string, string2);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        if (this._defaultWelcomeFileList) {
            this._welcomeFiles = null;
        }
        this._defaultWelcomeFileList = false;
        Iterator iterator = node.iterator("welcome-file");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string = node2.toString(false, true);
            this._welcomeFiles = LazyList.add(this._welcomeFiles, string);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iterator = node.iterator("locale-encoding-mapping");
        while (iterator.hasNext()) {
            XmlParser.Node node2 = (XmlParser.Node)iterator.next();
            String string = node2.getString("locale", false, true);
            String string2 = node2.getString("encoding", false, true);
            this.getWebAppContext().addLocaleEncoding(string, string2);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String string = node.getString("error-code", false, true);
        if (string == null || string.length() == 0) {
            string = node.getString("exception-type", false, true);
        }
        String string2 = node.getString("location", false, true);
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(string, string2);
    }

    protected void initTagLib(XmlParser.Node node) {
        String string = node.getString("taglib-uri", false, true);
        String string2 = node.getString("taglib-location", false, true);
        this.getWebAppContext().setResourceAlias(string, string2);
    }

    protected void initJspConfig(XmlParser.Node node) {
        Object object;
        Object object2;
        Object object3;
        for (int i = 0; i < node.size(); ++i) {
            object3 = node.get(i);
            if (!(object3 instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)object3).getTag())) continue;
            this.initTagLib((XmlParser.Node)object3);
        }
        Iterator iterator = node.iterator("jsp-property-group");
        object3 = null;
        while (iterator.hasNext()) {
            object2 = (XmlParser.Node)iterator.next();
            object = ((XmlParser.Node)object2).iterator("url-pattern");
            while (object.hasNext()) {
                String string = ((XmlParser.Node)object.next()).toString(false, true);
                string = this.normalizePattern(string);
                object3 = LazyList.add(object3, string);
            }
        }
        if (LazyList.size(object3) > 0 && (object2 = this.getJSPServletName()) != null) {
            object = new ServletMapping();
            ((ServletMapping)object).setServletName((String)object2);
            ((ServletMapping)object).setPathSpecs(LazyList.toStringArray(object3));
            this._servletMappings = LazyList.add(this._servletMappings, object);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        Constraint constraint = new Constraint();
        try {
            Object object;
            Object object2;
            Object object3;
            XmlParser.Node node2 = node.get("auth-constraint");
            if (node2 != null) {
                constraint.setAuthenticate(true);
                object3 = node2.iterator("role-name");
                object2 = null;
                while (object3.hasNext()) {
                    object = ((XmlParser.Node)object3.next()).toString(false, true);
                    object2 = LazyList.add(object2, object);
                }
                constraint.setRoles(LazyList.toStringArray(object2));
            }
            if ((object3 = node.get("user-data-constraint")) != null) {
                object2 = ((XmlParser.Node)(object3 = ((XmlParser.Node)object3).get("transport-guarantee"))).toString(false, true).toUpperCase();
                if (object2 == null || ((String)object2).length() == 0 || "NONE".equals(object2)) {
                    constraint.setDataConstraint(0);
                } else if ("INTEGRAL".equals(object2)) {
                    constraint.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(object2)) {
                    constraint.setDataConstraint(2);
                } else {
                    Log.warn("Unknown user-data-constraint:" + (String)object2);
                    constraint.setDataConstraint(2);
                }
            }
            object2 = node.iterator("web-resource-collection");
            while (object2.hasNext()) {
                object = (XmlParser.Node)object2.next();
                String string = ((XmlParser.Node)object).getString("web-resource-name", false, true);
                Constraint constraint2 = (Constraint)constraint.clone();
                constraint2.setName(string);
                Iterator iterator = ((XmlParser.Node)object).iterator("url-pattern");
                while (iterator.hasNext()) {
                    Object object4;
                    String string2 = ((XmlParser.Node)iterator.next()).toString(false, true);
                    string2 = this.normalizePattern(string2);
                    Iterator iterator2 = ((XmlParser.Node)object).iterator("http-method");
                    if (iterator2.hasNext()) {
                        while (iterator2.hasNext()) {
                            object4 = ((XmlParser.Node)iterator2.next()).toString(false, true);
                            ConstraintMapping constraintMapping = new ConstraintMapping();
                            constraintMapping.setMethod((String)object4);
                            constraintMapping.setPathSpec(string2);
                            constraintMapping.setConstraint(constraint2);
                            this._constraintMappings = LazyList.add(this._constraintMappings, constraintMapping);
                        }
                        continue;
                    }
                    object4 = new ConstraintMapping();
                    ((ConstraintMapping)object4).setPathSpec(string2);
                    ((ConstraintMapping)object4).setConstraint(constraint2);
                    this._constraintMappings = LazyList.add(this._constraintMappings, object4);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.warn(cloneNotSupportedException);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        UserRealm[] userRealmArray;
        Object object;
        XmlParser.Node node2 = node.get("auth-method");
        FormAuthenticator formAuthenticator = null;
        if (node2 != null) {
            object = null;
            userRealmArray = node2.toString(false, true);
            if ("FORM".equals(userRealmArray)) {
                formAuthenticator = new FormAuthenticator();
                object = formAuthenticator;
            } else if ("BASIC".equals(userRealmArray)) {
                object = new BasicAuthenticator();
            } else if ("DIGEST".equals(userRealmArray)) {
                object = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(userRealmArray)) {
                object = new ClientCertAuthenticator();
            } else if ("CLIENT-CERT".equals(userRealmArray)) {
                object = new ClientCertAuthenticator();
            } else {
                Log.warn("UNKNOWN AUTH METHOD: " + (String)userRealmArray);
            }
            this.getWebAppContext().getSecurityHandler().setAuthenticator((Authenticator)object);
        }
        object = node.get("realm-name");
        userRealmArray = ContextHandler.getCurrentContext().getContextHandler().getServer().getUserRealms();
        String string = object == null ? "default" : ((XmlParser.Node)object).toString(false, true);
        UserRealm userRealm = this.getWebAppContext().getSecurityHandler().getUserRealm();
        for (int i = 0; userRealm == null && userRealmArray != null && i < userRealmArray.length; ++i) {
            if (userRealmArray[i] == null || !string.equals(userRealmArray[i].getName())) continue;
            userRealm = userRealmArray[i];
        }
        if (userRealm == null) {
            String string2 = "Unknown realm: " + string;
            Log.warn(string2);
        } else {
            this.getWebAppContext().getSecurityHandler().setUserRealm(userRealm);
        }
        XmlParser.Node node3 = node.get("form-login-config");
        if (node3 != null) {
            if (formAuthenticator == null) {
                Log.warn("FORM Authentication miss-configured");
            } else {
                XmlParser.Node node4;
                XmlParser.Node node5 = node3.get("form-login-page");
                if (node5 != null) {
                    formAuthenticator.setLoginPage(node5.toString(false, true));
                }
                if ((node4 = node3.get("form-error-page")) != null) {
                    String string3 = node4.toString(false, true);
                    formAuthenticator.setErrorPage(string3);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    protected String getJSPServletName() {
        PathMap.Entry entry;
        if (this._jspServletName == null && (entry = this._context.getServletHandler().getHolderEntry("test.jsp")) != null) {
            ServletHolder servletHolder = (ServletHolder)entry.getValue();
            this._jspServletName = servletHolder.getName();
        }
        return this._jspServletName;
    }
}

