/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mortbay.log.Logger;
import org.mortbay.log.StdErrLog;
import org.mortbay.util.Loader;

public class Log {
    private static final String[] __nestedEx;
    private static final Class[] __noArgs;
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED";
    public static final String IGNORED_FMT = "IGNORED: {}";
    public static final String NOT_IMPLEMENTED = "NOT IMPLEMENTED ";
    public static String __logClass;
    public static boolean __verbose;
    public static boolean __ignored;
    private static Logger __log;

    public static void setLog(Logger logger) {
        __log = logger;
    }

    public static Logger getLog() {
        return __log;
    }

    public static void debug(Throwable throwable) {
        if (__log == null || !Log.isDebugEnabled()) {
            return;
        }
        __log.debug(EXCEPTION, throwable);
        Log.unwind(throwable);
    }

    public static void debug(String string) {
        if (__log == null) {
            return;
        }
        __log.debug(string, null, null);
    }

    public static void debug(String string, Object object) {
        if (__log == null) {
            return;
        }
        __log.debug(string, object, null);
    }

    public static void debug(String string, Object object, Object object2) {
        if (__log == null) {
            return;
        }
        __log.debug(string, object, object2);
    }

    public static void ignore(Throwable throwable) {
        if (__log == null) {
            return;
        }
        if (__ignored) {
            __log.warn(IGNORED, throwable);
            Log.unwind(throwable);
        } else if (__verbose) {
            __log.debug(IGNORED, throwable);
            Log.unwind(throwable);
        }
    }

    public static void info(String string) {
        if (__log == null) {
            return;
        }
        __log.info(string, null, null);
    }

    public static void info(String string, Object object) {
        if (__log == null) {
            return;
        }
        __log.info(string, object, null);
    }

    public static void info(String string, Object object, Object object2) {
        if (__log == null) {
            return;
        }
        __log.info(string, object, object2);
    }

    public static boolean isDebugEnabled() {
        if (__log == null) {
            return false;
        }
        return __log.isDebugEnabled();
    }

    public static void warn(String string) {
        if (__log == null) {
            return;
        }
        __log.warn(string, null, null);
    }

    public static void warn(String string, Object object) {
        if (__log == null) {
            return;
        }
        __log.warn(string, object, null);
    }

    public static void warn(String string, Object object, Object object2) {
        if (__log == null) {
            return;
        }
        __log.warn(string, object, object2);
    }

    public static void warn(String string, Throwable throwable) {
        if (__log == null) {
            return;
        }
        __log.warn(string, throwable);
        Log.unwind(throwable);
    }

    public static void warn(Throwable throwable) {
        if (__log == null) {
            return;
        }
        __log.warn(EXCEPTION, throwable);
        Log.unwind(throwable);
    }

    public static Logger getLogger(String string) {
        if (__log == null) {
            return __log;
        }
        if (string == null) {
            return __log;
        }
        return __log.getLogger(string);
    }

    private static void unwind(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        for (int i = 0; i < __nestedEx.length; ++i) {
            try {
                Method method = throwable.getClass().getMethod(__nestedEx[i], __noArgs);
                Throwable throwable2 = (Throwable)method.invoke((Object)throwable, (Object[])null);
                if (throwable2 == null || throwable2 == throwable) continue;
                Log.warn("Nested in " + throwable + ":", throwable2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        Class<StdErrLog> clazz;
        block2: {
            __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
            __noArgs = new Class[0];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    __logClass = System.getProperty("org.mortbay.log.class", "org.mortbay.log.Slf4jLog");
                    __verbose = System.getProperty("VERBOSE", null) != null;
                    __ignored = System.getProperty(Log.IGNORED, null) != null;
                    return new Boolean(true);
                }
            });
            clazz = null;
            try {
                clazz = Loader.loadClass(Log.class, __logClass);
                __log = (Logger)clazz.newInstance();
            }
            catch (Throwable throwable) {
                clazz = StdErrLog.class;
                __log = new StdErrLog();
                __logClass = clazz.getName();
                if (!__verbose) break block2;
                throwable.printStackTrace();
            }
        }
        __log.info("Logging to {} via {}", __log, clazz.getName());
    }
}

