/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.mortbay.log.Log;
import org.mortbay.resource.BadResource;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.URIUtil;

public class FileResource
extends URLResource {
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", "true"));
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    public static void setCheckAliases(boolean bl) {
        __checkAliases = bl;
    }

    public static boolean getCheckAliases() {
        return __checkAliases;
    }

    public FileResource(URL uRL) throws IOException, URISyntaxException {
        super(uRL, null);
        try {
            this._file = new File(new URI(uRL.toString()));
        }
        catch (Exception exception) {
            Log.ignore(exception);
            try {
                String string = "file:" + URIUtil.encodePath(uRL.toString().substring(5));
                URI uRI = new URI(string);
                this._file = uRI.getAuthority() == null ? new File(uRI) : new File("//" + uRI.getAuthority() + URIUtil.decodePath(uRL.getFile()));
            }
            catch (Exception exception2) {
                Log.ignore(exception2);
                this.checkConnection();
                Permission permission = this._connection.getPermission();
                this._file = new File(permission == null ? uRL.getFile() : permission.getName());
            }
        }
        if (this._file.isDirectory()) {
            if (!this._urlString.endsWith("/")) {
                this._urlString = this._urlString + "/";
            }
        } else if (this._urlString.endsWith("/")) {
            this._urlString = this._urlString.substring(0, this._urlString.length() - 1);
        }
    }

    FileResource(URL uRL, URLConnection uRLConnection, File file) {
        super(uRL, uRLConnection);
        this._file = file;
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    @Override
    public Resource addPath(String string) throws IOException, MalformedURLException {
        String string2;
        URLResource uRLResource = null;
        String string3 = null;
        string = URIUtil.canonicalPath(string);
        if (!this.isDirectory()) {
            uRLResource = (FileResource)super.addPath(string);
            string3 = uRLResource._urlString;
        } else {
            if (string == null) {
                throw new MalformedURLException();
            }
            string2 = string;
            if (string.startsWith("/")) {
                string2 = string.substring(1);
            }
            string3 = URIUtil.addPaths(this._urlString, URIUtil.encodePath(string2));
            uRLResource = (URLResource)Resource.newResource(string3);
        }
        string2 = URIUtil.encodePath(string);
        int n = uRLResource.toString().length() - string2.length();
        int n2 = uRLResource._urlString.lastIndexOf(string2, n);
        if (!(n == n2 || n - 1 == n2 && !string.endsWith("/") && uRLResource.isDirectory() || uRLResource instanceof BadResource)) {
            ((FileResource)uRLResource)._alias = new URL(string3);
            ((FileResource)uRLResource)._aliasChecked = true;
        }
        return uRLResource;
    }

    @Override
    public URL getAlias() {
        if (__checkAliases && !this._aliasChecked) {
            try {
                String string = this._file.getAbsolutePath();
                String string2 = this._file.getCanonicalPath();
                if (string.length() != string2.length() || !string.equals(string2)) {
                    this._alias = new File(string2).toURI().toURL();
                }
                this._aliasChecked = true;
                if (this._alias != null && Log.isDebugEnabled()) {
                    Log.debug("ALIAS abs=" + string);
                    Log.debug("ALIAS can=" + string2);
                }
            }
            catch (Exception exception) {
                Log.warn("EXCEPTION ", exception);
                return this.getURL();
            }
        }
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource resource) throws SecurityException {
        if (resource instanceof FileResource) {
            return this._file.renameTo(((FileResource)resource)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] stringArray = this._file.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        while (n-- > 0) {
            if (!new File(this._file, stringArray[n]).isDirectory() || stringArray[n].endsWith("/")) continue;
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "/";
        }
        return stringArray;
    }

    @Override
    public String encode(String string) {
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !(object instanceof FileResource)) {
            return false;
        }
        FileResource fileResource = (FileResource)object;
        return fileResource._file == this._file || null != this._file && this._file.equals(fileResource._file);
    }

    @Override
    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    static {
        if (__checkAliases) {
            Log.debug("Checking Resource aliases");
        } else {
            Log.warn("Resource alias checking is disabled");
        }
    }
}

