/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.mortbay.log.Log;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;

class JarFileResource
extends JarResource {
    transient JarFile _jarFile;
    transient File _file;
    transient String[] _list;
    transient JarEntry _entry;
    transient boolean _directory;
    transient String _jarUrl;
    transient String _path;
    transient boolean _exists;

    JarFileResource(URL uRL) {
        super(uRL);
    }

    JarFileResource(URL uRL, boolean bl) {
        super(uRL, bl);
    }

    @Override
    public synchronized void release() {
        this._list = null;
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    @Override
    protected void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int n = this._urlString.indexOf("!/");
        this._jarUrl = this._urlString.substring(0, n + 2);
        this._path = this._urlString.substring(n + 2);
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    @Override
    public boolean exists() {
        Object object;
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String string = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(string).exists();
            }
            catch (Exception exception) {
                Log.ignore(exception);
                return false;
            }
        }
        boolean bl = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = bl;
            return true;
        }
        JarFile jarFile = null;
        if (bl) {
            jarFile = this._jarFile;
        } else {
            try {
                object = (JarURLConnection)new URL(this._jarUrl).openConnection();
                ((URLConnection)object).setUseCaches(this.getUseCaches());
                jarFile = ((JarURLConnection)object).getJarFile();
            }
            catch (Exception exception) {
                Log.ignore(exception);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)object.nextElement();
                String string = jarEntry.getName().replace('\\', '/');
                if (string.equals(this._path)) {
                    this._entry = jarEntry;
                    this._directory = this._path.endsWith("/");
                    break;
                }
                if (this._path.endsWith("/")) {
                    if (!string.startsWith(this._path)) continue;
                    this._directory = true;
                    break;
                }
                if (!string.startsWith(this._path) || string.length() <= this._path.length() || string.charAt(this._path.length()) != '/') continue;
                this._directory = true;
                break;
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }

    @Override
    public boolean isDirectory() {
        return this._urlString.endsWith("/") || this.exists() && this._directory;
    }

    @Override
    public long lastModified() {
        if (this.checkConnection() && this._file != null) {
            return this._file.lastModified();
        }
        return -1L;
    }

    @Override
    public synchronized String[] list() {
        if (this.isDirectory() && this._list == null) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>(32);
            this.checkConnection();
            JarFile jarFile = this._jarFile;
            if (jarFile == null) {
                try {
                    object = (JarURLConnection)new URL(this._jarUrl).openConnection();
                    ((URLConnection)object).setUseCaches(this.getUseCaches());
                    jarFile = ((JarURLConnection)object).getJarFile();
                }
                catch (Exception exception) {
                    Log.ignore(exception);
                }
            }
            object = jarFile.entries();
            String string = this._urlString.substring(this._urlString.indexOf("!/") + 2);
            while (object.hasMoreElements()) {
                String string2;
                int n;
                JarEntry jarEntry = (JarEntry)object.nextElement();
                String string3 = jarEntry.getName().replace('\\', '/');
                if (!string3.startsWith(string) || string3.length() == string.length() || (n = (string2 = string3.substring(string.length())).indexOf(47)) >= 0 && (n == 0 && string2.length() == 1 || arrayList.contains(string2 = n == 0 ? string2.substring(n + 1, string2.length()) : string2.substring(0, n + 1)))) continue;
                arrayList.add(string2);
            }
            this._list = new String[arrayList.size()];
            arrayList.toArray(this._list);
        }
        return this._list;
    }

    @Override
    public long length() {
        if (this.isDirectory()) {
            return -1L;
        }
        if (this._entry != null) {
            return this._entry.getSize();
        }
        return -1L;
    }

    @Override
    public String encode(String string) {
        return string;
    }

    public static Resource getNonCachingResource(Resource resource) {
        if (!(resource instanceof JarFileResource)) {
            return resource;
        }
        JarFileResource jarFileResource = (JarFileResource)resource;
        JarFileResource jarFileResource2 = new JarFileResource(jarFileResource.getURL(), false);
        return jarFileResource2;
    }
}

