/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class JarResource
extends URLResource {
    protected transient JarURLConnection _jarConnection;

    JarResource(URL uRL) {
        super(uRL, null);
    }

    JarResource(URL uRL, boolean bl) {
        super(uRL, null, bl);
    }

    @Override
    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    @Override
    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    @Override
    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return new FilterInputStream(super.getInputStream()){

                @Override
                public void close() throws IOException {
                    this.in = IO.getClosedStream();
                }
            };
        }
        URL uRL = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream inputStream = uRL.openStream();
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(Resource resource, File file, boolean bl) throws IOException {
        Object object;
        File file2;
        Object object2;
        Object object3;
        JarEntry jarEntry;
        boolean bl2;
        String string;
        int n;
        int n2;
        if (Log.isDebugEnabled()) {
            Log.debug("Extract " + resource + " to " + file);
        }
        int n3 = n2 = (n = (string = resource.getURL().toExternalForm().trim()).indexOf("!/")) >= 0 ? 4 : 0;
        if (n < 0) {
            throw new IOException("Not a valid jar url: " + string);
        }
        URL uRL = new URL(string.substring(n2, n));
        String string2 = n + 2 < string.length() ? string.substring(n + 2) : null;
        boolean bl3 = bl2 = string2 != null && string2.endsWith("/");
        if (Log.isDebugEnabled()) {
            Log.debug("Extracting entry = " + string2 + " from jar " + uRL);
        }
        InputStream inputStream = uRL.openConnection().getInputStream();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        String string3 = file.getCanonicalPath() + "/";
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            block13: {
                block12: {
                    object3 = jarEntry.getName();
                    boolean bl4 = string2 != null && ((String)object3).startsWith(string2) ? (bl2 ? !((String)(object3 = ((String)object3).substring(string2.length()))).equals("") : true) : string2 == null || ((String)object3).startsWith(string2);
                    if (!bl4) {
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug("Skipping entry: " + (String)object3);
                        continue;
                    }
                    object2 = ((String)object3).replace('\\', '/');
                    if ((object2 = URIUtil.canonicalPath((String)object2)) == null) {
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug("Invalid entry: " + (String)object3);
                        continue;
                    }
                    file2 = new File(file, (String)object3);
                    if (!jarEntry.isDirectory()) break block12;
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    break block13;
                }
                object = new File(file2.getParent());
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file2);
                    IO.copy(jarInputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    IO.close(fileOutputStream);
                    throw throwable;
                }
                IO.close(fileOutputStream);
                if (jarEntry.getTime() >= 0L) {
                    file2.setLastModified(jarEntry.getTime());
                }
            }
            if (!bl) continue;
            file2.deleteOnExit();
        }
        if ((string2 == null || string2 != null && string2.equalsIgnoreCase("META-INF/MANIFEST.MF")) && (object3 = jarInputStream.getManifest()) != null) {
            object2 = new File(file, "META-INF");
            ((File)object2).mkdir();
            file2 = new File((File)object2, "MANIFEST.MF");
            object = new FileOutputStream(file2);
            ((Manifest)object3).write((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        IO.close(jarInputStream);
    }

    public void extract(File file, boolean bl) throws IOException {
        JarResource.extract(this, file, bl);
    }
}

