/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.mortbay.log.Log;
import org.mortbay.resource.BadResource;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.JarFileResource;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.IO;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public abstract class Resource
implements Serializable {
    public static boolean __defaultUseCaches = true;
    Object _associate;

    public static void setDefaultUseCaches(boolean bl) {
        __defaultUseCaches = bl;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URL uRL) throws IOException {
        return Resource.newResource(uRL, __defaultUseCaches);
    }

    public static Resource newResource(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(uRL);
                return fileResource;
            }
            catch (Exception exception) {
                Log.debug("EXCEPTION ", exception);
                return new BadResource(uRL, exception.toString());
            }
        }
        if (string.startsWith("jar:file:")) {
            return new JarFileResource(uRL, bl);
        }
        if (string.startsWith("jar:")) {
            return new JarResource(uRL, bl);
        }
        return new URLResource(uRL, null, bl);
    }

    public static Resource newResource(String string) throws MalformedURLException, IOException {
        return Resource.newResource(string, __defaultUseCaches);
    }

    public static Resource newResource(String string, boolean bl) throws MalformedURLException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!(string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("jar:"))) {
                try {
                    if (string.startsWith("./")) {
                        string = string.substring(2);
                    }
                    File file = new File(string).getCanonicalFile();
                    uRL = new URL(URIUtil.encodePath(file.toURL().toString()));
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(bl);
                    FileResource fileResource = new FileResource(uRL, uRLConnection, file);
                    return fileResource;
                }
                catch (Exception exception) {
                    Log.debug("EXCEPTION ", exception);
                    throw malformedURLException;
                }
            }
            Log.warn("Bad Resource: " + string);
            throw malformedURLException;
        }
        String string2 = uRL.toString();
        if (!(string2.length() <= 0 || string2.charAt(string2.length() - 1) == string.charAt(string.length() - 1) || string2.charAt(string2.length() - 1) == '/' && string2.charAt(string2.length() - 2) == string.charAt(string.length() - 1) || string.charAt(string.length() - 1) == '/' && string.charAt(string.length() - 2) == string2.charAt(string2.length() - 1))) {
            return new BadResource(uRL, "Trailing special characters stripped by URL in " + string);
        }
        return Resource.newResource(uRL);
    }

    public static Resource newSystemResource(String string) throws IOException {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (classLoader = Resource.class.getClassLoader()) != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL);
    }

    public static Resource newClassPathResource(String string) {
        return Resource.newClassPathResource(string, true, false);
    }

    public static Resource newClassPathResource(String string, boolean bl, boolean bl2) {
        URL uRL = Resource.class.getResource(string);
        if (uRL == null) {
            try {
                uRL = Loader.getResource(Resource.class, string, bl2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                uRL = ClassLoader.getSystemResource(string);
            }
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL, bl);
    }

    protected void finalize() {
        this.release();
    }

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract URL getURL();

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    public String encode(String string) {
        return URIUtil.encodePath(string);
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object object) {
        this._associate = object;
    }

    public URL getAlias() {
        return null;
    }

    public String getListHTML(String string, boolean bl) throws IOException {
        if ((string = URIUtil.canonicalPath(string)) == null || !this.isDirectory()) {
            return null;
        }
        Object[] objectArray = this.list();
        if (objectArray == null) {
            return null;
        }
        Arrays.sort(objectArray);
        String string2 = URIUtil.decodePath(string);
        String string3 = "Directory: " + Resource.deTag(string2);
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("<HTML><HEAD><TITLE>");
        stringBuffer.append(string3);
        stringBuffer.append("</TITLE></HEAD><BODY>\n<H1>");
        stringBuffer.append(string3);
        stringBuffer.append("</H1>\n<TABLE BORDER=0>\n");
        if (bl) {
            stringBuffer.append("<TR><TD><A HREF=\"");
            stringBuffer.append(URIUtil.addPaths(string, "../"));
            stringBuffer.append("\">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        String string4 = Resource.defangURI(string);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < objectArray.length; ++i) {
            Resource resource = this.addPath((String)objectArray[i]);
            stringBuffer.append("\n<TR><TD><A HREF=\"");
            String string5 = URIUtil.addPaths(string4, URIUtil.encodePath((String)objectArray[i]));
            stringBuffer.append(string5);
            if (resource.isDirectory() && !string5.endsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append("\">");
            stringBuffer.append(Resource.deTag((String)objectArray[i]));
            stringBuffer.append("&nbsp;");
            stringBuffer.append("</TD><TD ALIGN=right>");
            stringBuffer.append(resource.length());
            stringBuffer.append(" bytes&nbsp;</TD><TD>");
            stringBuffer.append(dateFormat.format(new Date(resource.lastModified())));
            stringBuffer.append("</TD></TR>");
        }
        stringBuffer.append("</TABLE>\n");
        stringBuffer.append("</BODY></HTML>\n");
        return stringBuffer.toString();
    }

    private static String defangURI(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = null;
        if (stringBuffer == null) {
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '<': 
                    case '>': {
                        stringBuffer = new StringBuffer(string.length() << 1);
                    }
                }
            }
            if (stringBuffer == null) {
                return string;
            }
        }
        block10: for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("%22");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("%27");
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                    continue block10;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String deTag(String string) {
        return StringUtil.replace(StringUtil.replace(string, "<", "&lt;"), ">", "&gt;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, long l, long l2) throws IOException {
        InputStream inputStream = this.getInputStream();
        try {
            inputStream.skip(l);
            if (l2 < 0L) {
                IO.copy(inputStream, outputStream);
            } else {
                IO.copy(inputStream, outputStream, l2);
            }
        }
        finally {
            inputStream.close();
        }
    }
}

