/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mortbay.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
    }

    public ResourceCollection(Resource[] resourceArray) {
        this.setResources(resourceArray);
    }

    public ResourceCollection(String[] stringArray) {
        this.setResources(stringArray);
    }

    public ResourceCollection(String string) {
        this.setResources(string);
    }

    public void setResources(Resource[] resourceArray) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (resourceArray == null) {
            throw new IllegalArgumentException("*resources* must not be null.");
        }
        if (resourceArray.length == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        this._resources = resourceArray;
        for (int i = 0; i < this._resources.length; ++i) {
            Resource resource = this._resources[i];
            if (resource.exists() && resource.isDirectory()) continue;
            throw new IllegalArgumentException(resource + " is not an existing directory.");
        }
    }

    public void setResources(String[] stringArray) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("*resources* must not be null.");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        this._resources = new Resource[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this._resources[i] = Resource.newResource(stringArray[i]);
                if (this._resources[i].exists() && this._resources[i].isDirectory()) continue;
                throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setResources(String string) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("*csvResources* must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        this._resources = new Resource[n];
        try {
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this._resources[n2] = Resource.newResource(stringTokenizer.nextToken().trim());
                if (!this._resources[n2].exists() || !this._resources[n2].isDirectory()) {
                    throw new IllegalArgumentException(this._resources[n2] + " is not an existing directory.");
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setResourcesAsCSV(String string) {
        this.setResources(string);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    @Override
    public Resource addPath(String string) throws IOException, MalformedURLException {
        int n;
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        if (string == null) {
            throw new MalformedURLException();
        }
        if (string.length() == 0 || "/".equals(string)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> arrayList = null;
        for (n = 0; n < this._resources.length; ++n) {
            resource = this._resources[n].addPath(string);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++n;
        while (n < this._resources.length) {
            Resource resource2 = this._resources[n].addPath(string);
            if (resource2.exists() && resource2.isDirectory()) {
                if (resource != null) {
                    arrayList = new ArrayList<Resource>();
                    arrayList.add(resource);
                    resource = null;
                }
                arrayList.add(resource2);
            }
            ++n;
        }
        if (resource != null) {
            return resource;
        }
        if (arrayList != null) {
            return new ResourceCollection(arrayList.toArray(new Resource[arrayList.size()]));
        }
        return null;
    }

    protected Object findResource(String string) throws IOException, MalformedURLException {
        int n;
        Resource resource = null;
        ArrayList<Resource> arrayList = null;
        for (n = 0; n < this._resources.length; ++n) {
            resource = this._resources[n].addPath(string);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++n;
        while (n < this._resources.length) {
            Resource resource2 = this._resources[n].addPath(string);
            if (resource2.exists() && resource2.isDirectory()) {
                if (resource != null) {
                    arrayList = new ArrayList<Resource>();
                    arrayList.add(resource);
                }
                arrayList.add(resource2);
            }
            ++n;
        }
        if (resource != null) {
            return resource;
        }
        if (arrayList != null) {
            return arrayList;
        }
        return null;
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    @Override
    public File getFile() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            File file = this._resources[i].getFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            InputStream inputStream = this._resources[i].getInputStream();
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            String string = this._resources[i].getName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            OutputStream outputStream = this._resources[i].getOutputStream();
            if (outputStream == null) continue;
            return outputStream;
        }
        return null;
    }

    @Override
    public URL getURL() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            URL uRL = this._resources[i].getURL();
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    @Override
    public long lastModified() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            long l = this._resources[i].lastModified();
            if (l == -1L) continue;
            return l;
        }
        return -1L;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String[] list() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this._resources.length; ++i) {
            String[] stringArray = this._resources[i].list();
            for (int j = 0; j < stringArray.length; ++j) {
                hashSet.add(stringArray[j]);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public void release() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (int i = 0; i < this._resources.length; ++i) {
            this._resources[i].release();
        }
    }

    @Override
    public boolean renameTo(Resource resource) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this._resources == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._resources.length; ++i) {
            stringBuffer.append(this._resources[i].toString()).append(';');
        }
        return stringBuffer.toString();
    }
}

