/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    private boolean _ok;
    private File _docRoot;
    private String _path;
    private String _cmdPrefix;
    private EnvList _env;
    private boolean _ignoreExitState;

    public void init() throws ServletException {
        String string;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String string2 = this.getInitParameter("cgibinResourceBase");
        if (string2 == null && (string2 = this.getInitParameter("resourceBase")) == null) {
            string2 = this.getServletContext().getRealPath("/");
        }
        if (string2 == null) {
            Log.warn("CGI: no CGI bin !");
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            Log.warn("CGI: CGI bin does not exist - " + file);
            return;
        }
        if (!file.canRead()) {
            Log.warn("CGI: CGI bin is not readable - " + file);
            return;
        }
        if (!file.isDirectory()) {
            Log.warn("CGI: CGI bin is not a directory - " + file);
            return;
        }
        try {
            this._docRoot = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            Log.warn("CGI: CGI bin failed - " + file, iOException);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string == null || !string.startsWith("ENV_")) continue;
            this._env.set(string.substring(4), this.getInitParameter(string));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (string = System.getProperty("os.name")) != null && string.toLowerCase().indexOf("windows") != -1) {
            String string3 = System.getProperty("windir");
            this._env.set("SystemRoot", string3 != null ? string3 : "C:\\WINDOWS");
        }
        this._ok = true;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (!this._ok) {
            httpServletResponse.sendError(503);
            return;
        }
        String string2 = StringUtil.nonNull(httpServletRequest.getServletPath()) + StringUtil.nonNull(httpServletRequest.getPathInfo());
        if (Log.isDebugEnabled()) {
            Log.debug("CGI: ContextPath : " + httpServletRequest.getContextPath());
            Log.debug("CGI: ServletPath : " + httpServletRequest.getServletPath());
            Log.debug("CGI: PathInfo    : " + httpServletRequest.getPathInfo());
            Log.debug("CGI: _docRoot    : " + this._docRoot);
            Log.debug("CGI: _path       : " + this._path);
            Log.debug("CGI: _ignoreExitState: " + this._ignoreExitState);
        }
        String string3 = string = string2;
        String string4 = "";
        File file = new File(this._docRoot, string3);
        while ((string3.endsWith("/") || !file.exists()) && string3.length() >= 0) {
            int n = string3.lastIndexOf(47);
            string3 = string3.substring(0, n);
            string4 = string.substring(n, string.length());
            file = new File(this._docRoot, string3);
        }
        if (string3.length() == 0 || !file.exists() || file.isDirectory() || !file.getCanonicalPath().equals(file.getAbsolutePath())) {
            httpServletResponse.sendError(404);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("CGI: script is " + file);
                Log.debug("CGI: pathInfo is " + string4);
            }
            this.exec(file, string4, httpServletRequest, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File file, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        String string2;
        String string3 = file.getAbsolutePath();
        File file2 = file.getParentFile();
        String string4 = httpServletRequest.getRequestURI().substring(0, httpServletRequest.getRequestURI().length() - string.length());
        String string5 = this.getServletContext().getRealPath(string4);
        String string6 = httpServletRequest.getPathTranslated();
        int n = httpServletRequest.getContentLength();
        if (n < 0) {
            n = 0;
        }
        if (string6 == null || string6.length() == 0) {
            string6 = string3;
        }
        EnvList envList = new EnvList(this._env);
        envList.set("AUTH_TYPE", httpServletRequest.getAuthType());
        envList.set("CONTENT_LENGTH", Integer.toString(n));
        envList.set("CONTENT_TYPE", httpServletRequest.getContentType());
        envList.set("GATEWAY_INTERFACE", "CGI/1.1");
        if (string != null && string.length() > 0) {
            envList.set("PATH_INFO", string);
        }
        envList.set("PATH_TRANSLATED", string6);
        envList.set("QUERY_STRING", httpServletRequest.getQueryString());
        envList.set("REMOTE_ADDR", httpServletRequest.getRemoteAddr());
        envList.set("REMOTE_HOST", httpServletRequest.getRemoteHost());
        envList.set("REMOTE_USER", httpServletRequest.getRemoteUser());
        envList.set("REQUEST_METHOD", httpServletRequest.getMethod());
        envList.set("SCRIPT_NAME", string4);
        envList.set("SCRIPT_FILENAME", string5);
        envList.set("SERVER_NAME", httpServletRequest.getServerName());
        envList.set("SERVER_PORT", Integer.toString(httpServletRequest.getServerPort()));
        envList.set("SERVER_PROTOCOL", httpServletRequest.getProtocol());
        envList.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object = httpServletRequest.getHeader(string2);
            envList.set("HTTP_" + string2.toUpperCase().replace('-', '_'), (String)object);
        }
        envList.set("HTTPS", httpServletRequest.isSecure() ? "ON" : "OFF");
        string2 = string3;
        if (string2.charAt(0) != '\"' && string2.indexOf(" ") >= 0) {
            string2 = "\"" + string2 + "\"";
        }
        if (this._cmdPrefix != null) {
            string2 = this._cmdPrefix + " " + string2;
        }
        object = file2 == null ? Runtime.getRuntime().exec(string2, envList.getEnvArray()) : Runtime.getRuntime().exec(string2, envList.getEnvArray(), file2);
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        OutputStream outputStream = ((Process)object).getOutputStream();
        final int n2 = n;
        IO.copyThread(((Process)object).getErrorStream(), System.err);
        new Thread(new Runnable((InputStream)servletInputStream, outputStream){
            final /* synthetic */ InputStream val$inFromReq;
            final /* synthetic */ OutputStream val$outToCgi;
            {
                this.val$inFromReq = inputStream;
                this.val$outToCgi = outputStream;
            }

            @Override
            public void run() {
                try {
                    if (n2 > 0) {
                        IO.copy(this.val$inFromReq, this.val$outToCgi, (long)n2);
                    }
                    this.val$outToCgi.close();
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
        }).start();
        OutputStream outputStream2 = null;
        try {
            int n3;
            String string7 = null;
            InputStream inputStream = ((Process)object).getInputStream();
            while ((string7 = this.getTextLineFromStream(inputStream)).length() > 0) {
                if (string7.startsWith("HTTP") || (n3 = string7.indexOf(58)) <= 0) continue;
                String string8 = string7.substring(0, n3).trim();
                String string9 = string7.substring(n3 + 1).trim();
                if ("Location".equals(string8)) {
                    httpServletResponse.sendRedirect(string9);
                    continue;
                }
                if ("Status".equals(string8)) {
                    String[] stringArray = string9.split(" ");
                    int n4 = Integer.parseInt(stringArray[0]);
                    httpServletResponse.setStatus(n4);
                    continue;
                }
                httpServletResponse.addHeader(string8, string9);
            }
            outputStream2 = httpServletResponse.getOutputStream();
            IO.copy(inputStream, outputStream2);
            ((Process)object).waitFor();
            if (!this._ignoreExitState && 0 != (n3 = ((Process)object).exitValue())) {
                Log.warn("Non-zero exit status (" + n3 + ") from CGI program: " + string3);
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException iOException) {
            Log.debug("CGI: Client closed connection!");
        }
        catch (InterruptedException interruptedException) {
            Log.debug("CGI: interrupted!");
        }
        finally {
            if (outputStream2 != null) {
                try {
                    outputStream2.close();
                }
                catch (Exception exception) {
                    Log.ignore(exception);
                }
            }
            outputStream2 = null;
            ((Process)object).destroy();
        }
    }

    private String getTextLineFromStream(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString().trim();
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList envList) {
            this.envMap = new HashMap(envList.envMap);
        }

        public void set(String string, String string2) {
            this.envMap.put(string, string + "=" + StringUtil.nonNull(string2));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

