/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class MultiPartFilter
implements Filter {
    private static final String FILES = "org.mortbay.servlet.MultiPartFilter.files";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String string = filterConfig.getInitParameter("fileOutputBuffer");
        if (string != null) {
            this._fileOutputBuffer = Integer.parseInt(string);
        }
        this._context = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)servletRequest.getInputStream());
        String string = httpServletRequest.getContentType();
        String string2 = "--" + this.value(string.substring(string.indexOf("boundary=")));
        byte[] byArray = (string2 + "--").getBytes(StringUtil.__ISO_8859_1);
        MultiMap multiMap = new MultiMap();
        for (Map.Entry object : servletRequest.getParameterMap().entrySet()) {
            Object v = object.getValue();
            if (v instanceof String[]) {
                multiMap.addValues(object.getKey(), (String[])v);
                continue;
            }
            multiMap.add(object.getKey(), v);
        }
        try {
            String string3;
            Object object2 = TypeUtil.readLine(bufferedInputStream);
            String string4 = string3 = object2 == null ? null : new String((byte[])object2, "UTF-8");
            if (string3 == null || !string3.equals(string2)) {
                throw new IOException("Missing initial multi part boundary");
            }
            boolean bl = false;
            String string5 = null;
            while (!bl) {
                Object object;
                Object object3;
                String string6;
                Object object4;
                int n;
                while ((object2 = (Object)TypeUtil.readLine(bufferedInputStream)) != null && ((Object)object2).length != 0) {
                    String string7 = new String((byte[])object2, "UTF-8");
                    n = string7.indexOf(58, 0);
                    if (n <= 0) continue;
                    object4 = string7.substring(0, n).trim().toLowerCase();
                    string6 = string7.substring(n + 1, string7.length()).trim();
                    if (!((String)object4).equals("content-disposition")) continue;
                    string5 = string6;
                }
                n = 0;
                if (string5 == null) {
                    throw new IOException("Missing content-disposition");
                }
                object4 = new StringTokenizer(string5, ";");
                string6 = null;
                String string8 = null;
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object4).nextToken().trim();
                    object = ((String)object3).toLowerCase();
                    if (((String)object3).startsWith("form-data")) {
                        n = 1;
                        continue;
                    }
                    if (((String)object).startsWith("name=")) {
                        string6 = this.value((String)object3);
                        continue;
                    }
                    if (!((String)object).startsWith("filename=")) continue;
                    string8 = this.value((String)object3);
                }
                if (n == 0 || string6 == null) continue;
                object3 = null;
                object = null;
                try {
                    if (string8 != null && string8.length() > 0) {
                        object = File.createTempFile("MultiPart", "", this.tempdir);
                        object3 = new FileOutputStream((File)object);
                        if (this._fileOutputBuffer > 0) {
                            object3 = new BufferedOutputStream((OutputStream)object3, this._fileOutputBuffer);
                        }
                        servletRequest.setAttribute(string6, object);
                        multiMap.add(string6, string8);
                        if (this._deleteFiles) {
                            ((File)object).deleteOnExit();
                            ArrayList<Object> arrayList = (ArrayList<Object>)servletRequest.getAttribute(FILES);
                            if (arrayList == null) {
                                arrayList = new ArrayList<Object>();
                                servletRequest.setAttribute(FILES, arrayList);
                            }
                            arrayList.add(object);
                        }
                    } else {
                        object3 = new ByteArrayOutputStream();
                    }
                    int n2 = -2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (true) {
                        int n3;
                        int n4 = 0;
                        while ((n3 = n2 != -2 ? n2 : bufferedInputStream.read()) != -1) {
                            n2 = -2;
                            if (n3 == 13 || n3 == 10) {
                                if (n3 != 13) break;
                                n2 = bufferedInputStream.read();
                                break;
                            }
                            if (n4 >= 0 && n4 < byArray.length && n3 == byArray[n4]) {
                                ++n4;
                                continue;
                            }
                            if (bl2) {
                                ((OutputStream)object3).write(13);
                            }
                            if (bl3) {
                                ((OutputStream)object3).write(10);
                            }
                            bl3 = false;
                            bl2 = false;
                            if (n4 > 0) {
                                ((OutputStream)object3).write(byArray, 0, n4);
                            }
                            n4 = -1;
                            ((OutputStream)object3).write(n3);
                        }
                        if (n4 > 0 && n4 < byArray.length - 2 || n4 == byArray.length - 1) {
                            if (bl2) {
                                ((OutputStream)object3).write(13);
                            }
                            if (bl3) {
                                ((OutputStream)object3).write(10);
                            }
                            bl3 = false;
                            bl2 = false;
                            ((OutputStream)object3).write(byArray, 0, n4);
                            n4 = -1;
                        }
                        if (n4 > 0 || n3 == -1) {
                            if (n4 == byArray.length) {
                                bl = true;
                            }
                            if (n2 == 10) {
                                n2 = -2;
                            }
                            break;
                        }
                        if (bl2) {
                            ((OutputStream)object3).write(13);
                        }
                        if (bl3) {
                            ((OutputStream)object3).write(10);
                        }
                        bl2 = n3 == 13;
                        boolean bl4 = bl3 = n3 == 10 || n2 == 10;
                        if (n2 != 10) continue;
                        n2 = -2;
                    }
                }
                finally {
                    ((OutputStream)object3).close();
                }
                if (object != null) continue;
                object2 = ((ByteArrayOutputStream)object3).toByteArray();
                multiMap.add(string6, object2);
            }
            filterChain.doFilter((ServletRequest)new Wrapper(httpServletRequest, multiMap), servletResponse);
        }
        finally {
            this.deleteFiles(servletRequest);
        }
    }

    private void deleteFiles(ServletRequest servletRequest) {
        ArrayList arrayList = (ArrayList)servletRequest.getAttribute(FILES);
        if (arrayList != null) {
            for (File file : arrayList) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    this._context.log("failed to delete " + file, (Throwable)exception);
                }
            }
        }
    }

    private String value(String string) {
        String string2 = string.substring(string.indexOf(61) + 1).trim();
        int n = string2.indexOf(59);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.indexOf(34, 1));
        } else {
            n = string2.indexOf(32);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap map;

        public Wrapper(HttpServletRequest httpServletRequest, MultiMap multiMap) {
            super(httpServletRequest);
            this.map = multiMap;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String string) {
            Object object = this.map.get(string);
            if (!(object instanceof byte[]) && LazyList.size(object) > 0) {
                object = LazyList.get(object, 0);
            }
            if (object instanceof byte[]) {
                try {
                    String string2 = new String((byte[])object, this.encoding);
                    return string2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (object != null) {
                return String.valueOf(object);
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.map.toStringArrayMap());
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public String[] getParameterValues(String string) {
            List list = this.map.getValues(string);
            if (list == null || list.size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e instanceof byte[]) {
                    try {
                        stringArray[i] = new String((byte[])e, this.encoding);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (!(e instanceof String)) continue;
                stringArray[i] = (String)e;
            }
            return stringArray;
        }

        public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
            this.encoding = string;
        }
    }
}

