/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.IO;

public class ProxyServlet
implements Servlet {
    protected HashSet _DontProxyHeaders = new HashSet();
    protected ServletConfig _config;
    protected ServletContext _context;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this._config = servletConfig;
        this._context = servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if ("CONNECT".equalsIgnoreCase(httpServletRequest.getMethod())) {
            this.handleConnect(httpServletRequest, httpServletResponse);
        } else {
            Object object;
            String string;
            String string2;
            String string3 = httpServletRequest.getRequestURI();
            if (httpServletRequest.getQueryString() != null) {
                string3 = string3 + "?" + httpServletRequest.getQueryString();
            }
            URL uRL = this.proxyHttpURL(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort(), string3);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(false);
            HttpURLConnection httpURLConnection = null;
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod(httpServletRequest.getMethod());
                httpURLConnection.setInstanceFollowRedirects(false);
            }
            if ((string2 = httpServletRequest.getHeader("Connection")) != null && ((string2 = string2.toLowerCase()).equals("keep-alive") || string2.equals("close"))) {
                string2 = null;
            }
            boolean bl = false;
            boolean bl2 = false;
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = string.toLowerCase();
                if (this._DontProxyHeaders.contains(object) || string2 != null && string2.indexOf((String)object) >= 0) continue;
                if ("content-type".equals(object)) {
                    bl2 = true;
                }
                Enumeration enumeration2 = httpServletRequest.getHeaders(string);
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    if (string4 == null) continue;
                    uRLConnection.addRequestProperty(string, string4);
                    bl |= "X-Forwarded-For".equalsIgnoreCase(string);
                }
            }
            uRLConnection.setRequestProperty("Via", "1.1 (jetty)");
            if (!bl) {
                uRLConnection.addRequestProperty("X-Forwarded-For", httpServletRequest.getRemoteAddr());
            }
            if ((string = httpServletRequest.getHeader("Cache-Control")) != null && (string.indexOf("no-cache") >= 0 || string.indexOf("no-store") >= 0)) {
                uRLConnection.setUseCaches(false);
            }
            try {
                uRLConnection.setDoInput(true);
                object = httpServletRequest.getInputStream();
                if (bl2) {
                    uRLConnection.setDoOutput(true);
                    IO.copy((InputStream)object, uRLConnection.getOutputStream());
                }
                uRLConnection.connect();
            }
            catch (Exception exception) {
                this._context.log("proxy", (Throwable)exception);
            }
            object = null;
            int n = 500;
            if (httpURLConnection != null) {
                object = httpURLConnection.getErrorStream();
                n = httpURLConnection.getResponseCode();
                httpServletResponse.setStatus(n, httpURLConnection.getResponseMessage());
            }
            if (object == null) {
                try {
                    object = uRLConnection.getInputStream();
                }
                catch (Exception exception) {
                    this._context.log("stream", (Throwable)exception);
                    object = httpURLConnection.getErrorStream();
                }
            }
            httpServletResponse.setHeader("Date", null);
            httpServletResponse.setHeader("Server", null);
            int n2 = 0;
            String string5 = uRLConnection.getHeaderFieldKey(n2);
            String string6 = uRLConnection.getHeaderField(n2);
            while (string5 != null || string6 != null) {
                String string7;
                String string8 = string7 = string5 != null ? string5.toLowerCase() : null;
                if (string5 != null && string6 != null && !this._DontProxyHeaders.contains(string7)) {
                    httpServletResponse.addHeader(string5, string6);
                }
                string5 = uRLConnection.getHeaderFieldKey(++n2);
                string6 = uRLConnection.getHeaderField(n2);
            }
            httpServletResponse.addHeader("Via", "1.1 (jetty)");
            if (object != null) {
                IO.copy((InputStream)object, (OutputStream)httpServletResponse.getOutputStream());
            }
        }
    }

    protected URL proxyHttpURL(String string, String string2, int n, String string3) throws MalformedURLException {
        return new URL(string, string2, n, string3);
    }

    public void handleConnect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getRequestURI();
        String string2 = "";
        String string3 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
            if (string3.indexOf(47) > 0) {
                string3 = string3.substring(string3.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string3, Integer.parseInt(string2));
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        Socket socket = new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Connection", "close");
        httpServletResponse.flushBuffer();
        IO.copyThread(socket.getInputStream(), (OutputStream)servletOutputStream);
        IO.copy((InputStream)servletInputStream, socket.getOutputStream());
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }

    public static class Transparent
    extends ProxyServlet {
        String _prefix;
        String _proxyTo;

        public Transparent() {
        }

        public Transparent(String string, String string2, int n) {
            this._prefix = string;
            this._proxyTo = "http://" + string2 + ":" + n;
        }

        @Override
        public void init(ServletConfig servletConfig) throws ServletException {
            if (servletConfig.getInitParameter("ProxyTo") != null) {
                this._proxyTo = servletConfig.getInitParameter("ProxyTo");
            }
            if (servletConfig.getInitParameter("Prefix") != null) {
                this._prefix = servletConfig.getInitParameter("Prefix");
            }
            if (this._proxyTo == null) {
                throw new UnavailableException("No ProxyTo");
            }
            super.init(servletConfig);
            this._context.log("Transparent ProxyServlet @ " + (this._prefix == null ? "-" : this._prefix) + " to " + this._proxyTo);
        }

        @Override
        protected URL proxyHttpURL(String string, String string2, int n, String string3) throws MalformedURLException {
            if (this._prefix != null && !string3.startsWith(this._prefix)) {
                return null;
            }
            if (this._prefix != null) {
                return new URL(this._proxyTo + string3.substring(this._prefix.length()));
            }
            return new URL(this._proxyTo + string3);
        }
    }
}

