/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class RestFilter
implements Filter {
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private FilterConfig filterConfig;
    private long _maxPutSize;

    public void init(FilterConfig filterConfig) throws UnavailableException {
        this.filterConfig = filterConfig;
        String string = filterConfig.getInitParameter("maxPutSize");
        if (string != null) {
            this._maxPutSize = Long.parseLong(string);
        }
    }

    private File locateFile(HttpServletRequest httpServletRequest) {
        return new File(this.filterConfig.getServletContext().getRealPath(URIUtil.addPaths(httpServletRequest.getServletPath(), httpServletRequest.getPathInfo())));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (httpServletRequest.getMethod().equals(HTTP_METHOD_GET)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else if (httpServletRequest.getMethod().equals(HTTP_METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (httpServletRequest.getMethod().equals(HTTP_METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        File file = this.locateFile(httpServletRequest);
        if (file.exists() && !(bl = file.delete())) {
            httpServletResponse.sendError(403);
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            if (this._maxPutSize > 0L) {
                int n = httpServletRequest.getContentLength();
                if ((long)n > this._maxPutSize) {
                    httpServletResponse.sendError(403);
                    return;
                }
                IO.copy((InputStream)httpServletRequest.getInputStream(), fileOutputStream, this._maxPutSize);
            } else {
                IO.copy((InputStream)httpServletRequest.getInputStream(), fileOutputStream);
            }
        }
        finally {
            fileOutputStream.close();
        }
        httpServletResponse.setStatus(204);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        File file = this.locateFile(httpServletRequest);
        if (!file.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        boolean bl = IO.delete(file);
        if (bl) {
            httpServletResponse.setStatus(204);
        } else {
            httpServletResponse.sendError(500);
        }
    }

    public void destroy() {
    }
}

