/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.ajax.Continuation;

public class ThrottlingFilter
implements Filter {
    private int _maximum;
    private int _current = 0;
    private long _queueTimeout;
    private long _queueSize;
    private final Object _lock = new Object();
    private final List _queue = new LinkedList();

    public void init(FilterConfig filterConfig) throws ServletException {
        this._maximum = this.getIntegerParameter(filterConfig, "maximum", 10);
        this._queueTimeout = this.getIntegerParameter(filterConfig, "block", 5000);
        this._queueSize = this.getIntegerParameter(filterConfig, "queue", 500);
        if (this._queueTimeout == -1L) {
            this._queueTimeout = Integer.MAX_VALUE;
        }
        Log.debug("Config{maximum:" + this._maximum + ", block:" + this._queueTimeout + ", queue:" + this._queueSize + "}", null, null);
    }

    private int getIntegerParameter(FilterConfig filterConfig, String string, int n) throws ServletException {
        String string2 = filterConfig.getInitParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("Parameter " + string + " must be a number (was " + string2 + " instead)");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Continuation continuation = this.getContinuation((ServletRequest)httpServletRequest);
        boolean bl = false;
        try {
            bl = this.acceptRequest();
            if (!bl) {
                if (continuation.isPending()) {
                    Log.debug("Request {} / {} was already queued, rejecting", httpServletRequest.getRequestURI(), continuation);
                    this.dropFromQueue(continuation);
                    continuation.reset();
                } else if (this.queueRequest(httpServletRequest, httpServletResponse, continuation)) {
                    bl = this.acceptRequest();
                }
            }
            if (bl) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                this.rejectRequest(httpServletRequest, httpServletResponse);
            }
        }
        finally {
            if (bl) {
                this.releaseRequest();
                this.popQueue();
            }
        }
    }

    private void dropFromQueue(Continuation continuation) {
        this._queue.remove(continuation);
        continuation.reset();
    }

    protected void rejectRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendError(503, "Too many active connections to resource " + httpServletRequest.getRequestURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popQueue() {
        Continuation continuation;
        List list = this._queue;
        synchronized (list) {
            if (this._queue.isEmpty()) {
                return;
            }
            continuation = (Continuation)this._queue.remove(0);
        }
        Log.debug("Resuming continuation {}", continuation, null);
        continuation.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRequest() {
        Object object = this._lock;
        synchronized (object) {
            --this._current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acceptRequest() {
        Object object = this._lock;
        synchronized (object) {
            if (this._current < this._maximum) {
                ++this._current;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Continuation continuation) throws IOException, ServletException {
        List list = this._queue;
        synchronized (list) {
            if ((long)this._queue.size() >= this._queueSize) {
                Log.debug("Queue is full, rejecting request {}", httpServletRequest.getRequestURI(), null);
                return false;
            }
            Log.debug("Queuing request {} / {}", httpServletRequest.getRequestURI(), continuation);
            this._queue.add(continuation);
        }
        continuation.suspend(this._queueTimeout);
        Log.debug("Resuming blocking continuation for request {}", httpServletRequest.getRequestURI(), null);
        return true;
    }

    private Continuation getContinuation(ServletRequest servletRequest) {
        return (Continuation)servletRequest.getAttribute("org.mortbay.jetty.ajax.Continuation");
    }

    public void destroy() {
        this._queue.clear();
    }
}

