/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class UserAgentFilter
implements Filter {
    private Pattern _pattern;
    private Map _agentCache = new HashMap();
    private int _agentCacheSize = 1024;
    private String _attribute;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this._attribute != null && this._pattern != null) {
            String string = this.getUserAgent(servletRequest);
            servletRequest.setAttribute(this._attribute, (Object)string);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        this._attribute = filterConfig.getInitParameter("attribute");
        String string2 = filterConfig.getInitParameter("userAgent");
        if (string2 != null) {
            this._pattern = Pattern.compile(string2);
        }
        if ((string = filterConfig.getInitParameter("cacheSize")) != null) {
            this._agentCacheSize = Integer.parseInt(string);
        }
    }

    public String getUserAgent(ServletRequest servletRequest) {
        String string = ((HttpServletRequest)servletRequest).getHeader("User-Agent");
        return this.getUserAgent(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        Object object = this._agentCache;
        synchronized (object) {
            string2 = (String)this._agentCache.get(string);
        }
        if (string2 == null) {
            object = this._pattern.matcher(string);
            if (((Matcher)object).matches()) {
                if (((Matcher)object).groupCount() > 0) {
                    for (int i = 1; i <= ((Matcher)object).groupCount(); ++i) {
                        String string3 = ((Matcher)object).group(i);
                        if (string3 == null) continue;
                        string2 = string2 == null ? string3 : string2 + string3;
                    }
                } else {
                    string2 = ((Matcher)object).group();
                }
            } else {
                string2 = string;
            }
            Map map = this._agentCache;
            synchronized (map) {
                if (this._agentCache.size() >= this._agentCacheSize) {
                    this._agentCache.clear();
                }
                this._agentCache.put(string, string2);
            }
        }
        return string2;
    }
}

