/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.UncheckedPrintWriter;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.servlet.GzipFilter;

public class IncludableGzipFilter
extends GzipFilter {
    boolean _uncheckedPrintWriter = false;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String string = filterConfig.getInitParameter("uncheckedPrintWriter");
        if (string != null) {
            this._uncheckedPrintWriter = Boolean.valueOf(string);
        }
    }

    @Override
    protected GzipFilter.GZIPResponseWrapper newGZIPResponseWrapper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new IncludableResponseWrapper(httpServletRequest, httpServletResponse);
    }

    @Override
    protected PrintWriter newWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (this._uncheckedPrintWriter) {
            return string == null ? new UncheckedPrintWriter(outputStream) : new UncheckedPrintWriter(new OutputStreamWriter(outputStream, string));
        }
        return super.newWriter(outputStream, string);
    }

    public class IncludableGzipStream
    extends GzipFilter.GzipStream {
        public IncludableGzipStream(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l, int n, int n2) throws IOException {
            super(httpServletRequest, httpServletResponse, l, n, n2);
        }

        @Override
        protected boolean setContentEncodingGzip() {
            HttpConnection httpConnection = HttpConnection.getCurrentConnection();
            httpConnection.getResponseFields().put("Content-Encoding", "gzip");
            return true;
        }
    }

    public class IncludableResponseWrapper
    extends GzipFilter.GZIPResponseWrapper {
        public IncludableResponseWrapper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(httpServletRequest, httpServletResponse);
        }

        @Override
        protected GzipFilter.GzipStream newGzipStream(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l, int n, int n2) throws IOException {
            return new IncludableGzipStream(httpServletRequest, httpServletResponse, l, n, n2);
        }
    }
}

