/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static int __id;
    private boolean _daemon;
    private int _id;
    private List _idle;
    private final Object _lock = new Object();
    private final Object _joinLock = new Object();
    private long _lastShrink;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private String _name = "btpool" + __id++;
    private List _queue;
    private Set _threads;
    private boolean _warned = false;
    int _lowThreads = 0;
    int _priority = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(Runnable runnable) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isRunning() || runnable == null) {
                return false;
            }
            int n = this._idle.size();
            if (n > 0) {
                PoolThread poolThread = (PoolThread)this._idle.remove(n - 1);
                poolThread.dispatch(runnable);
            } else if (this._threads.size() < this._maxThreads) {
                this.newThread(runnable);
            } else {
                if (!this._warned) {
                    this._warned = true;
                    Log.debug("Out of threads for {}", this);
                }
                this._queue.add(runnable);
            }
        }
        return true;
    }

    @Override
    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.size();
        }
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLowOnThreads() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.size() > this._lowThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(10L);
        }
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
    }

    public void setLowThreads(int n) {
        this._lowThreads = n;
    }

    public void setMaxIdleTimeMs(int n) {
        this._maxIdleTimeMs = n;
    }

    public void setMaxThreads(int n) {
        if (this.isStarted() && n < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int n) {
        if (this.isStarted() && (n <= 0 || n > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = n;
        Object object = this._lock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread(null);
            }
        }
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setThreadsPriority(int n) {
        this._priority = n;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._queue = new LinkedList();
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < 100; ++i) {
            Object object = this._lock;
            synchronized (object) {
                Iterator iterator = this._threads.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolThread newThread(Runnable runnable) {
        Object object = this._lock;
        synchronized (object) {
            PoolThread poolThread = new PoolThread(runnable);
            this._threads.add(poolThread);
            poolThread.setName(this._name + "-" + this._id++);
            poolThread.start();
            return poolThread;
        }
    }

    protected void stopJob(Thread thread, Object object) {
        thread.interrupt();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        PoolThread(Runnable runnable) {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
            this._job = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = null;
                Object object2 = this;
                synchronized (object2) {
                    object = this._job;
                    this._job = null;
                }
                while (BoundedThreadPool.this.isRunning()) {
                    if (object != null) {
                        object2 = object;
                        object = null;
                        object2.run();
                        continue;
                    }
                    object2 = BoundedThreadPool.this._lock;
                    synchronized (object2) {
                        block51: {
                            long l;
                            if (BoundedThreadPool.this._queue.size() > 0) {
                                object = (Runnable)BoundedThreadPool.this._queue.remove(0);
                                continue;
                            }
                            BoundedThreadPool.this._warned = false;
                            if (BoundedThreadPool.this._threads.size() <= BoundedThreadPool.this._maxThreads && (BoundedThreadPool.this._idle.size() <= 0 || BoundedThreadPool.this._threads.size() <= BoundedThreadPool.this._minThreads) || (l = System.currentTimeMillis()) - BoundedThreadPool.this._lastShrink <= (long)BoundedThreadPool.this.getMaxIdleTimeMs()) break block51;
                            BoundedThreadPool.this._lastShrink = l;
                            return;
                        }
                        BoundedThreadPool.this._idle.add(this);
                    }
                    try {
                        object2 = this;
                        synchronized (object2) {
                            if (this._job == null) {
                                this.wait(BoundedThreadPool.this.getMaxIdleTimeMs());
                            }
                            object = this._job;
                            this._job = null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Log.ignore(interruptedException);
                    }
                    finally {
                        object2 = BoundedThreadPool.this._lock;
                        synchronized (object2) {
                            BoundedThreadPool.this._idle.remove(this);
                        }
                    }
                }
            }
            finally {
                Object object = BoundedThreadPool.this._lock;
                synchronized (object) {
                    BoundedThreadPool.this._threads.remove(this);
                }
                object = null;
                PoolThread poolThread = this;
                synchronized (poolThread) {
                    object = this._job;
                }
                if (object != null && BoundedThreadPool.this.isRunning()) {
                    BoundedThreadPool.this.dispatch((Runnable)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable runnable) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || runnable == null) {
                    throw new IllegalStateException();
                }
                this._job = runnable;
                this.notify();
            }
        }
    }
}

