/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class QueuedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private String _name;
    private Set _threads;
    private List _idle;
    private Runnable[] _jobs;
    private int _nextJob;
    private int _nextJobSlot;
    private int _queued;
    private int _maxQueued;
    private boolean _daemon;
    private int _id;
    private final Object _lock = new Lock();
    private final Object _threadsLock = new Lock();
    private final Object _joinLock = new Lock();
    private long _lastShrink;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 250;
    private int _minThreads = 2;
    private boolean _warned = false;
    private int _lowThreads = 0;
    private int _priority = 5;
    private int _spawnOrShrinkAt = 0;
    private int _maxStopTimeMs;

    public QueuedThreadPool() {
        this._name = "qtp-" + this.hashCode();
    }

    public QueuedThreadPool(int n) {
        this();
        this.setMaxThreads(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(Runnable runnable) {
        if (!this.isRunning() || runnable == null) {
            return false;
        }
        PoolThread poolThread = null;
        boolean bl = false;
        Object object = this._lock;
        synchronized (object) {
            int n = this._idle.size();
            if (n > 0) {
                poolThread = (PoolThread)this._idle.remove(n - 1);
            } else {
                ++this._queued;
                if (this._queued > this._maxQueued) {
                    this._maxQueued = this._queued;
                }
                this._jobs[this._nextJobSlot++] = runnable;
                if (this._nextJobSlot == this._jobs.length) {
                    this._nextJobSlot = 0;
                }
                if (this._nextJobSlot == this._nextJob) {
                    Runnable[] runnableArray = new Runnable[this._jobs.length + this._maxThreads];
                    int n2 = this._jobs.length - this._nextJob;
                    if (n2 > 0) {
                        System.arraycopy(this._jobs, this._nextJob, runnableArray, 0, n2);
                    }
                    if (this._nextJob != 0) {
                        System.arraycopy(this._jobs, 0, runnableArray, n2, this._nextJobSlot);
                    }
                    this._jobs = runnableArray;
                    this._nextJob = 0;
                    this._nextJobSlot = this._queued;
                }
                bl = this._queued > this._spawnOrShrinkAt;
            }
        }
        if (poolThread != null) {
            poolThread.dispatch(runnable);
        } else if (bl) {
            this.newThread();
        }
        return true;
    }

    @Override
    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxQueued() {
        return this._maxQueued;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public int getQueueSize() {
        return this._queued;
    }

    public int getSpawnOrShrinkAt() {
        return this._spawnOrShrinkAt;
    }

    public void setSpawnOrShrinkAt(int n) {
        this._spawnOrShrinkAt = n;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTimeMs;
    }

    public void setMaxStopTimeMs(int n) {
        this._maxStopTimeMs = n;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    @Override
    public boolean isLowOnThreads() {
        return this._queued > this._lowThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(100L);
        }
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
    }

    public void setLowThreads(int n) {
        this._lowThreads = n;
    }

    public void setMaxIdleTimeMs(int n) {
        this._maxIdleTimeMs = n;
    }

    public void setMaxThreads(int n) {
        if (this.isStarted() && n < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int n) {
        if (this.isStarted() && (n <= 0 || n > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = n;
        Object object = this._threadsLock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread();
            }
        }
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setThreadsPriority(int n) {
        this._priority = n;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._jobs = new Runnable[this._maxThreads];
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Object object = this._threadsLock;
            synchronized (object) {
                Iterator iterator = this._threads.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0 || this._maxStopTimeMs > 0 && (long)this._maxStopTimeMs < System.currentTimeMillis() - l) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        Object object = this._threadsLock;
        synchronized (object) {
            if (this._threads.size() < this._maxThreads) {
                PoolThread poolThread = new PoolThread();
                this._threads.add(poolThread);
                poolThread.setName(poolThread.hashCode() + "@" + this._name + "-" + this._id++);
                poolThread.start();
            } else if (!this._warned) {
                this._warned = true;
                Log.debug("Max threads for {}", this);
            }
        }
    }

    protected void stopJob(Thread thread, Object object) {
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this._threadsLock;
        synchronized (object) {
            for (Thread thread : this._threads) {
                stringBuffer.append(thread.getName()).append(" ").append(thread.toString()).append('\n');
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopThread(String string) {
        Object object = this._threadsLock;
        synchronized (object) {
            for (Thread thread : this._threads) {
                if (!string.equals(thread.getName())) continue;
                thread.stop();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interruptThread(String string) {
        Object object = this._threadsLock;
        synchronized (object) {
            for (Thread thread : this._threads) {
                if (!string.equals(thread.getName())) continue;
                thread.interrupt();
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Object access$1300(QueuedThreadPool queuedThreadPool) {
        return queuedThreadPool._threadsLock;
    }

    private class Lock {
        private Lock() {
        }
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(QueuedThreadPool.this._daemon);
            this.setPriority(QueuedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean bl = false;
            Object object = null;
            try {
                while (QueuedThreadPool.this.isRunning()) {
                    long l;
                    Object object2;
                    if (object != null) {
                        object2 = object;
                        object = null;
                        bl = false;
                        object2.run();
                    }
                    object2 = QueuedThreadPool.this._lock;
                    // MONITORENTER : object2
                    if (QueuedThreadPool.this._queued > 0) {
                        QueuedThreadPool.this._queued--;
                        object = QueuedThreadPool.this._jobs[QueuedThreadPool.this._nextJob++];
                        if (QueuedThreadPool.this._nextJob == QueuedThreadPool.this._jobs.length) {
                            QueuedThreadPool.this._nextJob = 0;
                        }
                        // MONITOREXIT : object2
                        continue;
                    }
                    int n = QueuedThreadPool.this._threads.size();
                    if (n > QueuedThreadPool.this._minThreads && (n > QueuedThreadPool.this._maxThreads || QueuedThreadPool.this._idle.size() > QueuedThreadPool.this._spawnOrShrinkAt) && (l = System.currentTimeMillis()) - QueuedThreadPool.this._lastShrink > (long)QueuedThreadPool.this.getMaxIdleTimeMs()) {
                        QueuedThreadPool.this._lastShrink = l;
                        QueuedThreadPool.this._idle.remove(this);
                        // MONITOREXIT : object2
                        return;
                    }
                    if (!bl) {
                        QueuedThreadPool.this._idle.add(this);
                        bl = true;
                    }
                    // MONITOREXIT : object2
                    object2 = this;
                    // MONITORENTER : object2
                    if (this._job == null) {
                        this.wait(QueuedThreadPool.this.getMaxIdleTimeMs());
                    }
                    object = this._job;
                    this._job = null;
                    // MONITOREXIT : object2
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                Log.ignore(interruptedException);
                return;
            }
            finally {
                Object object3 = QueuedThreadPool.this._lock;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable runnable) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._job = runnable;
                this.notify();
            }
        }
    }
}

