/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import org.mortbay.log.Log;

public class Timeout {
    private Object _lock;
    private long _duration;
    private volatile long _now = System.currentTimeMillis();
    private Task _head = new Task();

    public Timeout() {
        this._lock = new Object();
        this._head._timeout = this;
    }

    public Timeout(Object object) {
        this._lock = object;
        this._head._timeout = this;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long l) {
        this._duration = l;
    }

    public long setNow() {
        this._now = System.currentTimeMillis();
        return this._now;
    }

    public long getNow() {
        return this._now;
    }

    public void setNow(long l) {
        this._now = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task expired() {
        long l = this._now;
        Object object = this._lock;
        synchronized (object) {
            long l2 = l - this._duration;
            if (this._head._next != this._head) {
                Task task = this._head._next;
                if (task._timestamp > l2) {
                    return null;
                }
                task.unlink();
                task._expired = true;
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long l = this._now - this._duration;
        Task task = null;
        block5: while (true) {
            try {
                while (true) {
                    Object object = this._lock;
                    synchronized (object) {
                        task = this._head._next;
                        if (task == this._head || task._timestamp > l) {
                            break block5;
                        }
                        task.unlink();
                        task._expired = true;
                        task.expire();
                    }
                    task.expired();
                }
            }
            catch (Throwable throwable) {
                Log.warn("EXCEPTION ", throwable);
                continue;
            }
            break;
        }
    }

    public void tick(long l) {
        this._now = l;
        this.tick();
    }

    public void schedule(Task task) {
        this.schedule(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, long l) {
        Object object = this._lock;
        synchronized (object) {
            if (task._timestamp != 0L) {
                task.unlink();
                task._timestamp = 0L;
            }
            task._timeout = this;
            task._expired = false;
            task._delay = l;
            task._timestamp = this._now + l;
            Task task2 = this._head._prev;
            while (task2 != this._head && task2._timestamp > task._timestamp) {
                task2 = task2._prev;
            }
            task2.link(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this._lock;
        synchronized (object) {
            this._head._next = this._head._prev = this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._head._next == this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToNext() {
        Object object = this._lock;
        synchronized (object) {
            if (this._head._next == this._head) {
                return -1L;
            }
            long l = this._duration + this._head._next._timestamp - this._now;
            long l2 = l < 0L ? 0L : l;
            return l2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        Task task = this._head._next;
        while (task != this._head) {
            stringBuffer.append("-->");
            stringBuffer.append(task);
            task = task._next;
        }
        return stringBuffer.toString();
    }

    public static class Task {
        Task _next = this._prev = this;
        Task _prev;
        Timeout _timeout;
        long _delay;
        long _timestamp = 0L;
        boolean _expired = false;

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getAge() {
            long l;
            Timeout timeout = this._timeout;
            if (timeout != null && (l = timeout._now) != 0L && this._timestamp != 0L) {
                return l - this._timestamp;
            }
            return 0L;
        }

        private void unlink() {
            this._next._prev = this._prev;
            this._prev._next = this._next;
            this._next = this._prev = this;
            this._expired = false;
        }

        private void link(Task task) {
            Task task2 = this._next;
            this._next._prev = task;
            this._next = task;
            this._next._next = task2;
            this._next._prev = this;
        }

        public void schedule(Timeout timeout) {
            timeout.schedule(this);
        }

        public void schedule(Timeout timeout, long l) {
            timeout.schedule(this, l);
        }

        public void reschedule() {
            Timeout timeout = this._timeout;
            if (timeout != null) {
                timeout.schedule(this, this._delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Timeout timeout = this._timeout;
            if (timeout != null) {
                Object object = timeout._lock;
                synchronized (object) {
                    this.unlink();
                    this._timestamp = 0L;
                }
            }
        }

        public boolean isExpired() {
            return this._expired;
        }

        public boolean isScheduled() {
            return this._next != this;
        }

        public void expire() {
        }

        public void expired() {
        }
    }
}

