/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.mortbay.util.TypeUtil;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;

    public QuotedStringTokenizer(String string, String string2, boolean bl, boolean bl2) {
        super("");
        this._string = string;
        if (string2 != null) {
            this._delim = string2;
        }
        this._returnDelimiters = bl;
        this._returnQuotes = bl2;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public QuotedStringTokenizer(String string, String string2) {
        this(string, string2, false, false);
    }

    public QuotedStringTokenizer(String string) {
        this(string, null, false, false);
    }

    @Override
    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int n = 0;
        boolean bl = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (n) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnDelimiters) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    n = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    @Override
    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String string = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return string;
    }

    @Override
    public String nextToken(String string) throws NoSuchElementException {
        this._delim = string;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        return -1;
    }

    public static String quote(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c) && string2.indexOf(c) < 0) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
            QuotedStringTokenizer.quote(stringBuffer, string);
            return stringBuffer.toString();
        }
        return string;
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        QuotedStringTokenizer.quote(stringBuffer, string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            char c;
            int n;
            stringBuffer.append('\"');
            char[] cArray = null;
            block21: for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                switch (c) {
                    case '\"': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\\"");
                        break block21;
                    }
                    case '\\': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\\\");
                        break block21;
                    }
                    case '\n': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\n");
                        break block21;
                    }
                    case '\r': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\r");
                        break block21;
                    }
                    case '\t': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\t");
                        break block21;
                    }
                    case '\f': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\f");
                        break block21;
                    }
                    case '\b': {
                        cArray = string.toCharArray();
                        stringBuffer.append(cArray, 0, n);
                        stringBuffer.append("\\b");
                        break block21;
                    }
                    default: {
                        continue block21;
                    }
                }
            }
            if (cArray == null) {
                stringBuffer.append(string);
            } else {
                ++n;
                while (n < string.length()) {
                    c = string.charAt(n);
                    switch (c) {
                        case '\"': {
                            stringBuffer.append("\\\"");
                            break;
                        }
                        case '\\': {
                            stringBuffer.append("\\\\");
                            break;
                        }
                        case '\n': {
                            stringBuffer.append("\\n");
                            break;
                        }
                        case '\r': {
                            stringBuffer.append("\\r");
                            break;
                        }
                        case '\t': {
                            stringBuffer.append("\\t");
                            break;
                        }
                        case '\f': {
                            stringBuffer.append("\\f");
                            break;
                        }
                        case '\b': {
                            stringBuffer.append("\\b");
                            break;
                        }
                        default: {
                            stringBuffer.append(c);
                            break;
                        }
                    }
                    ++n;
                }
            }
            stringBuffer.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quoteIfNeeded(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            char c;
            int n;
            int n2 = -1;
            block15: for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '%': 
                    case '+': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        n2 = n;
                        stringBuffer.append('\"');
                        for (int i = 0; i < n2; ++i) {
                            stringBuffer.append(string.charAt(i));
                        }
                        break block15;
                    }
                    default: {
                        continue block15;
                    }
                }
            }
            if (n2 < 0) {
                stringBuffer.append(string);
                return;
            }
            block17: for (n = n2; n < string.length(); ++n) {
                c = string.charAt(n);
                switch (c) {
                    case '\"': {
                        stringBuffer.append("\\\"");
                        continue block17;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block17;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block17;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block17;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block17;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block17;
                    }
                    case '\b': {
                        stringBuffer.append("\\b");
                        continue block17;
                    }
                    default: {
                        stringBuffer.append(c);
                        continue block17;
                    }
                }
            }
            stringBuffer.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unquote(String string) {
        StringBuffer stringBuffer;
        char c;
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 != (c = string.charAt(string.length() - 1)) || c2 != '\"' && c2 != '\'') {
            return string;
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(string.length() - 2);
        synchronized (stringBuffer2) {
            boolean bl = false;
            for (int i = 1; i < string.length() - 1; ++i) {
                char c3 = string.charAt(i);
                if (bl) {
                    bl = false;
                    switch (c3) {
                        case 'n': {
                            stringBuffer.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            break;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            break;
                        }
                        case 'u': {
                            stringBuffer.append((char)((TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 24) + (TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 16) + (TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 8) + TypeUtil.convertHexDigit((byte)string.charAt(i++))));
                            break;
                        }
                        default: {
                            stringBuffer.append(c3);
                            break;
                        }
                    }
                    continue;
                }
                if (c3 == '\\') {
                    bl = true;
                    continue;
                }
                stringBuffer.append(c3);
            }
            return stringBuffer.toString();
        }
    }

    public boolean getDouble() {
        return this._double;
    }

    public void setDouble(boolean bl) {
        this._double = bl;
    }

    public boolean getSingle() {
        return this._single;
    }

    public void setSingle(boolean bl) {
        this._single = bl;
    }
}

