/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.mortbay.log.Log;

public class Scanner {
    private int _scanInterval;
    private List _listeners = Collections.synchronizedList(new ArrayList());
    private Map _prevScan = new HashMap();
    private Map _currentScan = new HashMap();
    private FilenameFilter _filter;
    private List _scanDirs;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private Timer _timer;
    private TimerTask _task;
    private boolean _recursive = true;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int n) {
        this._scanInterval = n;
        this.schedule();
    }

    public void setScanDir(File file) {
        this._scanDirs = new ArrayList();
        this._scanDirs.add(file);
    }

    public File getScanDir() {
        return this._scanDirs == null ? null : (File)this._scanDirs.get(0);
    }

    public void setScanDirs(List list) {
        this._scanDirs = list;
    }

    public List getScanDirs() {
        return this._scanDirs;
    }

    public void setRecursive(boolean bl) {
        this._recursive = bl;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filter = filenameFilter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean bl) {
        this._reportExisting = bl;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer(true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
            }
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public void scan() {
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
    }

    public void scanFiles() {
        if (this._scanDirs == null) {
            return;
        }
        this._currentScan.clear();
        for (File file : this._scanDirs) {
            if (file == null || !file.exists()) continue;
            this.scanFile(file, this._currentScan);
        }
    }

    public void reportDifferences(Map map, Map map2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet hashSet = new HashSet(map2.keySet());
        for (Map.Entry entry : map.entrySet()) {
            if (!hashSet.contains(entry.getKey())) {
                Log.debug("File added: " + entry.getKey());
                this.reportAddition((String)entry.getKey());
                arrayList.add(entry.getKey());
                continue;
            }
            if (!map2.get(entry.getKey()).equals(entry.getValue())) {
                Log.debug("File changed: " + entry.getKey());
                this.reportChange((String)entry.getKey());
                hashSet.remove(entry.getKey());
                arrayList.add(entry.getKey());
                continue;
            }
            hashSet.remove(entry.getKey());
        }
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Log.debug("File removed: " + string);
                this.reportRemoval(string);
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            this.reportBulkChanges(arrayList);
        }
    }

    private void scanFile(File file, Map map) {
        try {
            if (!file.exists()) {
                return;
            }
            if (file.isFile()) {
                if (this._filter == null || this._filter != null && this._filter.accept(file.getParentFile(), file.getName())) {
                    String string = file.getCanonicalPath();
                    long l = file.lastModified();
                    map.put(string, new Long(l));
                }
            } else if (file.isDirectory() && (this._recursive || this._scanDirs.contains(file))) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.scanFile(fileArray[i], map);
                }
            }
        }
        catch (IOException iOException) {
            Log.warn("Error scanning watched files", iOException);
        }
    }

    private void warn(Object object, String string, Throwable throwable) {
        Log.warn(throwable);
        Log.warn(object + " failed on '" + string);
    }

    private void reportAddition(String string) {
        for (Object e : this._listeners) {
            try {
                if (!(e instanceof DiscreteListener)) continue;
                ((DiscreteListener)e).fileAdded(string);
            }
            catch (Exception exception) {
                this.warn(e, string, exception);
            }
            catch (Error error) {
                this.warn(e, string, error);
            }
        }
    }

    private void reportRemoval(String string) {
        for (Object e : this._listeners) {
            try {
                if (!(e instanceof DiscreteListener)) continue;
                ((DiscreteListener)e).fileRemoved(string);
            }
            catch (Exception exception) {
                this.warn(e, string, exception);
            }
            catch (Error error) {
                this.warn(e, string, error);
            }
        }
    }

    private void reportChange(String string) {
        for (Object e : this._listeners) {
            try {
                if (!(e instanceof DiscreteListener)) continue;
                ((DiscreteListener)e).fileChanged(string);
            }
            catch (Exception exception) {
                this.warn(e, string, exception);
            }
            catch (Error error) {
                this.warn(e, string, error);
            }
        }
    }

    private void reportBulkChanges(List list) {
        for (Object e : this._listeners) {
            try {
                if (!(e instanceof BulkListener)) continue;
                ((BulkListener)e).filesChanged(list);
            }
            catch (Exception exception) {
                this.warn(e, list.toString(), exception);
            }
            catch (Error error) {
                this.warn(e, list.toString(), error);
            }
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

