/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.Utf8StringBuffer;

public class StringUtil {
    public static final String CRLF = "\r\n";
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1;
    public static final String __UTF8 = "UTF-8";
    public static final String __UTF8Alt = "UTF8";
    public static final String __UTF16 = "UTF-16";
    private static char[] lowercases;

    public static String asciiToLowerCase(String string) {
        char[] cArray = null;
        int n = string.length();
        while (n-- > 0) {
            char c;
            char c2 = string.charAt(n);
            if (c2 > '\u007f' || c2 == (c = lowercases[c2])) continue;
            cArray = string.toCharArray();
            cArray[n] = c;
            break;
        }
        while (n-- > 0) {
            if (cArray[n] > 127) continue;
            cArray[n] = lowercases[cArray[n]];
        }
        return cArray == null ? string : new String(cArray);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        if (string == null || string.length() < string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) continue;
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c <= '\u007f') {
                c = lowercases[c];
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        int n;
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = n;
        while (n3-- > 0) {
            char c;
            char c2;
            if ((c2 = string.charAt(--n2)) == (c = string2.charAt(n3))) continue;
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c <= '\u007f') {
                c = lowercases[c];
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        int n = 0;
        int n2 = string.indexOf(string2, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(string.length() + string3.length());
        synchronized (stringBuffer2) {
            do {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
            } while ((n2 = string.indexOf(string2, n = n2 + string2.length())) != -1);
            if (n < string.length()) {
                stringBuffer.append(string.substring(n, string.length()));
            }
            return stringBuffer.toString();
        }
    }

    public static String unquote(String string) {
        return QuotedStringTokenizer.unquote(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuffer stringBuffer, String string, int n, int n2) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n3 = n + n2;
            for (int i = n; i < n3 && i < string.length(); ++i) {
                stringBuffer.append(string.charAt(i));
            }
        }
    }

    public static void append(StringBuffer stringBuffer, byte by, int n) {
        int n2 = 0xFF & by;
        int n3 = 48 + n2 / n % n;
        if (n3 > 57) {
            n3 = 97 + (n3 - 48 - 10);
        }
        stringBuffer.append((char)n3);
        n3 = 48 + n2 % n;
        if (n3 > 57) {
            n3 = 97 + (n3 - 48 - 10);
        }
        stringBuffer.append((char)n3);
    }

    public static void append2digits(StringBuffer stringBuffer, int n) {
        if (n < 100) {
            stringBuffer.append((char)(n / 10 + 48));
            stringBuffer.append((char)(n % 10 + 48));
        }
    }

    public static String nonNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[n + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] byArray, int n, int n2) {
        try {
            if (n2 < 32) {
                Utf8StringBuffer utf8StringBuffer = new Utf8StringBuffer(n2);
                utf8StringBuffer.append(byArray, n, n2);
                return utf8StringBuffer.toString();
            }
            return new String(byArray, n, n2, __UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String toString(byte[] byArray, int n, int n2, String string) {
        if (string == null || StringUtil.isUTF8(string)) {
            return StringUtil.toUTF8String(byArray, n, n2);
        }
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static boolean isUTF8(String string) {
        return string == __UTF8 || __UTF8.equalsIgnoreCase(string) || __UTF8Alt.equalsIgnoreCase(string);
    }

    public static String printable(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        String string = System.getProperty("ISO_8859_1");
        if (string == null) {
            try {
                new String(new byte[]{20}, "ISO-8859-1");
                string = "ISO-8859-1";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = "ISO8859_1";
            }
        }
        __ISO_8859_1 = string;
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }
}

