/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class URIUtil
implements Cloneable {
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final String __CHARSET = System.getProperty("org.mortbay.util.URI.charset", "UTF-8");

    private URIUtil() {
    }

    public static String encodePath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = URIUtil.encodePath(null, string);
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodePath(StringBuffer stringBuffer, String string) {
        int n;
        if (stringBuffer == null) {
            block17: for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                switch (n) {
                    case 32: 
                    case 34: 
                    case 35: 
                    case 37: 
                    case 39: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 63: {
                        stringBuffer = new StringBuffer(string.length() << 1);
                        break block17;
                    }
                    default: {
                        continue block17;
                    }
                }
            }
            if (stringBuffer == null) {
                return null;
            }
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            block18: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '%': {
                        stringBuffer.append("%25");
                        continue block18;
                    }
                    case '?': {
                        stringBuffer.append("%3F");
                        continue block18;
                    }
                    case ';': {
                        stringBuffer.append("%3B");
                        continue block18;
                    }
                    case '#': {
                        stringBuffer.append("%23");
                        continue block18;
                    }
                    case '\"': {
                        stringBuffer.append("%22");
                        continue block18;
                    }
                    case '\'': {
                        stringBuffer.append("%27");
                        continue block18;
                    }
                    case '<': {
                        stringBuffer.append("%3C");
                        continue block18;
                    }
                    case '>': {
                        stringBuffer.append("%3E");
                        continue block18;
                    }
                    case ' ': {
                        stringBuffer.append("%20");
                        continue block18;
                    }
                    default: {
                        stringBuffer.append(c);
                        continue block18;
                    }
                }
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodeString(StringBuffer stringBuffer, String string, String string2) {
        int n;
        if (stringBuffer == null) {
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                if (n != 37 && string2.indexOf(n) < 0) continue;
                stringBuffer = new StringBuffer(string.length() << 1);
                break;
            }
            if (stringBuffer == null) {
                return null;
            }
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '%' || string2.indexOf(c) >= 0) {
                    stringBuffer.append('%');
                    StringUtil.append(stringBuffer, (byte)(0xFF & c), 16);
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer;
    }

    public static String decodePath(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = null;
        int n = 0;
        byte[] byArray = null;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '%' && i + 2 < n3) {
                if (cArray == null) {
                    cArray = new char[n3];
                    byArray = new byte[n3];
                    string.getChars(0, i, cArray, 0);
                }
                byArray[n2++] = (byte)(0xFF & TypeUtil.parseInt(string, i + 1, 2, 16));
                i += 2;
                continue;
            }
            if (byArray == null) {
                ++n;
                continue;
            }
            if (n2 > 0) {
                String string2;
                try {
                    string2 = new String(byArray, 0, n2, __CHARSET);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(byArray, 0, n2);
                }
                string2.getChars(0, string2.length(), cArray, n);
                n += string2.length();
                n2 = 0;
            }
            cArray[n++] = c;
        }
        if (cArray == null) {
            return string;
        }
        if (n2 > 0) {
            String string3;
            try {
                string3 = new String(byArray, 0, n2, __CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = new String(byArray, 0, n2);
            }
            string3.getChars(0, string3.length(), cArray, n);
            n += string3.length();
        }
        return new String(cArray, 0, n);
    }

    public static String decodePath(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[i + n];
            if (by == 37 && i + 2 < n2) {
                by = (byte)(0xFF & TypeUtil.parseInt(byArray, i + n + 1, 2, 16));
                i += 2;
            } else if (byArray2 == null) {
                ++n3;
                continue;
            }
            if (byArray2 == null) {
                byArray2 = new byte[n2];
                for (int j = 0; j < n3; ++j) {
                    byArray2[j] = byArray[j + n];
                }
            }
            byArray2[n3++] = by;
        }
        if (byArray2 == null) {
            return StringUtil.toString(byArray, n, n2, __CHARSET);
        }
        return StringUtil.toString(byArray2, 0, n3, __CHARSET);
    }

    public static String addPaths(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string != null && string2 == null) {
                return string;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            n = string.indexOf(63);
        }
        if (n == 0) {
            return string2 + string;
        }
        if (n < 0) {
            n = string.length();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 2);
        stringBuffer.append(string);
        if (stringBuffer.charAt(n - 1) == '/') {
            if (string2.startsWith(SLASH)) {
                stringBuffer.deleteCharAt(n - 1);
                stringBuffer.insert(n - 1, string2);
            } else {
                stringBuffer.insert(n, string2);
            }
        } else if (string2.startsWith(SLASH)) {
            stringBuffer.insert(n, string2);
        } else {
            stringBuffer.insert(n, '/');
            stringBuffer.insert(n + 1, string2);
        }
        return stringBuffer.toString();
    }

    public static String parentPath(String string) {
        if (string == null || SLASH.equals(string)) {
            return null;
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    public static String stripPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.length();
        int n2 = string.lastIndexOf(47, n);
        block8: while (n > 0) {
            switch (n - n2) {
                case 2: {
                    if (string.charAt(n2 + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (string.charAt(n2 + 1) == '.' && string.charAt(n2 + 2) == '.') break block8;
                }
            }
            n = n2;
            n2 = string.lastIndexOf(47, n - 1);
        }
        if (n2 >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        block9: while (n > 0) {
            switch (n - n2) {
                case 2: {
                    if (stringBuffer.charAt(n2 + 1) != '.') {
                        if (n5 <= 0 || --n5 != 0) break;
                        int n6 = n3 = n2 >= 0 ? n2 : 0;
                        if (n3 <= 0 || n4 != stringBuffer.length() || stringBuffer.charAt(n4 - 1) != '.') break;
                        ++n3;
                        break;
                    }
                    if (n2 < 0 && stringBuffer.length() > 2 && stringBuffer.charAt(1) == '/' && stringBuffer.charAt(2) == '/') break;
                    if (n4 < 0) {
                        n4 = n;
                    }
                    if ((n3 = n2) < 0 || n3 == 0 && stringBuffer.charAt(n3) == '/') {
                        ++n3;
                        if (n4 >= stringBuffer.length() || stringBuffer.charAt(n4) != '/') break;
                        ++n4;
                        break;
                    }
                    if (n == stringBuffer.length()) {
                        ++n3;
                    }
                    n = n2--;
                    while (n2 >= 0 && stringBuffer.charAt(n2) != '/') {
                        --n2;
                    }
                    continue block9;
                }
                case 3: {
                    if (stringBuffer.charAt(n2 + 1) != '.' || stringBuffer.charAt(n2 + 2) != '.') {
                        if (n5 <= 0 || --n5 != 0) break;
                        int n7 = n3 = n2 >= 0 ? n2 : 0;
                        if (n3 <= 0 || n4 != stringBuffer.length() || stringBuffer.charAt(n4 - 1) != '.') break;
                        ++n3;
                        break;
                    }
                    n3 = n2;
                    if (n4 < 0) {
                        n4 = n;
                    }
                    ++n5;
                    n = n2--;
                    while (n2 >= 0 && stringBuffer.charAt(n2) != '/') {
                        --n2;
                    }
                    continue block9;
                }
                default: {
                    if (n5 <= 0 || --n5 != 0) break;
                    int n8 = n3 = n2 >= 0 ? n2 : 0;
                    if (n4 != stringBuffer.length() || stringBuffer.charAt(n4 - 1) != '.') break;
                    ++n3;
                }
            }
            if (n5 <= 0 && n3 >= 0 && n3 >= 0) {
                stringBuffer.delete(n3, n4);
                n4 = -1;
                n3 = -1;
                if (n5 > 0) {
                    n4 = n;
                }
            }
            n = n2--;
            while (n2 >= 0 && stringBuffer.charAt(n2) != '/') {
                --n2;
            }
        }
        if (n5 > 0) {
            return null;
        }
        if (n4 >= 0) {
            stringBuffer.delete(n3, n4);
        }
        return stringBuffer.toString();
    }

    public static String compactPath(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        block8: for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    return string;
                }
                case '/': {
                    if (++n2 != 2) continue block8;
                    break block8;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        if (n2 < 2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        stringBuffer.append(cArray, 0, n);
        block9: while (n < n3) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    stringBuffer.append(cArray, n, n3 - n);
                    break block9;
                }
                case '/': {
                    if (n2++ != 0) break;
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    n2 = 0;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean hasScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }
}

