/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.Utf8StringBuffer;

public class UrlEncoded
extends MultiMap {
    public UrlEncoded(UrlEncoded urlEncoded) {
        super((Map)urlEncoded);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String string) {
        super(6);
        this.decode(string, "UTF-8");
    }

    public UrlEncoded(String string, String string2) {
        super(6);
        this.decode(string, string2);
    }

    public void decode(String string) {
        UrlEncoded.decodeTo(string, this, "UTF-8");
    }

    public void decode(String string, String string2) {
        UrlEncoded.decodeTo(string, this, string2);
    }

    public String encode() {
        return this.encode("UTF-8", false);
    }

    public String encode(String string) {
        return this.encode(string, false);
    }

    public synchronized String encode(String string, boolean bl) {
        return UrlEncoded.encode(this, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(MultiMap multiMap, String string, boolean bl) {
        StringBuffer stringBuffer;
        if (string == null) {
            string = "UTF-8";
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(128);
        synchronized (stringBuffer2) {
            Iterator iterator = multiMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = entry.getKey().toString();
                Object v = entry.getValue();
                int n = LazyList.size(v);
                if (n == 0) {
                    stringBuffer.append(UrlEncoded.encodeString(string2, string));
                    if (bl) {
                        stringBuffer.append('=');
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append('&');
                        }
                        Object object = LazyList.get(v, i);
                        stringBuffer.append(UrlEncoded.encodeString(string2, string));
                        if (object != null) {
                            String string3 = object.toString();
                            if (string3.length() > 0) {
                                stringBuffer.append('=');
                                stringBuffer.append(UrlEncoded.encodeString(string3, string));
                                continue;
                            }
                            if (!bl) continue;
                            stringBuffer.append('=');
                            continue;
                        }
                        if (!bl) continue;
                        stringBuffer.append('=');
                    }
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append('&');
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String string, MultiMap multiMap, String string2) {
        if (string2 == null) {
            string2 = "UTF-8";
        }
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n;
            String string3 = null;
            String string4 = null;
            int n2 = -1;
            boolean bl = false;
            block9: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '&': {
                        int n3 = n - n2 - 1;
                        string4 = n3 == 0 ? "" : (bl ? UrlEncoded.decodeString(string, n2 + 1, n3, string2) : string.substring(n2 + 1, n));
                        n2 = n;
                        bl = false;
                        if (string3 != null) {
                            multiMap.add(string3, string4);
                        } else if (string4 != null && string4.length() > 0) {
                            multiMap.add(string4, "");
                        }
                        string3 = null;
                        string4 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string3 != null) continue block9;
                        string3 = bl ? UrlEncoded.decodeString(string, n2 + 1, n - n2 - 1, string2) : string.substring(n2 + 1, n);
                        n2 = n;
                        bl = false;
                        continue block9;
                    }
                    case '+': {
                        bl = true;
                        continue block9;
                    }
                    case '%': {
                        bl = true;
                    }
                }
            }
            if (string3 != null) {
                n = string.length() - n2 - 1;
                string4 = n == 0 ? "" : (bl ? UrlEncoded.decodeString(string, n2 + 1, n, string2) : string.substring(n2 + 1));
                multiMap.add(string3, string4);
            } else if (n2 < string.length()) {
                string3 = bl ? UrlEncoded.decodeString(string, n2 + 1, string.length() - n2 - 1, string2) : string.substring(n2 + 1);
                multiMap.add(string3, "");
            }
        }
    }

    public static void decodeUtf8To(byte[] byArray, int n, int n2, MultiMap multiMap) {
        UrlEncoded.decodeUtf8To(byArray, n, n2, multiMap, new Utf8StringBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(byte[] byArray, int n, int n2, MultiMap multiMap, Utf8StringBuffer utf8StringBuffer) {
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string = null;
            String string2 = null;
            int n3 = n + n2;
            block9: for (int i = n; i < n3; ++i) {
                byte by = byArray[i];
                switch ((char)(0xFF & by)) {
                    case '&': {
                        string2 = utf8StringBuffer.length() == 0 ? "" : utf8StringBuffer.toString();
                        utf8StringBuffer.reset();
                        if (string != null) {
                            multiMap.add(string, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string = null;
                        string2 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string != null) {
                            utf8StringBuffer.append(by);
                            continue block9;
                        }
                        string = utf8StringBuffer.toString();
                        utf8StringBuffer.reset();
                        continue block9;
                    }
                    case '+': {
                        utf8StringBuffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i + 2 >= n3) continue block9;
                        utf8StringBuffer.append((byte)((TypeUtil.convertHexDigit(byArray[++i]) << 4) + TypeUtil.convertHexDigit(byArray[++i])));
                        continue block9;
                    }
                    default: {
                        utf8StringBuffer.append(by);
                    }
                }
            }
            if (string != null) {
                string2 = utf8StringBuffer.length() == 0 ? "" : utf8StringBuffer.toString();
                utf8StringBuffer.reset();
                multiMap.add(string, string2);
            } else if (utf8StringBuffer.length() > 0) {
                multiMap.add(utf8StringBuffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream inputStream, MultiMap multiMap, int n) throws IOException {
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            String string2 = null;
            int n3 = 0;
            while ((n2 = inputStream.read()) >= 0) {
                switch ((char)n2) {
                    case '&': {
                        string2 = stringBuffer.length() == 0 ? "" : stringBuffer.toString();
                        stringBuffer.setLength(0);
                        if (string != null) {
                            multiMap.add(string, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string = null;
                        string2 = null;
                        break;
                    }
                    case '=': {
                        if (string != null) {
                            stringBuffer.append((char)n2);
                            break;
                        }
                        string = stringBuffer.toString();
                        stringBuffer.setLength(0);
                        break;
                    }
                    case '+': {
                        stringBuffer.append(' ');
                        break;
                    }
                    case '%': {
                        int n4 = inputStream.read();
                        int n5 = inputStream.read();
                        if (n4 < 0 || n5 < 0) break;
                        stringBuffer.append((char)((TypeUtil.convertHexDigit((byte)n4) << 4) + TypeUtil.convertHexDigit((byte)n5)));
                        break;
                    }
                    default: {
                        stringBuffer.append((char)n2);
                    }
                }
                if (n < 0 || ++n3 <= n) continue;
                throw new IllegalStateException("Form too large");
            }
            if (string != null) {
                string2 = stringBuffer.length() == 0 ? "" : stringBuffer.toString();
                stringBuffer.setLength(0);
                multiMap.add(string, string2);
            } else if (stringBuffer.length() > 0) {
                multiMap.add(stringBuffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream inputStream, MultiMap multiMap, int n) throws IOException {
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n2;
            Utf8StringBuffer utf8StringBuffer = new Utf8StringBuffer();
            String string = null;
            String string2 = null;
            int n3 = 0;
            while ((n2 = inputStream.read()) >= 0) {
                switch ((char)n2) {
                    case '&': {
                        string2 = utf8StringBuffer.length() == 0 ? "" : utf8StringBuffer.toString();
                        utf8StringBuffer.reset();
                        if (string != null) {
                            multiMap.add(string, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string = null;
                        string2 = null;
                        break;
                    }
                    case '=': {
                        if (string != null) {
                            utf8StringBuffer.append((byte)n2);
                            break;
                        }
                        string = utf8StringBuffer.toString();
                        utf8StringBuffer.reset();
                        break;
                    }
                    case '+': {
                        utf8StringBuffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        int n4 = inputStream.read();
                        int n5 = inputStream.read();
                        if (n4 < 0 || n5 < 0) break;
                        utf8StringBuffer.append((byte)((TypeUtil.convertHexDigit((byte)n4) << 4) + TypeUtil.convertHexDigit((byte)n5)));
                        break;
                    }
                    default: {
                        utf8StringBuffer.append((byte)n2);
                    }
                }
                if (n < 0 || ++n3 <= n) continue;
                throw new IllegalStateException("Form too large");
            }
            if (string != null) {
                string2 = utf8StringBuffer.length() == 0 ? "" : utf8StringBuffer.toString();
                utf8StringBuffer.reset();
                multiMap.add(string, string2);
            } else if (utf8StringBuffer.length() > 0) {
                multiMap.add(utf8StringBuffer.toString(), "");
            }
        }
    }

    public static void decodeUtf16To(InputStream inputStream, MultiMap multiMap, int n) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        while ((n2 = inputStreamReader.read()) > 0 && n3++ < n) {
            stringBuffer.append((char)n2);
        }
        UrlEncoded.decodeTo(stringBuffer.toString(), multiMap, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream inputStream, MultiMap multiMap, String string, int n) throws IOException {
        if (string == null || "UTF-8".equalsIgnoreCase(string)) {
            UrlEncoded.decodeUtf8To(inputStream, multiMap, n);
            return;
        }
        if (StringUtil.__ISO_8859_1.equals(string)) {
            UrlEncoded.decode88591To(inputStream, multiMap, n);
            return;
        }
        if ("UTF-16".equalsIgnoreCase(string)) {
            UrlEncoded.decodeUtf16To(inputStream, multiMap, n);
            return;
        }
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            int n2;
            String string2 = null;
            String string3 = null;
            byte by = 0;
            int n3 = 0;
            int n4 = 0;
            ByteArrayOutputStream2 byteArrayOutputStream2 = new ByteArrayOutputStream2();
            int n5 = 0;
            while ((n2 = inputStream.read()) > 0) {
                switch ((char)n2) {
                    case '&': {
                        n5 = byteArrayOutputStream2.size();
                        string3 = n5 == 0 ? "" : byteArrayOutputStream2.toString(string);
                        byteArrayOutputStream2.setCount(0);
                        if (string2 != null) {
                            multiMap.add(string2, string3);
                        } else if (string3 != null && string3.length() > 0) {
                            multiMap.add(string3, "");
                        }
                        string2 = null;
                        string3 = null;
                        break;
                    }
                    case '=': {
                        if (string2 != null) {
                            byteArrayOutputStream2.write(n2);
                            break;
                        }
                        n5 = byteArrayOutputStream2.size();
                        string2 = n5 == 0 ? "" : byteArrayOutputStream2.toString(string);
                        byteArrayOutputStream2.setCount(0);
                        break;
                    }
                    case '+': {
                        byteArrayOutputStream2.write(32);
                        break;
                    }
                    case '%': {
                        n3 = 2;
                        break;
                    }
                    default: {
                        if (n3 == 2) {
                            by = TypeUtil.convertHexDigit((byte)n2);
                            n3 = 1;
                            break;
                        }
                        if (n3 == 1) {
                            byteArrayOutputStream2.write((by << 4) + TypeUtil.convertHexDigit((byte)n2));
                            n3 = 0;
                            break;
                        }
                        byteArrayOutputStream2.write(n2);
                    }
                }
                if (n < 0 || ++n4 <= n) continue;
                throw new IllegalStateException("Form too large");
            }
            n5 = byteArrayOutputStream2.size();
            if (string2 != null) {
                string3 = n5 == 0 ? "" : byteArrayOutputStream2.toString(string);
                byteArrayOutputStream2.setCount(0);
                multiMap.add(string2, string3);
            } else if (n5 > 0) {
                multiMap.add(byteArrayOutputStream2.toString(string), "");
            }
        }
    }

    public static String decodeString(String string, int n, int n2, String string2) {
        if (string2 == null || StringUtil.isUTF8(string2)) {
            Utf8StringBuffer utf8StringBuffer = null;
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(n + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (utf8StringBuffer == null) {
                        utf8StringBuffer = new Utf8StringBuffer(n2);
                        utf8StringBuffer.getStringBuffer().append(string.substring(n, n + i + 1));
                        continue;
                    }
                    utf8StringBuffer.getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (utf8StringBuffer == null) {
                        utf8StringBuffer = new Utf8StringBuffer(n2);
                        utf8StringBuffer.getStringBuffer().append(string.substring(n, n + i));
                    }
                    utf8StringBuffer.getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < n2) {
                    if (utf8StringBuffer == null) {
                        utf8StringBuffer = new Utf8StringBuffer(n2);
                        utf8StringBuffer.getStringBuffer().append(string.substring(n, n + i));
                    }
                    while (c == '%' && i + 2 < n2) {
                        try {
                            byte by = (byte)TypeUtil.parseInt(string, n + i + 1, 2, 16);
                            utf8StringBuffer.append(by);
                            i += 3;
                        }
                        catch (NumberFormatException numberFormatException) {
                            char c2;
                            utf8StringBuffer.getStringBuffer().append('%');
                            while ((c2 = string.charAt(++i + n)) != '%') {
                                utf8StringBuffer.getStringBuffer().append(c2 == '+' ? (char)' ' : (char)c2);
                            }
                        }
                        if (i >= n2) continue;
                        c = string.charAt(n + i);
                    }
                    --i;
                    continue;
                }
                if (utf8StringBuffer == null) continue;
                utf8StringBuffer.getStringBuffer().append(c);
            }
            if (utf8StringBuffer == null) {
                if (n == 0 && string.length() == n2) {
                    return string;
                }
                return string.substring(n, n + n2);
            }
            return utf8StringBuffer.toString();
        }
        StringBuffer stringBuffer = null;
        try {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(n + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                        stringBuffer.append(string.substring(n, n + i + 1));
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '+') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                        stringBuffer.append(string.substring(n, n + i));
                    }
                    stringBuffer.append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < n2) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                        stringBuffer.append(string.substring(n, n + i));
                    }
                    byte[] byArray = new byte[n2];
                    int n3 = 0;
                    while (c >= '\u0000' && c <= '\u00ff') {
                        if (c == '%') {
                            if (i + 2 < n2) {
                                try {
                                    byArray[n3++] = (byte)TypeUtil.parseInt(string, n + i + 1, 2, 16);
                                    i += 3;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    char c3;
                                    byArray[n3 - 1] = 37;
                                    while ((c3 = string.charAt(++i + n)) != '%') {
                                        byArray[n3++] = (byte)(c3 == '+' ? 32 : (int)c3);
                                    }
                                }
                            } else {
                                byArray[n3++] = 37;
                                ++i;
                            }
                        } else if (c == '+') {
                            byArray[n3++] = 32;
                            ++i;
                        } else {
                            byArray[n3++] = (byte)c;
                            ++i;
                        }
                        if (i >= n2) break;
                        c = string.charAt(n + i);
                    }
                    --i;
                    stringBuffer.append(new String(byArray, 0, n3, string2));
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
            }
            if (stringBuffer == null) {
                if (n == 0 && string.length() == n2) {
                    return string;
                }
                return string.substring(n, n + n2);
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, "UTF-8");
    }

    public static String encodeString(String string, String string2) {
        if (string2 == null) {
            string2 = "UTF-8";
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[byArray.length * 3];
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 32) {
                bl = false;
                byArray2[n2++] = 43;
                continue;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) {
                byArray2[n2++] = by;
                continue;
            }
            bl = false;
            byArray2[n2++] = 37;
            byte by2 = (byte)((by & 0xF0) >> 4);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
            by2 = (byte)(by & 0xF);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
        }
        if (bl) {
            return string;
        }
        try {
            return new String(byArray2, 0, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n2);
        }
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }
}

