/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

public class Utf8StringBuffer {
    StringBuffer _buffer;
    int _more;
    int _bits;
    boolean _errors;

    public Utf8StringBuffer() {
        this._buffer = new StringBuffer();
    }

    public Utf8StringBuffer(int n) {
        this._buffer = new StringBuffer(n);
    }

    public void append(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.append(byArray[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(byte by) {
        if (by >= 0) {
            if (this._more > 0) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else {
                this._buffer.append((char)(0x7F & by));
            }
            return;
        } else if (this._more == 0) {
            if ((by & 0xC0) != 192) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else if ((by & 0xE0) == 192) {
                this._more = 1;
                this._bits = by & 0x1F;
                return;
            } else if ((by & 0xF0) == 224) {
                this._more = 2;
                this._bits = by & 0xF;
                return;
            } else if ((by & 0xF8) == 240) {
                this._more = 3;
                this._bits = by & 7;
                return;
            } else if ((by & 0xFC) == 248) {
                this._more = 4;
                this._bits = by & 3;
                return;
            } else {
                if ((by & 0xFE) != 252) throw new IllegalArgumentException("!utf8");
                this._more = 5;
                this._bits = by & 1;
            }
            return;
        } else {
            if ((by & 0xC0) == 192) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                throw new IllegalArgumentException("!utf8");
            }
            this._bits = this._bits << 6 | by & 0x3F;
            if (--this._more != 0) return;
            this._buffer.append(new String(Character.toChars(this._bits)));
        }
    }

    public int length() {
        return this._buffer.length();
    }

    public void reset() {
        this._buffer.setLength(0);
        this._more = 0;
        this._bits = 0;
        this._errors = false;
    }

    public StringBuffer getStringBuffer() {
        return this._buffer;
    }

    public String toString() {
        return this._buffer.toString();
    }

    public boolean isError() {
        return this._errors || this._more > 0;
    }
}

