/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.mortbay.log.Log;
import org.mortbay.util.DateCache;
import org.mortbay.util.ajax.JSON;

public class JSONDateConvertor
implements JSON.Convertor {
    private boolean _fromJSON;
    DateCache _dateCache;
    SimpleDateFormat _format;

    public JSONDateConvertor() {
        this(false);
    }

    public JSONDateConvertor(boolean bl) {
        this(DateCache.DEFAULT_FORMAT, TimeZone.getTimeZone("GMT"), bl);
    }

    public JSONDateConvertor(String string, TimeZone timeZone, boolean bl) {
        this._dateCache = new DateCache(string);
        this._dateCache.setTimeZone(timeZone);
        this._fromJSON = bl;
        this._format = new SimpleDateFormat(string);
        this._format.setTimeZone(timeZone);
    }

    public JSONDateConvertor(String string, TimeZone timeZone, boolean bl, Locale locale) {
        this._dateCache = new DateCache(string, locale);
        this._dateCache.setTimeZone(timeZone);
        this._fromJSON = bl;
        this._format = new SimpleDateFormat(string, new DateFormatSymbols(locale));
        this._format.setTimeZone(timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fromJSON(Map map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        try {
            SimpleDateFormat simpleDateFormat = this._format;
            synchronized (simpleDateFormat) {
                return this._format.parseObject((String)map.get("value"));
            }
        }
        catch (Exception exception) {
            Log.warn(exception);
            return null;
        }
    }

    @Override
    public void toJSON(Object object, JSON.Output output) {
        String string = this._dateCache.format((Date)object);
        if (this._fromJSON) {
            output.addClass(object.getClass());
            output.add("value", string);
        } else {
            output.add(string);
        }
    }
}

