/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mortbay.util.ajax.JSON;

public class JSONObjectConvertor
implements JSON.Convertor {
    private boolean _fromJSON;
    private Set _excluded = null;

    public JSONObjectConvertor() {
        this._fromJSON = false;
    }

    public JSONObjectConvertor(boolean bl) {
        this._fromJSON = bl;
    }

    public JSONObjectConvertor(boolean bl, String[] stringArray) {
        this._fromJSON = bl;
        if (stringArray != null) {
            this._excluded = new HashSet<String>(Arrays.asList(stringArray));
        }
    }

    @Override
    public Object fromJSON(Map map) {
        if (this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        return map;
    }

    @Override
    public void toJSON(Object object, JSON.Output output) {
        try {
            Class<?> clazz = object.getClass();
            if (this._fromJSON) {
                output.addClass(object.getClass());
            }
            Method[] methodArray = object.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() == null || method.getDeclaringClass() == Object.class) continue;
                String string = method.getName();
                if (string.startsWith("is")) {
                    string = string.substring(2, 3).toLowerCase() + string.substring(3);
                } else {
                    if (!string.startsWith("get")) continue;
                    string = string.substring(3, 4).toLowerCase() + string.substring(4);
                }
                if (!this.includeField(string, object, method)) continue;
                output.add(string, method.invoke(object, (Object[])null));
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Illegal argument", throwable);
        }
    }

    protected boolean includeField(String string, Object object, Method method) {
        return this._excluded == null || !this._excluded.contains(string);
    }
}

