/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mortbay.log.Log;
import org.mortbay.util.ajax.JSON;

public class JSONPojoConvertor
implements JSON.Convertor {
    public static final Object[] GETTER_ARG = new Object[0];
    public static final Object[] NULL_ARG = new Object[]{null};
    private static final Map __numberTypes = new HashMap();
    protected boolean _fromJSON;
    protected Class _pojoClass;
    protected Map _getters = new HashMap();
    protected Map _setters = new HashMap();
    protected Set _excluded;
    public static final NumberType SHORT = new NumberType(){

        @Override
        public Object getActualValue(Number number) {
            return new Short(number.shortValue());
        }
    };
    public static final NumberType INTEGER = new NumberType(){

        @Override
        public Object getActualValue(Number number) {
            return new Integer(number.intValue());
        }
    };
    public static final NumberType FLOAT = new NumberType(){

        @Override
        public Object getActualValue(Number number) {
            return new Float(number.floatValue());
        }
    };
    public static final NumberType LONG = new NumberType(){

        @Override
        public Object getActualValue(Number number) {
            return number instanceof Long ? (Number)number : (Number)new Long(number.longValue());
        }
    };
    public static final NumberType DOUBLE = new NumberType(){

        @Override
        public Object getActualValue(Number number) {
            return number instanceof Double ? (Number)number : (Number)new Double(number.doubleValue());
        }
    };

    public static NumberType getNumberType(Class clazz) {
        return (NumberType)__numberTypes.get(clazz);
    }

    public JSONPojoConvertor(Class clazz) {
        this(clazz, null, true);
    }

    public JSONPojoConvertor(Class clazz, String[] stringArray) {
        this(clazz, new HashSet<String>(Arrays.asList(stringArray)), true);
    }

    public JSONPojoConvertor(Class clazz, Set set) {
        this(clazz, set, true);
    }

    public JSONPojoConvertor(Class clazz, Set set, boolean bl) {
        this._pojoClass = clazz;
        this._excluded = set;
        this._fromJSON = bl;
        this.init();
    }

    public JSONPojoConvertor(Class clazz, boolean bl) {
        this(clazz, null, bl);
    }

    protected void init() {
        Method[] methodArray = this._pojoClass.getMethods();
        block4: for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class) continue;
            String string = method.getName();
            switch (method.getParameterTypes().length) {
                case 0: {
                    if (method.getReturnType() == null) continue block4;
                    if (string.startsWith("is") && string.length() > 2) {
                        string = string.substring(2, 3).toLowerCase() + string.substring(3);
                    } else {
                        if (!string.startsWith("get") || string.length() <= 3) continue block4;
                        string = string.substring(3, 4).toLowerCase() + string.substring(4);
                    }
                    if (!this.includeField(string, method)) continue block4;
                    this.addGetter(string, method);
                    continue block4;
                }
                case 1: {
                    if (!string.startsWith("set") || string.length() <= 3 || !this.includeField(string = string.substring(3, 4).toLowerCase() + string.substring(4), method)) continue block4;
                    this.addSetter(string, method);
                }
            }
        }
    }

    protected void addGetter(String string, Method method) {
        this._getters.put(string, method);
    }

    protected void addSetter(String string, Method method) {
        this._setters.put(string, new Setter(string, method));
    }

    protected Setter getSetter(String string) {
        return (Setter)this._setters.get(string);
    }

    protected boolean includeField(String string, Method method) {
        return this._excluded == null || !this._excluded.contains(string);
    }

    protected int getExcludedCount() {
        return this._excluded == null ? 0 : this._excluded.size();
    }

    @Override
    public Object fromJSON(Map map) {
        Object var2_2 = null;
        try {
            var2_2 = this._pojoClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setProps(var2_2, map);
        return var2_2;
    }

    public int setProps(Object object, Map map) {
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            Setter setter = this.getSetter((String)entry.getKey());
            if (setter == null) continue;
            try {
                setter.invoke(object, entry.getValue());
                ++n;
            }
            catch (Exception exception) {
                Log.warn("{} property '{}' not set. (errors)", this._pojoClass.getName(), setter.getPropertyName());
                this.log(exception);
            }
        }
        return n;
    }

    @Override
    public void toJSON(Object object, JSON.Output output) {
        if (this._fromJSON) {
            output.addClass(this._pojoClass);
        }
        for (Map.Entry entry : this._getters.entrySet()) {
            try {
                output.add((String)entry.getKey(), ((Method)entry.getValue()).invoke(object, GETTER_ARG));
            }
            catch (Exception exception) {
                Log.warn("{} property '{}' excluded. (errors)", this._pojoClass.getName(), entry.getKey());
                this.log(exception);
            }
        }
    }

    protected void log(Throwable throwable) {
        Log.ignore(throwable);
    }

    static {
        __numberTypes.put(Short.class, SHORT);
        __numberTypes.put(Short.TYPE, SHORT);
        __numberTypes.put(Integer.class, INTEGER);
        __numberTypes.put(Integer.TYPE, INTEGER);
        __numberTypes.put(Long.class, LONG);
        __numberTypes.put(Long.TYPE, LONG);
        __numberTypes.put(Float.class, FLOAT);
        __numberTypes.put(Float.TYPE, FLOAT);
        __numberTypes.put(Double.class, DOUBLE);
        __numberTypes.put(Double.TYPE, DOUBLE);
    }

    public static interface NumberType {
        public Object getActualValue(Number var1);
    }

    public static class Setter {
        protected String _propertyName;
        protected Method _method;
        protected NumberType _numberType;
        protected Class _type;
        protected Class _componentType;

        public Setter(String string, Method method) {
            this._propertyName = string;
            this._method = method;
            this._type = method.getParameterTypes()[0];
            this._numberType = (NumberType)__numberTypes.get(this._type);
            if (this._numberType == null && this._type.isArray()) {
                this._componentType = this._type.getComponentType();
                this._numberType = (NumberType)__numberTypes.get(this._componentType);
            }
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public Method getMethod() {
            return this._method;
        }

        public NumberType getNumberType() {
            return this._numberType;
        }

        public Class getType() {
            return this._type;
        }

        public Class getComponentType() {
            return this._componentType;
        }

        public boolean isPropertyNumber() {
            return this._numberType != null;
        }

        public void invoke(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (object2 == null) {
                this._method.invoke(object, NULL_ARG);
            } else {
                this.invokeObject(object, object2);
            }
        }

        protected void invokeObject(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this._numberType != null && object2 instanceof Number) {
                this._method.invoke(object, this._numberType.getActualValue((Number)object2));
            } else if (this._componentType != null && object2.getClass().isArray()) {
                if (this._numberType == null) {
                    int n = Array.getLength(object2);
                    Object object3 = Array.newInstance(this._componentType, n);
                    try {
                        System.arraycopy(object2, 0, object3, 0, n);
                    }
                    catch (Exception exception) {
                        Log.ignore(exception);
                        this._method.invoke(object, object2);
                        return;
                    }
                    this._method.invoke(object, object3);
                } else {
                    Object[] objectArray = (Object[])object2;
                    Object object4 = Array.newInstance(this._componentType, objectArray.length);
                    try {
                        for (int i = 0; i < objectArray.length; ++i) {
                            Array.set(object4, i, this._numberType.getActualValue((Number)objectArray[i]));
                        }
                    }
                    catch (Exception exception) {
                        Log.ignore(exception);
                        this._method.invoke(object, object2);
                        return;
                    }
                    this._method.invoke(object, object4);
                }
            } else {
                this._method.invoke(object, object2);
            }
        }
    }
}

