/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class AppEngineWebXml
implements Cloneable {
    private final Map<String, String> systemProperties = Maps.newHashMap();
    private final Map<String, String> betaSettings = Maps.newLinkedHashMap();
    private final HealthCheck healthCheck;
    private final Resources resources;
    private final Network network;
    private final Map<String, String> envVariables = Maps.newHashMap();
    private final List<UserPermission> userPermissions = new ArrayList<UserPermission>();
    public static final String WARMUP_SERVICE = "warmup";
    public static final String URL_HANDLER_URLFETCH = "urlfetch";
    public static final String URL_HANDLER_NATIVE = "native";
    private String appId;
    private String majorVersionId;
    private String module;
    private String instanceClass;
    private final AutomaticScaling automaticScaling;
    private final ManualScaling manualScaling;
    private final BasicScaling basicScaling;
    private String sourceLanguage;
    private boolean sslEnabled = true;
    private boolean useSessions = false;
    private boolean asyncSessionPersistence = false;
    private String asyncSessionPersistenceQueueName;
    private final List<StaticFileInclude> staticFileIncludes;
    private final List<String> staticFileExcludes;
    private final List<String> resourceFileIncludes;
    private final List<String> resourceFileExcludes;
    private Pattern staticIncludePattern;
    private Pattern staticExcludePattern;
    private Pattern resourceIncludePattern;
    private Pattern resourceExcludePattern;
    private String publicRoot = "";
    private String appRoot;
    private final Set<String> inboundServices;
    private boolean precompilationEnabled = true;
    private final List<AdminConsolePage> adminConsolePages = new ArrayList<AdminConsolePage>();
    private final List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();
    private ClassLoaderConfig classLoaderConfig;
    private String urlStreamHandlerType = null;
    private boolean threadsafe = false;
    private boolean threadsafeValueProvided = false;
    private String autoIdPolicy;
    private boolean codeLock = false;
    private boolean useVm = false;
    private String env = "1";
    private ApiConfig apiConfig;
    private final List<String> apiEndpointIds;
    private Pagespeed pagespeed;
    private UseGoogleConnectorJ useGoogleConnectorJ = UseGoogleConnectorJ.NOT_STATED_BY_USER;

    public AppEngineWebXml() {
        this.automaticScaling = new AutomaticScaling();
        this.manualScaling = new ManualScaling();
        this.basicScaling = new BasicScaling();
        this.healthCheck = new HealthCheck();
        this.resources = new Resources();
        this.network = new Network();
        this.staticFileIncludes = new ArrayList<StaticFileInclude>();
        this.staticFileExcludes = new ArrayList<String>();
        this.staticFileExcludes.add("WEB-INF/**");
        this.staticFileExcludes.add("**.jsp");
        this.resourceFileIncludes = new ArrayList<String>();
        this.resourceFileExcludes = new ArrayList<String>();
        this.inboundServices = new LinkedHashSet<String>();
        this.apiEndpointIds = new ArrayList<String>();
    }

    public AppEngineWebXml clone() {
        try {
            return (AppEngineWebXml)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Could not clone AppEngineWebXml", ce);
        }
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public void addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public Map<String, String> getBetaSettings() {
        return Collections.unmodifiableMap(this.betaSettings);
    }

    public void addBetaSetting(String key, String value) {
        this.betaSettings.put(key, value);
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    public void addEnvironmentVariable(String key, String value) {
        this.envVariables.put(key, value);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMajorVersionId() {
        return this.majorVersionId;
    }

    public void setMajorVersionId(String majorVersionId) {
        this.majorVersionId = majorVersionId;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public String getModule() {
        return this.module;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = AppEngineWebXml.toNullIfEmptyOrWhitespace(instanceClass);
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public AutomaticScaling getAutomaticScaling() {
        return this.automaticScaling;
    }

    public ManualScaling getManualScaling() {
        return this.manualScaling;
    }

    public BasicScaling getBasicScaling() {
        return this.basicScaling;
    }

    public ScalingType getScalingType() {
        if (!this.getBasicScaling().isEmpty()) {
            return ScalingType.BASIC;
        }
        if (!this.getManualScaling().isEmpty()) {
            return ScalingType.MANUAL;
        }
        return ScalingType.AUTOMATIC;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setSslEnabled(boolean ssl) {
        this.sslEnabled = ssl;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSessionsEnabled(boolean sessions) {
        this.useSessions = sessions;
    }

    public boolean getSessionsEnabled() {
        return this.useSessions;
    }

    public void setAsyncSessionPersistence(boolean asyncSessionPersistence) {
        this.asyncSessionPersistence = asyncSessionPersistence;
    }

    public boolean getAsyncSessionPersistence() {
        return this.asyncSessionPersistence;
    }

    public void setAsyncSessionPersistenceQueueName(String asyncSessionPersistenceQueueName) {
        this.asyncSessionPersistenceQueueName = asyncSessionPersistenceQueueName;
    }

    public String getAsyncSessionPersistenceQueueName() {
        return this.asyncSessionPersistenceQueueName;
    }

    public List<StaticFileInclude> getStaticFileIncludes() {
        return this.staticFileIncludes;
    }

    public List<String> getStaticFileExcludes() {
        return this.staticFileExcludes;
    }

    public StaticFileInclude includeStaticPattern(String pattern, String expiration) {
        this.staticIncludePattern = null;
        StaticFileInclude staticFileInclude = new StaticFileInclude(pattern, expiration);
        this.staticFileIncludes.add(staticFileInclude);
        return staticFileInclude;
    }

    public void excludeStaticPattern(String url) {
        this.staticExcludePattern = null;
        this.staticFileExcludes.add(url);
    }

    public List<String> getResourcePatterns() {
        return this.resourceFileIncludes;
    }

    public List<String> getResourceFileExcludes() {
        return this.resourceFileExcludes;
    }

    public void includeResourcePattern(String url) {
        this.resourceExcludePattern = null;
        this.resourceFileIncludes.add(url);
    }

    public void excludeResourcePattern(String url) {
        this.resourceIncludePattern = null;
        this.resourceFileExcludes.add(url);
    }

    public void addUserPermission(String className, String name, String actions) {
        if (className.startsWith("java.")) {
            throw new AppEngineConfigException("Cannot specify user-permissions for classes in java.* packages.");
        }
        this.userPermissions.add(new UserPermission(className, name, actions));
    }

    public Permissions getUserPermissions() {
        Permissions permissions = new Permissions();
        for (UserPermission permission : this.userPermissions) {
            permissions.add(new UnresolvedPermission(permission.getClassName(), permission.getName(), permission.getActions(), null));
        }
        permissions.setReadOnly();
        return permissions;
    }

    public void setPublicRoot(String root) {
        if (root.indexOf(42) != -1) {
            throw new AppEngineConfigException("public-root cannot contain wildcards");
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (root.length() > 0 && !root.startsWith("/")) {
            root = "/" + root;
        }
        this.staticIncludePattern = null;
        this.publicRoot = root;
    }

    public String getPublicRoot() {
        return this.publicRoot;
    }

    public void addInboundService(String service) {
        this.inboundServices.add(service);
    }

    public Set<String> getInboundServices() {
        return this.inboundServices;
    }

    public boolean getPrecompilationEnabled() {
        return this.precompilationEnabled;
    }

    public void setPrecompilationEnabled(boolean precompilationEnabled) {
        this.precompilationEnabled = precompilationEnabled;
    }

    public boolean getWarmupRequestsEnabled() {
        return this.inboundServices.contains(WARMUP_SERVICE);
    }

    public void setWarmupRequestsEnabled(boolean warmupRequestsEnabled) {
        if (warmupRequestsEnabled) {
            this.inboundServices.add(WARMUP_SERVICE);
        } else {
            this.inboundServices.remove(WARMUP_SERVICE);
        }
    }

    public List<AdminConsolePage> getAdminConsolePages() {
        return Collections.unmodifiableList(this.adminConsolePages);
    }

    public void addAdminConsolePage(AdminConsolePage page) {
        this.adminConsolePages.add(page);
    }

    public List<ErrorHandler> getErrorHandlers() {
        return Collections.unmodifiableList(this.errorHandlers);
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    public boolean getThreadsafe() {
        return this.threadsafe;
    }

    public boolean getThreadsafeValueProvided() {
        return this.threadsafeValueProvided;
    }

    public void setThreadsafe(boolean threadsafe) {
        this.threadsafe = threadsafe;
        this.threadsafeValueProvided = true;
    }

    public void setAutoIdPolicy(String policy) {
        this.autoIdPolicy = policy;
    }

    public String getAutoIdPolicy() {
        return this.autoIdPolicy;
    }

    public boolean getCodeLock() {
        return this.codeLock;
    }

    public void setCodeLock(boolean codeLock) {
        this.codeLock = codeLock;
    }

    public void setUseVm(boolean useVm) {
        this.useVm = useVm;
    }

    public boolean getUseVm() {
        return this.useVm;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnv() {
        return this.env;
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public void setApiConfig(ApiConfig config) {
        this.apiConfig = config;
    }

    public ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClassLoaderConfig classLoaderConfig) {
        if (this.classLoaderConfig != null) {
            throw new AppEngineConfigException("class-loader-config may only be specified once.");
        }
        this.classLoaderConfig = classLoaderConfig;
    }

    public String getUrlStreamHandlerType() {
        return this.urlStreamHandlerType;
    }

    public void setUrlStreamHandlerType(String urlStreamHandlerType) {
        if (this.classLoaderConfig != null) {
            throw new AppEngineConfigException("url-stream-handler may only be specified once.");
        }
        if (!URL_HANDLER_URLFETCH.equals(urlStreamHandlerType) && !URL_HANDLER_NATIVE.equals(urlStreamHandlerType)) {
            throw new AppEngineConfigException("url-stream-handler must be urlfetch or native given " + urlStreamHandlerType);
        }
        this.urlStreamHandlerType = urlStreamHandlerType;
    }

    public boolean isApiEndpoint(String id) {
        return this.apiEndpointIds.contains(id);
    }

    public void addApiEndpoint(String id) {
        this.apiEndpointIds.add(id);
    }

    public Pagespeed getPagespeed() {
        return this.pagespeed;
    }

    public void setPagespeed(Pagespeed pagespeed) {
        this.pagespeed = pagespeed;
    }

    public void setUseGoogleConnectorJ(boolean useGoogleConnectorJ) {
        this.useGoogleConnectorJ = useGoogleConnectorJ ? UseGoogleConnectorJ.TRUE : UseGoogleConnectorJ.FALSE;
    }

    public UseGoogleConnectorJ getUseGoogleConnectorJ() {
        return this.useGoogleConnectorJ;
    }

    public String toString() {
        return "AppEngineWebXml{systemProperties=" + this.systemProperties + ", envVariables=" + this.envVariables + ", userPermissions=" + this.userPermissions + ", appId='" + this.appId + '\'' + ", majorVersionId='" + this.majorVersionId + '\'' + ", sourceLanguage='" + this.sourceLanguage + '\'' + ", module='" + this.module + '\'' + ", instanceClass='" + this.instanceClass + '\'' + ", automaticScaling=" + this.automaticScaling + ", manualScaling=" + this.manualScaling + ", basicScaling=" + this.basicScaling + ", healthCheck=" + this.healthCheck + ", resources=" + this.resources + ", network=" + this.network + ", sslEnabled=" + this.sslEnabled + ", useSessions=" + this.useSessions + ", asyncSessionPersistence=" + this.asyncSessionPersistence + ", asyncSessionPersistenceQueueName='" + this.asyncSessionPersistenceQueueName + '\'' + ", staticFileIncludes=" + this.staticFileIncludes + ", staticFileExcludes=" + this.staticFileExcludes + ", resourceFileIncludes=" + this.resourceFileIncludes + ", resourceFileExcludes=" + this.resourceFileExcludes + ", staticIncludePattern=" + this.staticIncludePattern + ", staticExcludePattern=" + this.staticExcludePattern + ", resourceIncludePattern=" + this.resourceIncludePattern + ", resourceExcludePattern=" + this.resourceExcludePattern + ", publicRoot='" + this.publicRoot + '\'' + ", appRoot='" + this.appRoot + '\'' + ", inboundServices=" + this.inboundServices + ", precompilationEnabled=" + this.precompilationEnabled + ", adminConsolePages=" + this.adminConsolePages + ", errorHandlers=" + this.errorHandlers + ", threadsafe=" + this.threadsafe + ", threadsafeValueProvided=" + this.threadsafeValueProvided + ", autoIdPolicy=" + this.autoIdPolicy + ", codeLock=" + this.codeLock + ", apiConfig=" + this.apiConfig + ", apiEndpointIds=" + this.apiEndpointIds + ", pagespeed=" + this.pagespeed + ", classLoaderConfig=" + this.classLoaderConfig + ", urlStreamHandlerType=" + (this.urlStreamHandlerType == null ? URL_HANDLER_URLFETCH : this.urlStreamHandlerType) + ", useGoogleConnectorJ=" + (Object)((Object)this.useGoogleConnectorJ) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEngineWebXml that = (AppEngineWebXml)o;
        if (this.asyncSessionPersistence != that.asyncSessionPersistence) {
            return false;
        }
        if (this.precompilationEnabled != that.precompilationEnabled) {
            return false;
        }
        if (this.sslEnabled != that.sslEnabled) {
            return false;
        }
        if (this.threadsafe != that.threadsafe) {
            return false;
        }
        if (this.threadsafeValueProvided != that.threadsafeValueProvided) {
            return false;
        }
        if (this.autoIdPolicy != null ? !this.autoIdPolicy.equals(that.autoIdPolicy) : that.autoIdPolicy != null) {
            return false;
        }
        if (this.codeLock != that.codeLock) {
            return false;
        }
        if (this.useSessions != that.useSessions) {
            return false;
        }
        if (this.adminConsolePages != null ? !this.adminConsolePages.equals(that.adminConsolePages) : that.adminConsolePages != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (this.majorVersionId != null ? !this.majorVersionId.equals(that.majorVersionId) : that.majorVersionId != null) {
            return false;
        }
        if (this.module != null ? !this.module.equals(that.module) : that.module != null) {
            return false;
        }
        if (this.instanceClass != null ? !this.instanceClass.equals(that.instanceClass) : that.instanceClass != null) {
            return false;
        }
        if (!this.automaticScaling.equals(that.automaticScaling)) {
            return false;
        }
        if (!this.manualScaling.equals(that.manualScaling)) {
            return false;
        }
        if (!this.basicScaling.equals(that.basicScaling)) {
            return false;
        }
        if (this.appRoot != null ? !this.appRoot.equals(that.appRoot) : that.appRoot != null) {
            return false;
        }
        if (this.asyncSessionPersistenceQueueName != null ? !this.asyncSessionPersistenceQueueName.equals(that.asyncSessionPersistenceQueueName) : that.asyncSessionPersistenceQueueName != null) {
            return false;
        }
        if (this.envVariables != null ? !this.envVariables.equals(that.envVariables) : that.envVariables != null) {
            return false;
        }
        if (this.errorHandlers != null ? !this.errorHandlers.equals(that.errorHandlers) : that.errorHandlers != null) {
            return false;
        }
        if (this.inboundServices != null ? !this.inboundServices.equals(that.inboundServices) : that.inboundServices != null) {
            return false;
        }
        if (this.majorVersionId != null ? !this.majorVersionId.equals(that.majorVersionId) : that.majorVersionId != null) {
            return false;
        }
        if (this.sourceLanguage != null ? !this.sourceLanguage.equals(that.sourceLanguage) : that.sourceLanguage != null) {
            return false;
        }
        if (this.publicRoot != null ? !this.publicRoot.equals(that.publicRoot) : that.publicRoot != null) {
            return false;
        }
        if (this.resourceExcludePattern != null ? !this.resourceExcludePattern.equals(that.resourceExcludePattern) : that.resourceExcludePattern != null) {
            return false;
        }
        if (this.resourceFileExcludes != null ? !this.resourceFileExcludes.equals(that.resourceFileExcludes) : that.resourceFileExcludes != null) {
            return false;
        }
        if (this.resourceFileIncludes != null ? !this.resourceFileIncludes.equals(that.resourceFileIncludes) : that.resourceFileIncludes != null) {
            return false;
        }
        if (this.resourceIncludePattern != null ? !this.resourceIncludePattern.equals(that.resourceIncludePattern) : that.resourceIncludePattern != null) {
            return false;
        }
        if (this.staticExcludePattern != null ? !this.staticExcludePattern.equals(that.staticExcludePattern) : that.staticExcludePattern != null) {
            return false;
        }
        if (this.staticFileExcludes != null ? !this.staticFileExcludes.equals(that.staticFileExcludes) : that.staticFileExcludes != null) {
            return false;
        }
        if (this.staticFileIncludes != null ? !this.staticFileIncludes.equals(that.staticFileIncludes) : that.staticFileIncludes != null) {
            return false;
        }
        if (this.staticIncludePattern != null ? !this.staticIncludePattern.equals(that.staticIncludePattern) : that.staticIncludePattern != null) {
            return false;
        }
        if (this.systemProperties != null ? !this.systemProperties.equals(that.systemProperties) : that.systemProperties != null) {
            return false;
        }
        if (this.betaSettings != null ? !this.betaSettings.equals(that.betaSettings) : that.betaSettings != null) {
            return false;
        }
        if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.userPermissions != null ? !this.userPermissions.equals(that.userPermissions) : that.userPermissions != null) {
            return false;
        }
        if (this.apiConfig != null ? !this.apiConfig.equals(that.apiConfig) : that.apiConfig != null) {
            return false;
        }
        if (this.apiEndpointIds != null ? !this.apiEndpointIds.equals(that.apiEndpointIds) : that.apiEndpointIds != null) {
            return false;
        }
        if (this.pagespeed != null ? !this.pagespeed.equals(that.pagespeed) : that.pagespeed != null) {
            return false;
        }
        if (this.classLoaderConfig != null ? !this.classLoaderConfig.equals(that.classLoaderConfig) : that.classLoaderConfig != null) {
            return false;
        }
        if (this.urlStreamHandlerType != null ? !this.urlStreamHandlerType.equals(that.urlStreamHandlerType) : that.urlStreamHandlerType != null) {
            return false;
        }
        return this.useGoogleConnectorJ == that.useGoogleConnectorJ;
    }

    public int hashCode() {
        int result = this.systemProperties != null ? this.systemProperties.hashCode() : 0;
        result = 31 * result + (this.envVariables != null ? this.envVariables.hashCode() : 0);
        result = 31 * result + (this.userPermissions != null ? this.userPermissions.hashCode() : 0);
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.majorVersionId != null ? this.majorVersionId.hashCode() : 0);
        result = 31 * result + (this.sourceLanguage != null ? this.sourceLanguage.hashCode() : 0);
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        result = 31 * result + (this.instanceClass != null ? this.instanceClass.hashCode() : 0);
        result = 31 * result + this.automaticScaling.hashCode();
        result = 31 * result + this.manualScaling.hashCode();
        result = 31 * result + this.basicScaling.hashCode();
        result = 31 * result + (this.sslEnabled ? 1 : 0);
        result = 31 * result + (this.useSessions ? 1 : 0);
        result = 31 * result + (this.asyncSessionPersistence ? 1 : 0);
        result = 31 * result + (this.asyncSessionPersistenceQueueName != null ? this.asyncSessionPersistenceQueueName.hashCode() : 0);
        result = 31 * result + (this.staticFileIncludes != null ? this.staticFileIncludes.hashCode() : 0);
        result = 31 * result + (this.staticFileExcludes != null ? this.staticFileExcludes.hashCode() : 0);
        result = 31 * result + (this.resourceFileIncludes != null ? this.resourceFileIncludes.hashCode() : 0);
        result = 31 * result + (this.resourceFileExcludes != null ? this.resourceFileExcludes.hashCode() : 0);
        result = 31 * result + (this.staticIncludePattern != null ? this.staticIncludePattern.hashCode() : 0);
        result = 31 * result + (this.staticExcludePattern != null ? this.staticExcludePattern.hashCode() : 0);
        result = 31 * result + (this.resourceIncludePattern != null ? this.resourceIncludePattern.hashCode() : 0);
        result = 31 * result + (this.resourceExcludePattern != null ? this.resourceExcludePattern.hashCode() : 0);
        result = 31 * result + (this.publicRoot != null ? this.publicRoot.hashCode() : 0);
        result = 31 * result + (this.appRoot != null ? this.appRoot.hashCode() : 0);
        result = 31 * result + (this.inboundServices != null ? this.inboundServices.hashCode() : 0);
        result = 31 * result + (this.precompilationEnabled ? 1 : 0);
        result = 31 * result + (this.adminConsolePages != null ? this.adminConsolePages.hashCode() : 0);
        result = 31 * result + (this.errorHandlers != null ? this.errorHandlers.hashCode() : 0);
        result = 31 * result + (this.threadsafe ? 1 : 0);
        result = 31 * result + (this.autoIdPolicy != null ? this.autoIdPolicy.hashCode() : 0);
        result = 31 * result + (this.threadsafeValueProvided ? 1 : 0);
        result = 31 * result + (this.codeLock ? 1 : 0);
        result = 31 * result + (this.apiConfig != null ? this.apiConfig.hashCode() : 0);
        result = 31 * result + (this.apiEndpointIds != null ? this.apiEndpointIds.hashCode() : 0);
        result = 31 * result + (this.pagespeed != null ? this.pagespeed.hashCode() : 0);
        result = 31 * result + (this.classLoaderConfig != null ? this.classLoaderConfig.hashCode() : 0);
        result = 31 * result + (this.urlStreamHandlerType != null ? this.urlStreamHandlerType.hashCode() : 0);
        result = 31 * result + this.useGoogleConnectorJ.hashCode();
        result = 31 * result + (this.betaSettings != null ? this.betaSettings.hashCode() : 0);
        result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
        result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
        result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
        return result;
    }

    public boolean includesResource(String path) {
        if (this.resourceIncludePattern == null) {
            this.resourceIncludePattern = this.resourceFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.resourceFileIncludes));
        }
        if (this.resourceExcludePattern == null && this.resourceFileExcludes.size() > 0) {
            this.resourceExcludePattern = Pattern.compile(this.makeRegexp(this.resourceFileExcludes));
        }
        return this.includes(path, this.resourceIncludePattern, this.resourceExcludePattern);
    }

    public boolean includesStatic(String path) {
        if (this.staticIncludePattern == null) {
            if (this.staticFileIncludes.size() == 0) {
                String staticRoot = this.publicRoot.length() > 0 ? this.publicRoot + "/**" : "**";
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(Collections.singletonList(staticRoot)));
            } else {
                ArrayList<String> patterns = new ArrayList<String>();
                for (StaticFileInclude include : this.staticFileIncludes) {
                    patterns.add(include.getPattern());
                }
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(patterns));
            }
        }
        if (this.staticExcludePattern == null && this.staticFileExcludes.size() > 0) {
            this.staticExcludePattern = Pattern.compile(this.makeRegexp(this.staticFileExcludes));
        }
        return this.includes(path, this.staticIncludePattern, this.staticExcludePattern);
    }

    public boolean includes(String path, Pattern includes, Pattern excludes) {
        assert (includes != null);
        if (!includes.matcher(path).matches()) {
            return false;
        }
        return excludes == null || !excludes.matcher(path).matches();
    }

    public String makeRegexp(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : patterns) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            while (item.charAt(0) == '/') {
                item = item.substring(1);
            }
            builder.append('(');
            if (this.appRoot != null) {
                builder.append(AppEngineWebXml.makeFileRegex(this.appRoot));
            }
            builder.append("/");
            builder.append(AppEngineWebXml.makeFileRegex(item));
            builder.append(')');
        }
        return builder.toString();
    }

    static String makeFileRegex(String fileGlob) {
        fileGlob = fileGlob.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        fileGlob = fileGlob.replaceAll("\\\\\\*\\\\\\*", ".*");
        fileGlob = fileGlob.replaceAll("\\\\\\*", "[^/]*");
        return fileGlob;
    }

    public void setSourcePrefix(String appRoot) {
        this.appRoot = appRoot;
        this.resourceIncludePattern = null;
        this.resourceExcludePattern = null;
        this.staticIncludePattern = null;
        this.staticExcludePattern = null;
    }

    public String getSourcePrefix() {
        return this.appRoot;
    }

    private static String toNullIfEmptyOrWhitespace(String string) {
        if (string == null || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)string)) {
            return null;
        }
        return string;
    }

    public static class PrioritySpecifierEntry {
        private String filename;
        private Double priority;

        private void checkNotAlreadySet() {
            if (this.filename != null) {
                throw new AppEngineConfigException("Found more that one file name matching tag. Only one of 'filename' attribute allowed.");
            }
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.checkNotAlreadySet();
            this.filename = filename;
        }

        public Double getPriority() {
            return this.priority;
        }

        public double getPriorityValue() {
            if (this.priority == null) {
                return 1.0;
            }
            return this.priority;
        }

        public void setPriority(String priority) {
            if (this.priority != null) {
                throw new AppEngineConfigException("The 'priority' tag may only be specified once.");
            }
            if (priority == null) {
                this.priority = null;
                return;
            }
            this.priority = Double.parseDouble(priority);
        }

        public void checkClassLoaderConfig() {
            if (this.filename == null) {
                throw new AppEngineConfigException("Must have a filename attribute.");
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrioritySpecifierEntry other = (PrioritySpecifierEntry)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
        }

        public String toString() {
            return "PrioritySpecifierEntry{filename=\"" + this.filename + "\", priority=\"" + this.priority + "\"}";
        }
    }

    public static class ClassLoaderConfig {
        private final List<PrioritySpecifierEntry> entries = Lists.newArrayList();

        public void add(PrioritySpecifierEntry entry) {
            this.entries.add(entry);
        }

        public List<PrioritySpecifierEntry> getEntries() {
            return this.entries;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLoaderConfig other = (ClassLoaderConfig)obj;
            return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
        }

        public String toString() {
            return "ClassLoaderConfig{entries=\"" + this.entries + "\"}";
        }
    }

    public static class Pagespeed {
        private final List<String> urlBlacklist = Lists.newArrayList();
        private final List<String> domainsToRewrite = Lists.newArrayList();
        private final List<String> enabledRewriters = Lists.newArrayList();
        private final List<String> disabledRewriters = Lists.newArrayList();

        public void addUrlBlacklist(String url) {
            this.urlBlacklist.add(url);
        }

        public List<String> getUrlBlacklist() {
            return Collections.unmodifiableList(this.urlBlacklist);
        }

        public void addDomainToRewrite(String domain) {
            this.domainsToRewrite.add(domain);
        }

        public List<String> getDomainsToRewrite() {
            return Collections.unmodifiableList(this.domainsToRewrite);
        }

        public void addEnabledRewriter(String rewriter) {
            this.enabledRewriters.add(rewriter);
        }

        public List<String> getEnabledRewriters() {
            return Collections.unmodifiableList(this.enabledRewriters);
        }

        public void addDisabledRewriter(String rewriter) {
            this.disabledRewriters.add(rewriter);
        }

        public List<String> getDisabledRewriters() {
            return Collections.unmodifiableList(this.disabledRewriters);
        }

        public boolean isEmpty() {
            return this.urlBlacklist.isEmpty() && this.domainsToRewrite.isEmpty() && this.enabledRewriters.isEmpty() && this.disabledRewriters.isEmpty();
        }

        public int hashCode() {
            return Objects.hash(this.urlBlacklist, this.domainsToRewrite, this.enabledRewriters, this.disabledRewriters);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pagespeed other = (Pagespeed)obj;
            return Objects.equals(this.urlBlacklist, other.urlBlacklist) && Objects.equals(this.domainsToRewrite, other.domainsToRewrite) && Objects.equals(this.enabledRewriters, other.enabledRewriters) && Objects.equals(this.disabledRewriters, other.disabledRewriters);
        }

        public String toString() {
            return "Pagespeed [urlBlacklist=" + this.urlBlacklist + ", domainsToRewrite=" + this.domainsToRewrite + ", enabledRewriters=" + this.enabledRewriters + ", disabledRewriters=" + this.disabledRewriters + "]";
        }
    }

    public static class BasicScaling {
        private static final BasicScaling EMPTY_SETTINGS = new BasicScaling();
        private String maxInstances;
        private String idleTimeout;

        public String getMaxInstances() {
            return this.maxInstances;
        }

        public String getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setMaxInstances(String maxInstances) {
            this.maxInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxInstances);
        }

        public void setIdleTimeout(String idleTimeout) {
            this.idleTimeout = AppEngineWebXml.toNullIfEmptyOrWhitespace(idleTimeout);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.maxInstances, this.idleTimeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicScaling other = (BasicScaling)obj;
            return Objects.equals(this.maxInstances, other.maxInstances) && Objects.equals(this.idleTimeout, other.idleTimeout);
        }

        public String toString() {
            return "BasicScaling [maxInstances=" + this.maxInstances + ", idleTimeout=" + this.idleTimeout + "]";
        }
    }

    public static class ManualScaling {
        private static final ManualScaling EMPTY_SETTINGS = new ManualScaling();
        private String instances;

        public String getInstances() {
            return this.instances;
        }

        public void setInstances(String instances) {
            this.instances = AppEngineWebXml.toNullIfEmptyOrWhitespace(instances);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.instances);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManualScaling other = (ManualScaling)obj;
            return Objects.equals(this.instances, other.instances);
        }

        public String toString() {
            return "ManualScaling [instances=" + this.instances + "]";
        }
    }

    public static class Network {
        private static final Network EMPTY_SETTINGS = new Network();
        private String instanceTag;
        private final List<String> forwardedPorts = Lists.newArrayList();
        private String name;

        public String getInstanceTag() {
            return this.instanceTag;
        }

        public void setInstanceTag(String instanceTag) {
            this.instanceTag = instanceTag;
        }

        public List<String> getForwardedPorts() {
            return Collections.unmodifiableList(this.forwardedPorts);
        }

        public void addForwardedPort(String forwardedPort) {
            this.forwardedPorts.add(forwardedPort);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.forwardedPorts, this.instanceTag);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Network other = (Network)obj;
            return Objects.equals(this.forwardedPorts, other.forwardedPorts) && Objects.equals(this.instanceTag, other.instanceTag);
        }

        public String toString() {
            return "Network [forwardedPorts=" + this.forwardedPorts + ", instanceTag=" + this.instanceTag + "]";
        }
    }

    public static class Resources {
        private static final Resources EMPTY_SETTINGS = new Resources();
        private double cpu;
        private double memory_gb;
        private int disk_size_gb;

        public double getCpu() {
            return this.cpu;
        }

        public void setCpu(double cpu) {
            this.cpu = cpu;
        }

        public double getMemoryGb() {
            return this.memory_gb;
        }

        public void setMemoryGb(double memory_gb) {
            this.memory_gb = memory_gb;
        }

        public int getDiskSizeGb() {
            return this.disk_size_gb;
        }

        public void setDiskSizeGb(int disk_size_gb) {
            this.disk_size_gb = disk_size_gb;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.cpu, this.memory_gb, this.disk_size_gb);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resources other = (Resources)obj;
            return Objects.equals(this.cpu, other.cpu) && Objects.equals(this.memory_gb, other.memory_gb) && Objects.equals(this.disk_size_gb, other.disk_size_gb);
        }

        public String toString() {
            return "Resources [cpu=" + this.cpu + ", memory_gb=" + this.memory_gb + ", disk_size_gb=" + this.disk_size_gb + "]";
        }
    }

    public static class HealthCheck {
        private static final HealthCheck EMPTY_SETTINGS = new HealthCheck();
        private boolean enableHealthCheck = true;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;
        private Integer restartThreshold;
        private String host;

        public boolean getEnableHealthCheck() {
            return this.enableHealthCheck;
        }

        public void setEnableHealthCheck(boolean enableHealthCheck) {
            this.enableHealthCheck = enableHealthCheck;
        }

        public Integer getCheckIntervalSec() {
            return this.checkIntervalSec;
        }

        public void setCheckIntervalSec(Integer checkIntervalSec) {
            this.checkIntervalSec = checkIntervalSec;
        }

        public Integer getTimeoutSec() {
            return this.timeoutSec;
        }

        public void setTimeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
        }

        public Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public Integer getRestartThreshold() {
            return this.restartThreshold;
        }

        public void setRestartThreshold(Integer restartThreshold) {
            this.restartThreshold = restartThreshold;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = AppEngineWebXml.toNullIfEmptyOrWhitespace(host);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.enableHealthCheck, this.checkIntervalSec, this.timeoutSec, this.unhealthyThreshold, this.healthyThreshold, this.restartThreshold, this.host);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HealthCheck other = (HealthCheck)obj;
            return Objects.equals(this.enableHealthCheck, other.enableHealthCheck) && Objects.equals(this.checkIntervalSec, other.checkIntervalSec) && Objects.equals(this.timeoutSec, other.timeoutSec) && Objects.equals(this.unhealthyThreshold, other.unhealthyThreshold) && Objects.equals(this.healthyThreshold, other.healthyThreshold) && Objects.equals(this.restartThreshold, other.restartThreshold) && Objects.equals(this.host, other.host);
        }

        public String toString() {
            return "HealthCheck [enableHealthCheck=" + this.enableHealthCheck + ", checkIntervalSec=" + this.checkIntervalSec + ", timeoutSec=" + this.timeoutSec + ", unhealthyThreshold=" + this.unhealthyThreshold + ", healthyThreshold=" + this.healthyThreshold + ", restartThreshold=" + this.restartThreshold + ", host=" + this.host + "]";
        }
    }

    public static class CpuUtilization {
        private static final CpuUtilization EMPTY_SETTINGS = new CpuUtilization();
        private Double targetUtilization;
        private Integer aggregationWindowLengthSec;

        public Double getTargetUtilization() {
            return this.targetUtilization;
        }

        public void setTargetUtilization(Double targetUtilization) {
            this.targetUtilization = targetUtilization;
        }

        public Integer getAggregationWindowLengthSec() {
            return this.aggregationWindowLengthSec;
        }

        public void setAggregationWindowLengthSec(Integer aggregationWindowLengthSec) {
            this.aggregationWindowLengthSec = aggregationWindowLengthSec;
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public int hashCode() {
            return Objects.hash(this.targetUtilization, this.aggregationWindowLengthSec);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CpuUtilization other = (CpuUtilization)obj;
            return Objects.equals(this.targetUtilization, other.targetUtilization) && Objects.equals(this.aggregationWindowLengthSec, other.aggregationWindowLengthSec);
        }

        public String toString() {
            return "CpuUtilization [targetUtilization=" + this.targetUtilization + ", aggregationWindowLengthSec=" + this.aggregationWindowLengthSec + "]";
        }
    }

    public static class AutomaticScaling {
        private static final AutomaticScaling EMPTY_SETTINGS = new AutomaticScaling();
        public static final String AUTOMATIC = "automatic";
        private String minPendingLatency;
        private String maxPendingLatency;
        private String minIdleInstances;
        private String maxIdleInstances;
        private String maxConcurrentRequests;
        private Integer minNumInstances;
        private Integer maxNumInstances;
        private Integer coolDownPeriodSec;
        private CpuUtilization cpuUtilization;
        private Integer targetNetworkSentBytesPerSec;
        private Integer targetNetworkSentPacketsPerSec;
        private Integer targetNetworkReceivedBytesPerSec;
        private Integer targetNetworkReceivedPacketsPerSec;
        private Integer targetDiskWriteBytesPerSec;
        private Integer targetDiskWriteOpsPerSec;
        private Integer targetDiskReadBytesPerSec;
        private Integer targetDiskReadOpsPerSec;
        private Integer targetRequestCountPerSec;
        private Integer targetConcurrentRequests;

        public String getMinPendingLatency() {
            return this.minPendingLatency;
        }

        public void setMinPendingLatency(String minPendingLatency) {
            this.minPendingLatency = AppEngineWebXml.toNullIfEmptyOrWhitespace(minPendingLatency);
        }

        public String getMaxPendingLatency() {
            return this.maxPendingLatency;
        }

        public void setMaxPendingLatency(String maxPendingLatency) {
            this.maxPendingLatency = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxPendingLatency);
        }

        public String getMinIdleInstances() {
            return this.minIdleInstances;
        }

        public void setMinIdleInstances(String minIdleInstances) {
            this.minIdleInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(minIdleInstances);
        }

        public String getMaxIdleInstances() {
            return this.maxIdleInstances;
        }

        public void setMaxIdleInstances(String maxIdleInstances) {
            this.maxIdleInstances = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxIdleInstances);
        }

        public boolean isEmpty() {
            return this.equals(EMPTY_SETTINGS);
        }

        public String getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(String maxConcurrentRequests) {
            this.maxConcurrentRequests = AppEngineWebXml.toNullIfEmptyOrWhitespace(maxConcurrentRequests);
        }

        public Integer getMinNumInstances() {
            return this.minNumInstances;
        }

        public void setMinNumInstances(Integer minNumInstances) {
            this.minNumInstances = minNumInstances;
        }

        public Integer getMaxNumInstances() {
            return this.maxNumInstances;
        }

        public void setMaxNumInstances(Integer maxNumInstances) {
            this.maxNumInstances = maxNumInstances;
        }

        public Integer getCoolDownPeriodSec() {
            return this.coolDownPeriodSec;
        }

        public void setCoolDownPeriodSec(Integer coolDownPeriodSec) {
            this.coolDownPeriodSec = coolDownPeriodSec;
        }

        public CpuUtilization getCpuUtilization() {
            return this.cpuUtilization;
        }

        public void setCpuUtilization(CpuUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
        }

        public Integer getTargetNetworkSentBytesPerSec() {
            return this.targetNetworkSentBytesPerSec;
        }

        public void setTargetNetworkSentBytesPerSec(Integer targetNetworkSentBytesPerSec) {
            this.targetNetworkSentBytesPerSec = targetNetworkSentBytesPerSec;
        }

        public Integer getTargetNetworkSentPacketsPerSec() {
            return this.targetNetworkSentPacketsPerSec;
        }

        public void setTargetNetworkSentPacketsPerSec(Integer targetNetworkSentPacketsPerSec) {
            this.targetNetworkSentPacketsPerSec = targetNetworkSentPacketsPerSec;
        }

        public Integer getTargetNetworkReceivedBytesPerSec() {
            return this.targetNetworkReceivedBytesPerSec;
        }

        public void setTargetNetworkReceivedBytesPerSec(Integer targetNetworkReceivedBytesPerSec) {
            this.targetNetworkReceivedBytesPerSec = targetNetworkReceivedBytesPerSec;
        }

        public Integer getTargetNetworkReceivedPacketsPerSec() {
            return this.targetNetworkReceivedPacketsPerSec;
        }

        public void setTargetNetworkReceivedPacketsPerSec(Integer targetNetworkReceivedPacketsPerSec) {
            this.targetNetworkReceivedPacketsPerSec = targetNetworkReceivedPacketsPerSec;
        }

        public Integer getTargetDiskWriteBytesPerSec() {
            return this.targetDiskWriteBytesPerSec;
        }

        public void setTargetDiskWriteBytesPerSec(Integer targetDiskWriteBytesPerSec) {
            this.targetDiskWriteBytesPerSec = targetDiskWriteBytesPerSec;
        }

        public Integer getTargetDiskWriteOpsPerSec() {
            return this.targetDiskWriteOpsPerSec;
        }

        public void setTargetDiskWriteOpsPerSec(Integer targetDiskWriteOpsPerSec) {
            this.targetDiskWriteOpsPerSec = targetDiskWriteOpsPerSec;
        }

        public Integer getTargetDiskReadBytesPerSec() {
            return this.targetDiskReadBytesPerSec;
        }

        public void setTargetDiskReadBytesPerSec(Integer targetDiskReadBytesPerSec) {
            this.targetDiskReadBytesPerSec = targetDiskReadBytesPerSec;
        }

        public Integer getTargetDiskReadOpsPerSec() {
            return this.targetDiskReadOpsPerSec;
        }

        public void setTargetDiskReadOpsPerSec(Integer targetDiskReadOpsPerSec) {
            this.targetDiskReadOpsPerSec = targetDiskReadOpsPerSec;
        }

        public Integer getTargetRequestCountPerSec() {
            return this.targetRequestCountPerSec;
        }

        public void setTargetRequestCountPerSec(Integer targetRequestCountPerSec) {
            this.targetRequestCountPerSec = targetRequestCountPerSec;
        }

        public Integer getTargetConcurrentRequests() {
            return this.targetConcurrentRequests;
        }

        public void setTargetConcurrentRequests(Integer targetConcurrentRequests) {
            this.targetConcurrentRequests = targetConcurrentRequests;
        }

        public int hashCode() {
            return Objects.hash(this.maxPendingLatency, this.minPendingLatency, this.maxIdleInstances, this.minIdleInstances, this.maxConcurrentRequests, this.minNumInstances, this.maxNumInstances, this.coolDownPeriodSec, this.cpuUtilization, this.targetNetworkSentBytesPerSec, this.targetNetworkSentPacketsPerSec, this.targetNetworkReceivedBytesPerSec, this.targetNetworkReceivedPacketsPerSec, this.targetDiskWriteBytesPerSec, this.targetDiskWriteOpsPerSec, this.targetDiskReadBytesPerSec, this.targetDiskReadOpsPerSec, this.targetRequestCountPerSec, this.targetConcurrentRequests);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutomaticScaling other = (AutomaticScaling)obj;
            return Objects.equals(this.maxPendingLatency, other.maxPendingLatency) && Objects.equals(this.minPendingLatency, other.minPendingLatency) && Objects.equals(this.maxIdleInstances, other.maxIdleInstances) && Objects.equals(this.minIdleInstances, other.minIdleInstances) && Objects.equals(this.maxConcurrentRequests, other.maxConcurrentRequests) && Objects.equals(this.minNumInstances, other.minNumInstances) && Objects.equals(this.maxNumInstances, other.maxNumInstances) && Objects.equals(this.coolDownPeriodSec, other.coolDownPeriodSec) && Objects.equals(this.cpuUtilization, other.cpuUtilization) && Objects.equals(this.targetNetworkSentBytesPerSec, other.targetNetworkSentBytesPerSec) && Objects.equals(this.targetNetworkSentPacketsPerSec, other.targetNetworkSentPacketsPerSec) && Objects.equals(this.targetNetworkReceivedBytesPerSec, other.targetNetworkReceivedBytesPerSec) && Objects.equals(this.targetNetworkReceivedPacketsPerSec, other.targetNetworkReceivedPacketsPerSec) && Objects.equals(this.targetDiskWriteBytesPerSec, other.targetDiskWriteBytesPerSec) && Objects.equals(this.targetDiskWriteOpsPerSec, other.targetDiskWriteOpsPerSec) && Objects.equals(this.targetDiskReadBytesPerSec, other.targetDiskReadBytesPerSec) && Objects.equals(this.targetDiskReadOpsPerSec, other.targetDiskReadOpsPerSec) && Objects.equals(this.targetRequestCountPerSec, other.targetRequestCountPerSec) && Objects.equals(this.targetConcurrentRequests, other.targetConcurrentRequests);
        }

        public String toString() {
            return "AutomaticScaling [minPendingLatency=" + this.minPendingLatency + ", maxPendingLatency=" + this.maxPendingLatency + ", minIdleInstances=" + this.minIdleInstances + ", maxIdleInstances=" + this.maxIdleInstances + ", maxConcurrentRequests=" + this.maxConcurrentRequests + ", minNumInstances=" + this.minNumInstances + ", maxNumInstances=" + this.maxNumInstances + ", coolDownPeriodSec=" + this.coolDownPeriodSec + ", cpuUtilization=" + this.cpuUtilization + ", targetNetworkSentBytesPerSec=" + this.targetNetworkSentBytesPerSec + ", targetNetworkSentPacketsPerSec=" + this.targetNetworkSentPacketsPerSec + ", targetNetworkReceivedBytesPerSec=" + this.targetNetworkReceivedBytesPerSec + ", targetNetworkReceivedPacketsPerSec=" + this.targetNetworkReceivedPacketsPerSec + ", targetDiskWriteBytesPerSec=" + this.targetDiskWriteBytesPerSec + ", targetDiskWriteOpsPerSec=" + this.targetDiskWriteOpsPerSec + ", targetDiskReadBytesPerSec=" + this.targetDiskReadBytesPerSec + ", targetDiskReadOpsPerSec=" + this.targetDiskReadOpsPerSec + ", targetRequestCountPerSec=" + this.targetRequestCountPerSec + ", targetConcurrentRequests=" + this.targetConcurrentRequests + "]";
        }
    }

    public static class ApiConfig {
        private final String servletClass;
        private final String url;

        public ApiConfig(String servletClass, String url) {
            this.servletClass = servletClass;
            this.url = url;
        }

        public String getservletClass() {
            return this.servletClass;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.servletClass == null ? 0 : this.servletClass.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApiConfig other = (ApiConfig)obj;
            if (this.servletClass == null ? other.servletClass != null : !this.servletClass.equals(other.servletClass)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "ApiConfig{servletClass=\"" + this.servletClass + "\", url=\"" + this.url + "\"}";
        }
    }

    public static class ErrorHandler {
        private final String file;
        private final String errorCode;

        public ErrorHandler(String file, String errorCode) {
            this.file = file;
            this.errorCode = errorCode;
        }

        public String getFile() {
            return this.file;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorHandler)) {
                return false;
            }
            ErrorHandler handler = (ErrorHandler)obj;
            if (!this.file.equals(handler.file)) {
                return false;
            }
            return !(this.errorCode == null ? handler.errorCode != null : !this.errorCode.equals(handler.errorCode));
        }
    }

    public static class AdminConsolePage {
        private final String name;
        private final String url;

        public AdminConsolePage(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdminConsolePage other = (AdminConsolePage)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public static class StaticFileInclude {
        private final String pattern;
        private final String expiration;
        private final Map<String, String> httpHeaders;

        public StaticFileInclude(String pattern, String expiration) {
            this.pattern = pattern;
            this.expiration = expiration;
            this.httpHeaders = new LinkedHashMap<String, String>();
        }

        public String getPattern() {
            return this.pattern;
        }

        public Pattern getRegularExpression() {
            return Pattern.compile(AppEngineWebXml.makeFileRegex(this.pattern));
        }

        public String getExpiration() {
            return this.expiration;
        }

        public Map<String, String> getHttpHeaders() {
            return this.httpHeaders;
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.expiration, this.httpHeaders);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StaticFileInclude)) {
                return false;
            }
            StaticFileInclude other = (StaticFileInclude)obj;
            if (this.pattern != null ? !this.pattern.equals(other.pattern) : other.pattern != null) {
                return false;
            }
            if (this.expiration != null ? !this.expiration.equals(other.expiration) : other.expiration != null) {
                return false;
            }
            return !(this.httpHeaders != null ? !this.httpHeaders.equals(other.httpHeaders) : other.httpHeaders != null);
        }
    }

    private static class UserPermission {
        private final String className;
        private final String name;
        private final String actions;
        private boolean hasHashCode = false;
        private int hashCode;

        public UserPermission(String className, String name, String actions) {
            this.className = className;
            this.name = name;
            this.actions = actions;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getActions() {
            return this.actions;
        }

        public int hashCode() {
            if (this.hasHashCode) {
                return this.hashCode;
            }
            int hash = this.className.hashCode();
            hash = 31 * hash + this.name.hashCode();
            if (this.actions != null) {
                hash = 31 * hash + this.actions.hashCode();
            }
            this.hashCode = hash;
            this.hasHashCode = true;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UserPermission) {
                UserPermission perm = (UserPermission)obj;
                if (this.className.equals(perm.className) && this.name.equals(perm.name) && (this.actions == null ? perm.actions == null : this.actions.equals(perm.actions))) {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum UseGoogleConnectorJ {
        NOT_STATED_BY_USER,
        TRUE,
        FALSE;

    }

    public static enum ScalingType {
        AUTOMATIC,
        MANUAL,
        BASIC;

    }
}

