/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AppEngineWebXmlProcessor {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlProcessor.class.getName());

    AppEngineWebXmlProcessor() {
    }

    public AppEngineWebXml processXml(InputStream is) {
        Element config = this.getTopLevelNode(is);
        AppEngineWebXml appEngineWebXml = new AppEngineWebXml();
        appEngineWebXml.setWarmupRequestsEnabled(true);
        NodeList nodes = config.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.processSecondLevelNode((Element)Element.class.cast(node), appEngineWebXml);
        }
        AppEngineWebXmlProcessor.checkScalingConstraints(appEngineWebXml);
        return appEngineWebXml;
    }

    private static void checkScalingConstraints(AppEngineWebXml appEngineWebXml) {
        int count = appEngineWebXml.getManualScaling().isEmpty() ? 0 : 1;
        count += appEngineWebXml.getBasicScaling().isEmpty() ? 0 : 1;
        if ((count += appEngineWebXml.getAutomaticScaling().isEmpty() ? 0 : 1) > 1) {
            throw new AppEngineConfigException("There may be only one of 'automatic-scaling', 'manual-scaling' or 'basic-scaling' elements.");
        }
    }

    Element getTopLevelNode(InputStream is) {
        return XmlUtils.parseXml(is).getDocumentElement();
    }

    private void processSecondLevelNode(Element elt, AppEngineWebXml appEngineWebXml) {
        String elementName = elt.getTagName();
        if (elementName.equals("system-properties")) {
            this.processSystemPropertiesNode(elt, appEngineWebXml);
        } else if (elementName.equals("vm-settings") || elementName.equals("beta-settings")) {
            this.processBetaSettingsNode(elt, appEngineWebXml);
        } else if (elementName.equals("vm-health-check") || elementName.equals("health-check")) {
            this.processHealthCheckNode(elt, appEngineWebXml);
        } else if (elementName.equals("resources")) {
            this.processResourcesNode(elt, appEngineWebXml);
        } else if (elementName.equals("network")) {
            this.processNetworkNode(elt, appEngineWebXml);
        } else if (elementName.equals("env-variables")) {
            this.processEnvironmentVariablesNode(elt, appEngineWebXml);
        } else if (elementName.equals("application")) {
            this.processApplicationNode(elt, appEngineWebXml);
        } else if (elementName.equals("version")) {
            this.processVersionNode(elt, appEngineWebXml);
        } else if (elementName.equals("source-language")) {
            this.processSourceLanguageNode(elt, appEngineWebXml);
        } else if (elementName.equals("module")) {
            this.processModuleNode(elt, appEngineWebXml);
        } else if (elementName.equals("instance-class")) {
            this.processInstanceClassNode(elt, appEngineWebXml);
        } else if (elementName.equals("automatic-scaling")) {
            this.processAutomaticScalingNode(elt, appEngineWebXml);
        } else if (elementName.equals("manual-scaling")) {
            this.processManualScalingNode(elt, appEngineWebXml);
        } else if (elementName.equals("basic-scaling")) {
            this.processBasicScalingNode(elt, appEngineWebXml);
        } else if (elementName.equals("static-files")) {
            this.processFilesetNode(elt, appEngineWebXml, FileType.STATIC);
        } else if (elementName.equals("resource-files")) {
            this.processFilesetNode(elt, appEngineWebXml, FileType.RESOURCE);
        } else if (elementName.equals("ssl-enabled")) {
            this.processSslEnabledNode(elt, appEngineWebXml);
        } else if (elementName.equals("sessions-enabled")) {
            this.processSessionsEnabledNode(elt, appEngineWebXml);
        } else if (elementName.equals("async-session-persistence")) {
            this.processAsyncSessionPersistenceNode(elt, appEngineWebXml);
        } else if (elementName.equals("user-permissions")) {
            this.processPermissionsNode(elt, appEngineWebXml);
        } else if (elementName.equals("public-root")) {
            this.processPublicRootNode(elt, appEngineWebXml);
        } else if (elementName.equals("inbound-services")) {
            this.processInboundServicesNode(elt, appEngineWebXml);
        } else if (elementName.equals("precompilation-enabled")) {
            this.processPrecompilationEnabledNode(elt, appEngineWebXml);
        } else if (elementName.equals("admin-console")) {
            this.processAdminConsoleNode(elt, appEngineWebXml);
        } else if (elementName.equals("static-error-handlers")) {
            this.processErrorHandlerNode(elt, appEngineWebXml);
        } else if (elementName.equals("warmup-requests-enabled")) {
            this.processWarmupRequestsEnabledNode(elt, appEngineWebXml);
        } else if (elementName.equals("threadsafe")) {
            this.processThreadsafeNode(elt, appEngineWebXml);
        } else if (elementName.equals("auto-id-policy")) {
            this.processAutoIdPolicyNode(elt, appEngineWebXml);
        } else if (elementName.equals("code-lock")) {
            this.processCodeLockNode(elt, appEngineWebXml);
        } else if (elementName.equals("vm")) {
            this.processVmNode(elt, appEngineWebXml);
        } else if (elementName.equals("env")) {
            this.processEnvNode(elt, appEngineWebXml);
        } else if (elementName.equals("api-config")) {
            this.processApiConfigNode(elt, appEngineWebXml);
        } else if (elementName.equals("pagespeed")) {
            this.processPagespeedNode(elt, appEngineWebXml);
        } else if (elementName.equals("class-loader-config")) {
            this.processClassLoaderConfig(elt, appEngineWebXml);
        } else if (elementName.equals("url-stream-handler")) {
            this.processUrlStreamHandler(elt, appEngineWebXml);
        } else if (elementName.equals("use-google-connector-j")) {
            this.processUseGoogleConnectorJNode(elt, appEngineWebXml);
        } else {
            throw new AppEngineConfigException("Unrecognized element <" + elementName + ">");
        }
    }

    private void processApplicationNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAppId(this.getTextNode(node));
    }

    private void processPublicRootNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPublicRoot(this.getTextNode(node));
    }

    private void processVersionNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setMajorVersionId(this.getTextNode(node));
    }

    private void processSourceLanguageNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSourceLanguage(this.getTextNode(node));
    }

    private void processModuleNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setModule(this.getTextNode(node));
    }

    private void processInstanceClassNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setInstanceClass(this.getTextNode(node));
    }

    private String getChildNodeText(Element parentNode, String childTag) {
        String result = null;
        Element node = XmlUtils.getChildElement(parentNode, childTag);
        if (node != null) {
            result = XmlUtils.getBody(node);
        }
        return result;
    }

    private Integer getChildNodePositiveInteger(Element parentNode, String childTag) {
        String trimmedText;
        Integer result = null;
        Element node = XmlUtils.getChildElement(parentNode, childTag);
        if (node != null && XmlUtils.getBody(node) != null && !(trimmedText = XmlUtils.getBody(node).trim()).isEmpty()) {
            try {
                result = Integer.parseInt(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(childTag + " should only contain integers.");
            }
            if (result <= 0) {
                throw new AppEngineConfigException(childTag + " should only contain positive integers.");
            }
        }
        return result;
    }

    private Double getChildNodeDouble(Element parentNode, String childTag) {
        String trimmedText;
        Double result = null;
        Element node = XmlUtils.getChildElement(parentNode, childTag);
        if (node != null && XmlUtils.getBody(node) != null && !(trimmedText = XmlUtils.getBody(node).trim()).isEmpty()) {
            try {
                result = Double.parseDouble(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(childTag + " should only contain doubles.");
            }
            catch (NullPointerException ex) {
                throw new AppEngineConfigException(childTag + " should NOT be empty.");
            }
        }
        return result;
    }

    private void processAutomaticScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.AutomaticScaling automaticScaling = appEngineWebXml.getAutomaticScaling();
        automaticScaling.setMinPendingLatency(this.getChildNodeText(settingsNode, "min-pending-latency"));
        automaticScaling.setMaxPendingLatency(this.getChildNodeText(settingsNode, "max-pending-latency"));
        automaticScaling.setMinIdleInstances(this.getChildNodeText(settingsNode, "min-idle-instances"));
        automaticScaling.setMaxIdleInstances(this.getChildNodeText(settingsNode, "max-idle-instances"));
        automaticScaling.setMaxConcurrentRequests(this.getChildNodeText(settingsNode, "max-concurrent-requests"));
        automaticScaling.setMinNumInstances(this.getChildNodePositiveInteger(settingsNode, "min-num-instances"));
        automaticScaling.setMaxNumInstances(this.getChildNodePositiveInteger(settingsNode, "max-num-instances"));
        automaticScaling.setCoolDownPeriodSec(this.getChildNodePositiveInteger(settingsNode, "cool-down-period-sec"));
        this.processCpuUtilizationNode(settingsNode, automaticScaling);
        automaticScaling.setTargetNetworkSentBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-bytes-per-sec"));
        automaticScaling.setTargetNetworkSentPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-packets-per-sec"));
        automaticScaling.setTargetNetworkReceivedBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-bytes-per-sec"));
        automaticScaling.setTargetNetworkReceivedPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-packets-per-sec"));
        automaticScaling.setTargetDiskWriteBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-bytes-per-sec"));
        automaticScaling.setTargetDiskWriteOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-ops-per-sec"));
        automaticScaling.setTargetDiskReadBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-bytes-per-sec"));
        automaticScaling.setTargetDiskReadOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-ops-per-sec"));
        automaticScaling.setTargetRequestCountPerSec(this.getChildNodePositiveInteger(settingsNode, "target-request-count-per-sec"));
        automaticScaling.setTargetConcurrentRequests(this.getChildNodePositiveInteger(settingsNode, "target-concurrent-requests"));
    }

    private void processCpuUtilizationNode(Element settingsNode, AppEngineWebXml.AutomaticScaling automaticScaling) {
        Element childNode = XmlUtils.getChildElement(settingsNode, "cpu-utilization");
        if (childNode != null) {
            AppEngineWebXml.CpuUtilization cpuUtilization = new AppEngineWebXml.CpuUtilization();
            Double targetUtilization = this.getChildNodeDouble(childNode, "target-utilization");
            if (targetUtilization != null) {
                if (targetUtilization <= 0.0 || targetUtilization > 1.0) {
                    throw new AppEngineConfigException("target-utilization should be in range (0, 1].");
                }
                cpuUtilization.setTargetUtilization(targetUtilization);
            }
            cpuUtilization.setAggregationWindowLengthSec(this.getChildNodePositiveInteger(childNode, "aggregation-window-length-sec"));
            if (!cpuUtilization.isEmpty()) {
                automaticScaling.setCpuUtilization(cpuUtilization);
            }
        }
    }

    private void processManualScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ManualScaling manualScaling = appEngineWebXml.getManualScaling();
        manualScaling.setInstances(this.getChildNodeText(settingsNode, "instances"));
    }

    private void processBasicScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.BasicScaling basicScaling = appEngineWebXml.getBasicScaling();
        basicScaling.setMaxInstances(this.getChildNodeText(settingsNode, "max-instances"));
        basicScaling.setIdleTimeout(this.getChildNodeText(settingsNode, "idle-timeout"));
    }

    private void processSslEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSslEnabled(this.getBooleanValue(node));
    }

    private void processSessionsEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSessionsEnabled(this.getBooleanValue(node));
    }

    private void processAsyncSessionPersistenceNode(Element node, AppEngineWebXml appEngineWebXml) {
        boolean enabled = this.getBooleanAttributeValue(node, "enabled");
        appEngineWebXml.setAsyncSessionPersistence(enabled);
        String queueName = this.trim(node.getAttribute("queue-name"));
        if (queueName.equals("")) {
            queueName = null;
        }
        appEngineWebXml.setAsyncSessionPersistenceQueueName(queueName);
    }

    private void processPrecompilationEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPrecompilationEnabled(this.getBooleanValue(node));
    }

    private void processWarmupRequestsEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setWarmupRequestsEnabled(this.getBooleanValue(node));
    }

    private void processThreadsafeNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setThreadsafe(this.getBooleanValue(node));
    }

    private void processAutoIdPolicyNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAutoIdPolicy(this.getTextNode(node));
    }

    private void processCodeLockNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setCodeLock(this.getBooleanValue(node));
    }

    private void processVmNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseVm(this.getBooleanValue(node));
    }

    private void processEnvNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setEnv(this.getTextNode(node));
    }

    private void processFilesetNode(Element node, AppEngineWebXml appEngineWebXml, FileType type) {
        String path;
        Iterator<Element> nodeIter = this.getNodeIterator(node, "include");
        while (nodeIter.hasNext()) {
            Element includeNode = nodeIter.next();
            path = this.trim(includeNode.getAttribute("path"));
            if (path.equals("")) {
                path = null;
            }
            if (type == FileType.STATIC) {
                String expiration = this.trim(includeNode.getAttribute("expiration"));
                if (expiration.equals("")) {
                    expiration = null;
                }
                AppEngineWebXml.StaticFileInclude staticFileInclude = appEngineWebXml.includeStaticPattern(path, expiration);
                Map<String, String> httpHeaders = staticFileInclude.getHttpHeaders();
                Iterator<Element> httpHeaderIter = this.getNodeIterator(includeNode, "http-header");
                while (httpHeaderIter.hasNext()) {
                    Element httpHeaderNode = httpHeaderIter.next();
                    String name = httpHeaderNode.getAttribute("name");
                    String value = httpHeaderNode.getAttribute("value");
                    if (httpHeaders.containsKey(name)) {
                        throw new AppEngineConfigException("Two http-header elements have the same name.");
                    }
                    httpHeaders.put(name, value);
                }
                continue;
            }
            appEngineWebXml.includeResourcePattern(path);
        }
        nodeIter = this.getNodeIterator(node, "exclude");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            path = this.trim(subNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                appEngineWebXml.excludeStaticPattern(path);
                continue;
            }
            appEngineWebXml.excludeResourcePattern(path);
        }
    }

    private Iterator<Element> getNodeIterator(Element node, String filter) {
        return XmlUtils.getChildren(node, filter).iterator();
    }

    private void processSystemPropertiesNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "property");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            if ("java.util.logging.config.file".equals(propertyName) && System.getProperty("java.util.logging.config.file") != null) {
                propertyValue = System.getProperty("java.util.logging.config.file");
            }
            appEngineWebXml.addSystemProperty(propertyName, propertyValue);
        }
    }

    private void processBetaSettingsNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "setting");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String name = this.trim(subNode.getAttribute("name"));
            String value = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addBetaSetting(name, value);
        }
    }

    private void processHealthCheckNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.HealthCheck healthCheck = appEngineWebXml.getHealthCheck();
        String enableHealthCheck = this.trim(this.getChildNodeText(settingsNode, "enable-health-check"));
        if (enableHealthCheck != null && !enableHealthCheck.isEmpty()) {
            healthCheck.setEnableHealthCheck(this.toBoolean(enableHealthCheck));
        }
        healthCheck.setCheckIntervalSec(this.getChildNodePositiveInteger(settingsNode, "check-interval-sec"));
        healthCheck.setTimeoutSec(this.getChildNodePositiveInteger(settingsNode, "timeout-sec"));
        healthCheck.setUnhealthyThreshold(this.getChildNodePositiveInteger(settingsNode, "unhealthy-threshold"));
        healthCheck.setHealthyThreshold(this.getChildNodePositiveInteger(settingsNode, "healthy-threshold"));
        healthCheck.setRestartThreshold(this.getChildNodePositiveInteger(settingsNode, "restart-threshold"));
        healthCheck.setHost(this.getChildNodeText(settingsNode, "host"));
    }

    private void processResourcesNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        Integer disk_size_gb;
        Double memory_gb;
        AppEngineWebXml.Resources resources = appEngineWebXml.getResources();
        Double cpu = this.getChildNodeDouble(settingsNode, "cpu");
        if (cpu != null) {
            resources.setCpu(cpu);
        }
        if ((memory_gb = this.getChildNodeDouble(settingsNode, "memory-gb")) != null) {
            resources.setMemoryGb(memory_gb);
        }
        if ((disk_size_gb = this.getChildNodePositiveInteger(settingsNode, "disk-size-gb")) != null) {
            resources.setDiskSizeGb(disk_size_gb);
        }
    }

    private void processNetworkNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.Network network = appEngineWebXml.getNetwork();
        String instance_tag = this.trim(this.getChildNodeText(settingsNode, "instance-tag"));
        if (instance_tag != null && !instance_tag.isEmpty()) {
            network.setInstanceTag(instance_tag);
        }
        Iterator<Element> nodeIter = this.getNodeIterator(settingsNode, "forwarded-port");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String forwardedPort = this.getTextNode(subNode);
            network.addForwardedPort(forwardedPort);
        }
        String name = this.trim(this.getChildNodeText(settingsNode, "name"));
        if (name != null && !name.isEmpty()) {
            network.setName(name);
        }
    }

    private void processEnvironmentVariablesNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "env-var");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addEnvironmentVariable(propertyName, propertyValue);
        }
    }

    private void processPermissionsNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "permission");
        while (nodeIter.hasNext()) {
            String actions;
            String name;
            Element subNode = nodeIter.next();
            String className = this.trim(subNode.getAttribute("class"));
            if (className.equals("")) {
                className = null;
            }
            if ((name = this.trim(subNode.getAttribute("name"))).equals("")) {
                name = null;
            }
            if ((actions = this.trim(subNode.getAttribute("actions"))).equals("")) {
                actions = null;
            }
            appEngineWebXml.addUserPermission(className, name, actions);
        }
    }

    private void processInboundServicesNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "service");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String service = this.getTextNode(subNode);
            appEngineWebXml.addInboundService(service);
        }
    }

    private void processAdminConsoleNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "page");
        while (nodeIter.hasNext()) {
            Element subNode = nodeIter.next();
            String name = this.trim(subNode.getAttribute("name"));
            String url = this.trim(subNode.getAttribute("url"));
            appEngineWebXml.addAdminConsolePage(new AppEngineWebXml.AdminConsolePage(name, url));
        }
    }

    private void processErrorHandlerNode(Element node, AppEngineWebXml appEngineWebXml) {
        Iterator<Element> nodeIter = this.getNodeIterator(node, "handler");
        while (nodeIter.hasNext()) {
            String errorCode;
            Element subNode = nodeIter.next();
            String file = this.trim(subNode.getAttribute("file"));
            if (file.equals("")) {
                file = null;
            }
            if ((errorCode = this.trim(subNode.getAttribute("error-code"))).equals("")) {
                errorCode = null;
            }
            appEngineWebXml.addErrorHandler(new AppEngineWebXml.ErrorHandler(file, errorCode));
        }
    }

    private void processApiConfigNode(Element node, AppEngineWebXml appEngineWebXml) {
        String servlet = this.trim(node.getAttribute("servlet-class"));
        String url = this.trim(node.getAttribute("url-pattern"));
        appEngineWebXml.setApiConfig(new AppEngineWebXml.ApiConfig(servlet, url));
        Iterator<Element> subNodeIter = this.getNodeIterator(node, "endpoint-servlet-mapping-id");
        while (subNodeIter.hasNext()) {
            Element subNode = subNodeIter.next();
            String id = this.trim(this.getTextNode(subNode));
            if (id == null || id.length() <= 0) continue;
            appEngineWebXml.addApiEndpoint(id);
        }
    }

    private void processPagespeedNode(Element node, AppEngineWebXml appEngineWebXml) {
        String rewriter;
        Element subNode;
        AppEngineWebXml.Pagespeed pagespeed = new AppEngineWebXml.Pagespeed();
        Iterator<Element> nodeIter = this.getNodeIterator(node, "url-blacklist");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            String urlMatcher = this.getTextNode(subNode);
            pagespeed.addUrlBlacklist(urlMatcher);
        }
        nodeIter = this.getNodeIterator(node, "domain-to-rewrite");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            String domain = this.getTextNode(subNode);
            pagespeed.addDomainToRewrite(domain);
        }
        nodeIter = this.getNodeIterator(node, "enabled-rewriter");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            rewriter = this.getTextNode(subNode);
            pagespeed.addEnabledRewriter(rewriter);
        }
        nodeIter = this.getNodeIterator(node, "disabled-rewriter");
        while (nodeIter.hasNext()) {
            subNode = nodeIter.next();
            rewriter = this.getTextNode(subNode);
            pagespeed.addDisabledRewriter(rewriter);
        }
        appEngineWebXml.setPagespeed(pagespeed);
    }

    private void processClassLoaderConfig(Element node, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ClassLoaderConfig config = new AppEngineWebXml.ClassLoaderConfig();
        appEngineWebXml.setClassLoaderConfig(config);
        Iterator<Element> nodeIter = this.getNodeIterator(node, "priority-specifier");
        while (nodeIter.hasNext()) {
            this.processClassPathPrioritySpecifier(nodeIter.next(), config);
        }
    }

    private void processClassPathPrioritySpecifier(Element node, AppEngineWebXml.ClassLoaderConfig config) {
        AppEngineWebXml.PrioritySpecifierEntry entry = new AppEngineWebXml.PrioritySpecifierEntry();
        entry.setFilename(XmlUtils.getAttribute(node, "filename"));
        entry.setPriority(XmlUtils.getAttribute(node, "priority"));
        entry.checkClassLoaderConfig();
        config.add(entry);
    }

    private void processUrlStreamHandler(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUrlStreamHandlerType(this.getTextNode(node));
    }

    private boolean getBooleanValue(Element node) {
        return this.toBoolean(this.getTextNode(node));
    }

    private boolean getBooleanAttributeValue(Element node, String attribute) {
        return this.toBoolean(node.getAttribute(attribute));
    }

    private boolean toBoolean(String value) {
        return (value = value.trim()).equalsIgnoreCase("true") || value.equals("1");
    }

    private String getTextNode(Element node) {
        String value = XmlUtils.getBody(node);
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }

    private void processUseGoogleConnectorJNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseGoogleConnectorJ(this.getBooleanValue(node));
    }

    static enum FileType {
        STATIC,
        RESOURCE;

    }
}

