/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    static String getText(Element node) throws AppEngineConfigException {
        String content = node.getTextContent();
        if (content == null) {
            return "";
        }
        return content.trim();
    }

    public static Document parseXml(InputStream inputStream) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream.";
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            throw new AppEngineConfigException(msg, e);
        }
        catch (ParserConfigurationException e) {
            String msg = "Received ParserConfigurationException parsing the input stream.";
            throw new AppEngineConfigException(msg, e);
        }
    }

    public static void validateXml(String xmlFilename, File schema) {
        File xml = new File(xmlFilename);
        if (!xml.exists()) {
            throw new AppEngineConfigException("Xml file: " + xml.getPath() + " does not exist.");
        }
        if (!schema.exists()) {
            throw new AppEngineConfigException("Schema file: " + schema.getPath() + " does not exist.");
        }
        try {
            XmlUtils.validateXmlContent(Files.toString((File)xml, (Charset)Charsets.UTF_8), schema);
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("IO error validating " + xmlFilename + " against " + schema.getPath(), ex);
        }
    }

    public static void validateXmlContent(String content, File schema) {
        if (!schema.exists()) {
            throw new AppEngineConfigException("Schema file: " + schema.getPath() + " does not exist.");
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory.newSchema(schema).newValidator().validate(new StreamSource(new ByteArrayInputStream(content.getBytes(Charsets.UTF_8))));
            }
            catch (SAXException ex) {
                throw new AppEngineConfigException("XML error validating " + content + " against " + schema.getPath(), ex);
            }
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("IO error validating " + content + " against " + schema.getPath(), ex);
        }
    }

    public static String getChildElementBody(Element element, String tagName) {
        return XmlUtils.getChildElementBody(element, tagName, true);
    }

    public static String getChildElementBody(Element element, String tagName, boolean required) {
        Element elt = XmlUtils.getChildElement(element, tagName, required);
        return elt != null ? XmlUtils.getBody(elt) : null;
    }

    public static Element getChildElement(Element parent, String tagName) {
        return XmlUtils.getChildElement(parent, tagName, false);
    }

    public static Element getChildElement(Element parent, String tagName, boolean required) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes == null || nodes.getLength() == 0) {
            if (required) {
                throw new IllegalStateException(String.format("Missing tag %s in element %s.", tagName, parent));
            }
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static String getAttribute(Element element, String name) {
        return element.getAttribute(name);
    }

    public static String getBody(Element element) {
        NodeList nodes = element.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        Node firstNode = nodes.item(0);
        if (firstNode == null) {
            return null;
        }
        return firstNode.getNodeValue();
    }

    public static List<Element> getChildren(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            elements.add((Element)nodes.item(i));
        }
        return elements;
    }
}

