/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.LifecycleManager;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VmHealthServlet
extends HttpServlet {
    private String fullVersionId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        String actualVersionId = environment.getVersionId();
        if (environment.getModuleId() != null && !environment.getModuleId().isEmpty() && !environment.getModuleId().equals("default")) {
            actualVersionId = environment.getModuleId() + ":" + actualVersionId;
        }
        return actualVersionId;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LifecycleManager lifeCycleManager = LifecycleManager.getInstance();
        if (LifecycleManager.getInstance().isShuttingDown()) {
            long remainingShutdownTime = lifeCycleManager.getRemainingShutdownTime();
            response.sendError(502, "App is shutting down, time remaining: " + remainingShutdownTime + " ms");
            return;
        }
        String expectedVersion = request.getParameter("VersionID");
        String actualVersion = this.fullVersionId();
        if (expectedVersion == null || expectedVersion.equals(actualVersion)) {
            response.setContentType("text/plain");
            response.getWriter().write("ok");
        } else {
            response.setContentType("text/plain");
            response.getWriter().write(String.format("version mismatch \"%s\" != \"%s\"", expectedVersion, actualVersion));
        }
    }
}

