/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.utils.http.HttpRequest;
import com.google.apphosting.vmruntime.VmMetadataCache;
import com.google.apphosting.vmruntime.VmRequestThreadFactory;
import com.google.apphosting.vmruntime.VmRuntimeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class VmApiProxyEnvironment
implements ApiProxy.Environment {
    public static final String PROJECT_ATTRIBUTE = "attributes/gae_project";
    static final String LONG_APP_ID_KEY = "GAE_LONG_APP_ID";
    public static final String PARTITION_ATTRIBUTE = "attributes/gae_partition";
    static final String PARTITION_KEY = "GAE_PARTITION";
    static final String GAE_SERVER_PORT = "GAE_SERVER_PORT";
    public static final String BACKEND_ATTRIBUTE = "attributes/gae_backend_name";
    static final String MODULE_NAME_KEY = "GAE_MODULE_NAME";
    public static final String VERSION_ATTRIBUTE = "attributes/gae_backend_version";
    static final String VERSION_KEY = "GAE_MODULE_VERSION";
    public static final String INSTANCE_ATTRIBUTE = "attributes/gae_backend_instance";
    static final String INSTANCE_KEY = "GAE_MODULE_INSTANCE";
    static final String MINOR_VERSION_KEY = "GAE_MINOR_VERSION";
    public static final String APPENGINE_HOSTNAME_ATTRIBUTE = "attributes/gae_appengine_hostname";
    static final String APPENGINE_HOSTNAME_KEY = "GAE_APPENGINE_HOSTNAME";
    public static final String USE_MVM_AGENT_ATTRIBUTE = "attributes/gae_use_nginx_proxy";
    static final String USE_MVM_AGENT_KEY = "USE_MVM_AGENT";
    public static final String AFFINITY_ATTRIBUTE = "attributes/gae_affinity";
    static final String AFFINITY_ENV_KEY = "GAE_AFFINITY";
    public static final String TICKET_HEADER = "X-AppEngine-Api-Ticket";
    public static final String EMAIL_HEADER = "X-AppEngine-User-Email";
    public static final String IS_ADMIN_HEADER = "X-AppEngine-User-Is-Admin";
    public static final String AUTH_DOMAIN_HEADER = "X-AppEngine-Auth-Domain";
    public static final String HTTPS_HEADER = "X-AppEngine-Https";
    static final String BACKEND_ID_KEY = "com.google.appengine.backend.id";
    static final String INSTANCE_ID_KEY = "com.google.appengine.instance.id";
    static final String AFFINITY_KEY = "com.google.appengine.affinity";
    static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";
    static final String IS_FEDERATED_USER_KEY = "com.google.appengine.api.users.UserService.is_federated_user";
    static final String IS_TRUSTED_IP_KEY = "com.google.appengine.runtime.is_trusted_ip";
    static final String IS_TRUSTED_IP_HEADER = "X-AppEngine-Trusted-IP-Request";
    public static final String REAL_IP_HEADER = "X-Google-Real-IP";
    private static final long DEFAULT_FLUSH_APP_LOGS_EVERY_BYTE_COUNT = 0x100000L;
    private static final int MAX_LOG_FLUSH_SECONDS = 60;
    private static final int DEFAULT_MAX_LOG_LINE_SIZE = 8192;
    static final int MAX_CONCURRENT_API_CALLS = 100;
    static final int MAX_PENDING_API_CALLS = 1000;
    private final String server;
    private final String ticket;
    private final int serverPort;
    private final String partition;
    private final String appId;
    private final String module;
    private final String majorVersion;
    private final String minorVersion;
    private final String versionId;
    private final String appengineHostname;
    private final String l7UnsafeRedirectUrl;
    private final String email;
    private final boolean admin;
    private final String authDomain;
    private final boolean useMvmAgent;
    private final Map<String, Object> attributes;
    private ThreadLocal<Map<String, Object>> threadLocalAttributes;
    private final Timer wallTimer;
    private final Long millisUntilSoftDeadline;
    final Semaphore pendingApiCallSemaphore;
    final Semaphore runningApiCallSemaphore;

    private static String getEnvOrMetadata(Map<String, String> environmentMap, VmMetadataCache cache, String envKey, String metadataPath) {
        String envValue = environmentMap.get(envKey);
        return envValue != null ? envValue : cache.getMetadata(metadataPath);
    }

    public static VmApiProxyEnvironment createDefaultContext(Map<String, String> envMap, VmMetadataCache cache, String server, Timer wallTimer, Long millisUntilSoftDeadline, String appDir) {
        String longAppId = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, LONG_APP_ID_KEY, PROJECT_ATTRIBUTE);
        String partition = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, PARTITION_KEY, PARTITION_ATTRIBUTE);
        String module = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, MODULE_NAME_KEY, BACKEND_ATTRIBUTE);
        String majorVersion = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, VERSION_KEY, VERSION_ATTRIBUTE);
        String minorVersion = envMap.get(MINOR_VERSION_KEY);
        if (minorVersion == null) {
            minorVersion = VmRuntimeUtils.getMinorVersionFromPath(majorVersion, appDir);
        }
        String instance = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, INSTANCE_KEY, INSTANCE_ATTRIBUTE);
        String affinity = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, AFFINITY_ENV_KEY, AFFINITY_ATTRIBUTE);
        String appengineHostname = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, APPENGINE_HOSTNAME_KEY, APPENGINE_HOSTNAME_ATTRIBUTE);
        String email = null;
        boolean admin = false;
        String authDomain = null;
        boolean useMvmAgent = Boolean.parseBoolean(VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, USE_MVM_AGENT_KEY, USE_MVM_AGENT_ATTRIBUTE));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (AttributeMapping mapping : AttributeMapping.values()) {
            if (mapping.trustedAppOnly || mapping.defaultValue == null) continue;
            attributes.put(mapping.attributeKey, mapping.defaultValue);
        }
        attributes.put(IS_FEDERATED_USER_KEY, Boolean.FALSE);
        attributes.put(BACKEND_ID_KEY, module);
        attributes.put(INSTANCE_ID_KEY, instance);
        attributes.put(AFFINITY_KEY, affinity);
        VmApiProxyEnvironment defaultEnvironment = new VmApiProxyEnvironment(server, longAppId, partition, module, majorVersion, minorVersion, instance, appengineHostname, email, false, authDomain, useMvmAgent, wallTimer, millisUntilSoftDeadline, attributes);
        attributes.put(REQUEST_THREAD_FACTORY_ATTR, new VmRequestThreadFactory(null));
        attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, Executors.defaultThreadFactory());
        return defaultEnvironment;
    }

    public static VmApiProxyEnvironment createFromHeaders(Map<String, String> envMap, VmMetadataCache cache, HttpRequest request, String server, Timer wallTimer, Long millisUntilSoftDeadline, VmApiProxyEnvironment defaultEnvironment) {
        String longAppId = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, LONG_APP_ID_KEY, PROJECT_ATTRIBUTE);
        String partition = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, PARTITION_KEY, PARTITION_ATTRIBUTE);
        String module = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, MODULE_NAME_KEY, BACKEND_ATTRIBUTE);
        String majorVersion = defaultEnvironment.getMajorVersion();
        String minorVersion = defaultEnvironment.getMinorVersion();
        String appengineHostname = defaultEnvironment.getAppengineHostname();
        boolean useMvmAgent = defaultEnvironment.getUseMvmAgent();
        String instance = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, INSTANCE_KEY, INSTANCE_ATTRIBUTE);
        String affinity = VmApiProxyEnvironment.getEnvOrMetadata(envMap, cache, AFFINITY_ENV_KEY, AFFINITY_ATTRIBUTE);
        String email = request.getHeader(EMAIL_HEADER);
        boolean admin = false;
        String value = request.getHeader(IS_ADMIN_HEADER);
        if (value != null && !value.trim().isEmpty()) {
            try {
                admin = Integer.parseInt(value.trim()) != 0;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        String authDomain = request.getHeader(AUTH_DOMAIN_HEADER);
        boolean trustedApp = request.getHeader(IS_TRUSTED_IP_HEADER) != null;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (AttributeMapping mapping : AttributeMapping.values()) {
            if (mapping.trustedAppOnly && !trustedApp) continue;
            String headerValue = request.getHeader(mapping.headerKey);
            if (headerValue != null) {
                attributes.put(mapping.attributeKey, headerValue);
                continue;
            }
            if (mapping.defaultValue == null) continue;
            attributes.put(mapping.attributeKey, mapping.defaultValue);
        }
        boolean federatedId = request.getHeader(AttributeMapping.FEDERATED_IDENTITY.headerKey) != null;
        attributes.put(IS_FEDERATED_USER_KEY, federatedId);
        attributes.put(BACKEND_ID_KEY, module);
        attributes.put(INSTANCE_ID_KEY, instance);
        attributes.put(AFFINITY_KEY, affinity);
        if (trustedApp) {
            boolean trustedIp = "1".equals(request.getHeader(IS_TRUSTED_IP_HEADER));
            attributes.put(IS_TRUSTED_IP_KEY, trustedIp);
        }
        VmApiProxyEnvironment requestEnvironment = new VmApiProxyEnvironment(server, longAppId, partition, module, majorVersion, minorVersion, instance, appengineHostname, email, admin, authDomain, useMvmAgent, wallTimer, millisUntilSoftDeadline, attributes);
        attributes.put(REQUEST_THREAD_FACTORY_ATTR, new VmRequestThreadFactory(requestEnvironment));
        attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, Executors.defaultThreadFactory());
        return requestEnvironment;
    }

    private VmApiProxyEnvironment(String server, String appId, String partition, String module, String majorVersion, String minorVersion, String instance, String appengineHostname, String email, boolean admin, String authDomain, boolean useMvmAgent, Timer wallTimer, Long millisUntilSoftDeadline, Map<String, Object> attributes) {
        if (server == null || server.isEmpty()) {
            throw new IllegalArgumentException("proxy server host:port must be specified");
        }
        if (millisUntilSoftDeadline != null && wallTimer == null) {
            throw new IllegalArgumentException("wallTimer required when setting millisUntilSoftDeadline");
        }
        if (appId == null || appId.isEmpty() || module == null || module.isEmpty() || majorVersion == null || majorVersion.isEmpty() || instance == null || instance.isEmpty()) {
            throw new IllegalArgumentException("When ticket == null, the following must be specified: appId=" + appId + ", module=" + module + ", version=" + majorVersion + ", instance=" + instance);
        }
        String escapedAppId = appId.replace(':', '_').replace('.', '_');
        this.ticket = escapedAppId + '/' + module + '.' + majorVersion + "." + instance;
        this.server = server;
        this.partition = partition;
        String port = System.getenv(GAE_SERVER_PORT) == null ? System.getProperty(GAE_SERVER_PORT, "80") : System.getenv(GAE_SERVER_PORT);
        this.serverPort = Integer.decode(port);
        this.appId = appId == null ? "" : partition + "~" + appId;
        this.module = module == null ? "default" : module;
        this.majorVersion = majorVersion == null ? "" : majorVersion;
        this.minorVersion = minorVersion == null ? "" : minorVersion;
        this.versionId = String.format("%s.%s", this.majorVersion, this.minorVersion);
        this.appengineHostname = appengineHostname;
        this.l7UnsafeRedirectUrl = String.format("https://%s-dot-%s-dot-%s", this.majorVersion, this.module, this.appengineHostname);
        this.email = email == null ? "" : email;
        this.admin = admin;
        this.authDomain = authDomain == null ? "" : authDomain;
        this.useMvmAgent = useMvmAgent;
        this.wallTimer = wallTimer;
        this.millisUntilSoftDeadline = millisUntilSoftDeadline;
        this.attributes = Collections.synchronizedMap(attributes);
        this.pendingApiCallSemaphore = new Semaphore(1000);
        this.runningApiCallSemaphore = new Semaphore(100);
    }

    @Deprecated
    public void addLogRecord(ApiProxy.LogRecord record) {
    }

    @Deprecated
    public int flushLogs() {
        return -1;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getAppengineHostname() {
        return this.appengineHostname;
    }

    public String getL7UnsafeRedirectUrl() {
        return this.l7UnsafeRedirectUrl;
    }

    public String getServer() {
        return this.server;
    }

    public String getTicket() {
        return this.ticket;
    }

    public String getPartition() {
        return this.partition;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getModuleId() {
        return this.module;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isLoggedIn() {
        return this.getEmail() != null && !this.getEmail().trim().isEmpty();
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public boolean getUseMvmAgent() {
        return this.useMvmAgent;
    }

    @Deprecated
    public String getRequestNamespace() {
        Object currentNamespace = this.attributes.get(AttributeMapping.CURRENT_NAMESPACE_HEADER.attributeKey);
        if (currentNamespace instanceof String) {
            return (String)currentNamespace;
        }
        return "";
    }

    public synchronized void setThreadLocalAttributes() {
        if (this.threadLocalAttributes == null) {
            this.threadLocalAttributes = new ThreadLocal();
        }
        this.threadLocalAttributes.set(new HashMap<String, Object>(this.attributes));
    }

    public Map<String, Object> getAttributes() {
        if (this.threadLocalAttributes != null && this.threadLocalAttributes.get() != null) {
            return this.threadLocalAttributes.get();
        }
        return this.attributes;
    }

    public long getRemainingMillis() {
        if (this.millisUntilSoftDeadline == null) {
            return Long.MAX_VALUE;
        }
        return this.millisUntilSoftDeadline - this.wallTimer.getNanoseconds() / 1000000L;
    }

    void aSyncApiCallAdded(long maxWaitMs) throws ApiProxy.ApiProxyException {
        try {
            if (this.pendingApiCallSemaphore.tryAcquire(maxWaitMs, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw new ApiProxy.ApiProxyException("Timed out while acquiring a pending API call semaphore.");
        }
        catch (InterruptedException e) {
            throw new ApiProxy.ApiProxyException("Thread interrupted while acquiring a pending API call semaphore.");
        }
    }

    void apiCallStarted(long maxWaitMs, boolean releasePendingCall) throws ApiProxy.ApiProxyException {
        try {
            if (this.runningApiCallSemaphore.tryAcquire(maxWaitMs, TimeUnit.MILLISECONDS)) {
                return;
            }
            try {
                throw new ApiProxy.ApiProxyException("Timed out while acquiring an API call semaphore.");
            }
            catch (InterruptedException e) {
                throw new ApiProxy.ApiProxyException("Thread interrupted while acquiring an API call semaphore.");
            }
        }
        finally {
            if (releasePendingCall) {
                this.pendingApiCallSemaphore.release();
            }
        }
    }

    void apiCallCompleted() {
        this.runningApiCallSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForAllApiCallsToComplete(long maxWaitMs) {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.pendingApiCallSemaphore.tryAcquire(1000, maxWaitMs, TimeUnit.MILLISECONDS)) return false;
            try {
                long remaining = maxWaitMs - (System.currentTimeMillis() - startTime);
                if (!this.runningApiCallSemaphore.tryAcquire(100, remaining, TimeUnit.MILLISECONDS)) return false;
                this.runningApiCallSemaphore.release(100);
                boolean bl = true;
                return bl;
            }
            finally {
                this.pendingApiCallSemaphore.release(1000);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    static enum AttributeMapping {
        USER_ID("X-AppEngine-User-Id", "com.google.appengine.api.users.UserService.user_id_key", "", false),
        USER_ORGANIZATION("X-AppEngine-User-Organization", "com.google.appengine.api.users.UserService.user_organization", "", false),
        FEDERATED_IDENTITY("X-AppEngine-Federated-Identity", "com.google.appengine.api.users.UserService.federated_identity", "", false),
        FEDERATED_PROVIDER("X-AppEngine-Federated-Provider", "com.google.appengine.api.users.UserService.federated_authority", "", false),
        DATACENTER("X-AppEngine-Datacenter", "com.google.apphosting.api.ApiProxy.datacenter", "", false),
        REQUEST_ID_HASH("X-AppEngine-Request-Id-Hash", "com.google.apphosting.api.ApiProxy.request_id_hash", null, false),
        REQUEST_LOG_ID("X-AppEngine-Request-Log-Id", "com.google.appengine.runtime.request_log_id", null, false),
        DAPPER_ID("X-Google-DapperTraceInfo", "com.google.appengine.runtime.dapper_id", null, false),
        CLOUD_TRACE_CONTEXT("X-Cloud-Trace-Context", "com.google.appengine.runtime.cloud_trace_context", null, false),
        DEFAULT_VERSION_HOSTNAME("X-AppEngine-Default-Version-Hostname", "com.google.appengine.runtime.default_version_hostname", null, false),
        DEFAULT_NAMESPACE_HEADER("X-AppEngine-Default-Namespace", "com.google.appengine.api.NamespaceManager.appsNamespace", null, false),
        CURRENT_NAMESPACE_HEADER("X-AppEngine-Current-Namespace", "com.google.appengine.api.NamespaceManager.currentNamespace", null, false),
        LOAS_PEER_USERNAME("X-AppEngine-LOAS-Peer-Username", "com.google.net.base.peer.loas_peer_username", "", true),
        GAIA_ID("X-AppEngine-Gaia-Id", "com.google.appengine.runtime.gaia_id", "", true),
        GAIA_AUTHUSER("X-AppEngine-Gaia-Authuser", "com.google.appengine.runtime.gaia_authuser", "", true),
        GAIA_SESSION("X-AppEngine-Gaia-Session", "com.google.appengine.runtime.gaia_session", "", true),
        APPSERVER_DATACENTER("X-AppEngine-Appserver-Datacenter", "com.google.appengine.runtime.appserver_datacenter", "", true),
        APPSERVER_TASK_BNS("X-AppEngine-Appserver-Task-Bns", "com.google.appengine.runtime.appserver_task_bns", "", true);

        String headerKey;
        String attributeKey;
        Object defaultValue;
        private final boolean trustedAppOnly;

        private AttributeMapping(String headerKey, String attributeKey, Object defaultValue, boolean trustedAppOnly) {
            this.headerKey = headerKey;
            this.attributeKey = attributeKey;
            this.defaultValue = defaultValue;
            this.trustedAppOnly = trustedAppOnly;
        }
    }
}

