/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VmRequestThreadFactory
implements ThreadFactory {
    private static final Logger logger = Logger.getLogger(VmRequestThreadFactory.class.getCanonicalName());
    private final ApiProxy.Environment requestEnvironment;
    private final Object mutex = new Object();
    private final List<Thread> createdThreads;
    private volatile boolean allowNewRequestThreadCreation;

    public VmRequestThreadFactory(ApiProxy.Environment requestEnvironment) {
        this.requestEnvironment = requestEnvironment;
        this.createdThreads = Lists.newLinkedList();
        this.allowNewRequestThreadCreation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(final Runnable runnable) {
        Preconditions.checkState((this.requestEnvironment != null ? 1 : 0) != 0, (Object)"Request threads can only be created within the context of a running request.");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (runnable == null) {
                    return;
                }
                Preconditions.checkState((boolean)VmRequestThreadFactory.this.allowNewRequestThreadCreation, (Object)"Cannot start new threads after the request thread stops.");
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)VmRequestThreadFactory.this.requestEnvironment);
                runnable.run();
            }
        });
        Preconditions.checkState((boolean)this.allowNewRequestThreadCreation, (Object)"Cannot create new threads after the request thread stops.");
        Object object = this.mutex;
        synchronized (object) {
            this.createdThreads.add(thread);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getRequestThreads() {
        Object object = this.mutex;
        synchronized (object) {
            return ImmutableList.copyOf(this.createdThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRequestThreads() {
        this.allowNewRequestThreadCreation = false;
        Object object = this.mutex;
        synchronized (object) {
            for (Thread thread : this.createdThreads) {
                if (thread.isAlive()) {
                    logger.warning(String.format("Request thread %s is still alive, forcing interrupt.", thread.getName()));
                }
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"Timeout value is negative.");
        long beDoneBy = System.currentTimeMillis() + millis;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (Thread thread : this.createdThreads) {
                    long waitTimeLeft = System.currentTimeMillis() - beDoneBy;
                    if (waitTimeLeft <= 0L) {
                        return false;
                    }
                    thread.join(waitTimeLeft);
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted while waiting for request threads to complete.", e);
            return false;
        }
    }
}

