/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.apphosting.logging.JsonFormatter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VmRuntimeFileLogHandler
extends FileHandler {
    public static final String LOG_DIRECTORY_PROPERTY = "com.google.apphosting.logs";
    public static final String LOG_PATTERN_CONFIG_PROPERTY = "com.google.apphosting.vmruntime.VmRuntimeFileLogHandler.pattern";
    private static final String DEFAULT_LOG_DIRECTORY = "/var/log/app_engine";
    private static final String DEFAULT_LOG_PATTERN = "app.%g.log.json";
    private static final String APP_ENGINE_LOG_CONFIG_PATTERN_ENV = "APP_ENGINE_LOG_CONFIG_PATTERN";
    private static final int LOG_MAX_SIZE = 0x6400000;
    private static final int LOG_MAX_FILES = 3;

    private VmRuntimeFileLogHandler() throws IOException {
        super(VmRuntimeFileLogHandler.fileLogPattern(), 0x6400000, 3, true);
        this.setLevel(Level.FINEST);
        this.setFormatter((Formatter)new JsonFormatter());
    }

    private static String fileLogPattern() {
        String pattern = System.getenv(APP_ENGINE_LOG_CONFIG_PATTERN_ENV);
        if (pattern != null) {
            return pattern;
        }
        String directory = System.getProperty(LOG_DIRECTORY_PROPERTY, DEFAULT_LOG_DIRECTORY);
        pattern = System.getProperty(LOG_PATTERN_CONFIG_PROPERTY);
        if (pattern != null) {
            if (pattern.startsWith("/")) {
                return pattern;
            }
            return directory + "/" + pattern;
        }
        return directory + "/" + DEFAULT_LOG_PATTERN;
    }

    public static void init() throws IOException {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof VmRuntimeFileLogHandler)) continue;
            return;
        }
        rootLogger.addHandler(new VmRuntimeFileLogHandler());
    }
}

