/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.apphosting.base.AppId;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.http.HttpRequest;
import com.google.apphosting.utils.http.HttpResponse;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.apphosting.vmruntime.VmRequestThreadFactory;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VmRuntimeUtils {
    private static final String X_GOOGLE_INTERNAL_SKIPADMINCHECK = "X-Google-Internal-SkipAdminCheck";
    private static final String X_APPENGINE_QUEUENAME = "X-AppEngine-QueueName";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    private static final String VM_API_PROXY_HOST = "appengine.googleapis.com";
    private static final int VM_API_PROXY_PORT = 10001;
    public static final long ONE_DAY_IN_MILLIS = 86400000L;
    public static final long MAX_REQUEST_THREAD_INTERRUPT_WAIT_TIME_MS = 10L;
    public static final long MAX_REQUEST_THREAD_API_CALL_WAIT_MS = 30000L;
    public static final long MAX_USER_API_CALL_WAIT_MS = 60000L;
    public static final String LOG_FLUSH_COUNTER_HEADER = "X-AppEngine-Log-Flush-Count";
    public static final String ASYNC_API_WAIT_HEADER = "X-AppEngine-Async-Api-Wait";
    private static final String MINOR_VERSION_PATTERN = "/home/vmagent/.+_%s-([0-9]+)/root";

    private static String getAppEngineRelease() {
        Package vmruntimePackage = VmRuntimeUtils.class.getPackage();
        if (vmruntimePackage == null || vmruntimePackage.getSpecificationVersion() == null) {
            return "unknown";
        }
        return vmruntimePackage.getSpecificationVersion();
    }

    public static String getMinorVersionFromPath(String majorVersion, String path) {
        Pattern pattern = Pattern.compile(String.format(MINOR_VERSION_PATTERN, majorVersion));
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "0";
    }

    public static String getServerInfo() {
        return "Google App Engine/" + VmRuntimeUtils.getAppEngineRelease();
    }

    public static void flushLogsAndAddHeader(HttpResponse response, VmApiProxyEnvironment requestSpecificEnvironment) {
        int flushCount = requestSpecificEnvironment.flushLogs();
        response.setHeader(LOG_FLUSH_COUNTER_HEADER, Integer.toString(flushCount));
    }

    public static void handleSkipAdminCheck(HttpRequest request) {
        if (request.getHeader(X_GOOGLE_INTERNAL_SKIPADMINCHECK) != null || request.getHeader(X_APPENGINE_QUEUENAME) != null) {
            request.setAttribute(SKIP_ADMIN_CHECK_ATTR, Boolean.TRUE);
        }
    }

    static void setEnvironmentSystemProperty(String partition) {
        if ("dev".equals(partition)) {
            System.setProperty(SystemProperty.environment.key(), SystemProperty.Environment.Value.Development.name());
        } else {
            System.setProperty(SystemProperty.environment.key(), SystemProperty.Environment.Value.Production.name());
        }
    }

    public static void installSystemProperties(VmApiProxyEnvironment environment, AppEngineWebXml appEngineWebXml) {
        VmRuntimeUtils.setEnvironmentSystemProperty(environment.getPartition());
        System.setProperty(SystemProperty.version.key(), VmRuntimeUtils.getServerInfo());
        System.setProperty(SystemProperty.applicationId.key(), AppId.parse((String)environment.getAppId()).getLongAppId());
        System.setProperty(SystemProperty.applicationVersion.key(), environment.getVersionId());
        System.setProperty("appengine.jetty.also_log_to_apiproxy", "true");
        if (appEngineWebXml != null) {
            for (Map.Entry<String, String> entry : appEngineWebXml.getSystemProperties().entrySet()) {
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void interruptRequestThreads(VmApiProxyEnvironment requestEnvironment, long millis) {
        Object threadFactory = requestEnvironment.getAttributes().get("com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY");
        if (threadFactory != null && threadFactory instanceof VmRequestThreadFactory) {
            VmRequestThreadFactory vmRequestThreadFactory = (VmRequestThreadFactory)threadFactory;
            vmRequestThreadFactory.interruptRequestThreads();
            vmRequestThreadFactory.join(millis);
        }
    }

    @Deprecated
    public static boolean waitForAsyncApiCalls(VmApiProxyEnvironment requestEnvironment, HttpResponse response) {
        long startTime = System.currentTimeMillis();
        boolean success = requestEnvironment.waitForAllApiCallsToComplete(30000L);
        long elapsed = System.currentTimeMillis() - startTime;
        response.setHeader(ASYNC_API_WAIT_HEADER, Long.toString(elapsed));
        return success;
    }

    public static String getApiServerAddress() {
        String server = (String)MoreObjects.firstNonNull((Object)System.getenv("API_HOST"), (Object)VM_API_PROXY_HOST);
        String port = (String)MoreObjects.firstNonNull((Object)System.getenv("API_PORT"), (Object)"10001");
        return server + ":" + port;
    }
}

