/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.CollectPreconditions;
import com.google.appengine.repackaged.com.google.common.collect.CompactHashMap;
import com.google.appengine.repackaged.com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@GoogleInternal
@GwtIncompatible
public class CompactLinkedHashMap<K, V>
extends CompactHashMap<K, V> {
    private static final int ENDPOINT = -2;
    @VisibleForTesting
    transient long[] links;
    private transient int firstEntry;
    private transient int lastEntry;
    private final boolean accessOrder;

    public static <K, V> CompactLinkedHashMap<K, V> create() {
        return new CompactLinkedHashMap<K, V>();
    }

    public static <K, V> CompactLinkedHashMap<K, V> createWithExpectedSize(int expectedSize) {
        return new CompactLinkedHashMap<K, V>(expectedSize);
    }

    CompactLinkedHashMap() {
        this(3);
    }

    CompactLinkedHashMap(int expectedSize) {
        this(expectedSize, 1.0f, false);
    }

    CompactLinkedHashMap(int expectedSize, float loadFactor, boolean accessOrder) {
        super(expectedSize, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    void init(int expectedSize, float loadFactor) {
        super.init(expectedSize, loadFactor);
        this.firstEntry = -2;
        this.lastEntry = -2;
        this.links = new long[expectedSize];
        Arrays.fill(this.links, -1L);
    }

    private int getPredecessor(int entry) {
        return (int)(this.links[entry] >>> 32);
    }

    private int getSuccessor(int entry) {
        return (int)this.links[entry];
    }

    private void setSuccessor(int entry, int succ) {
        long succMask = 0xFFFFFFFFL;
        this.links[entry] = this.links[entry] & (succMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)succ & succMask;
    }

    private void setPredecessor(int entry, int pred) {
        long predMask = -4294967296L;
        this.links[entry] = this.links[entry] & (predMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)pred << 32;
    }

    private void setSucceeds(int pred, int succ) {
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
        } else {
            this.setPredecessor(succ, pred);
        }
    }

    @Override
    void insertEntry(int entryIndex, K key, V value, int hash) {
        super.insertEntry(entryIndex, key, value, hash);
        this.setSucceeds(this.lastEntry, entryIndex);
        this.setSucceeds(entryIndex, -2);
    }

    @Override
    void accessEntry(int index) {
        if (this.accessOrder) {
            this.setSucceeds(this.getPredecessor(index), this.getSuccessor(index));
            this.setSucceeds(this.lastEntry, index);
            this.setSucceeds(index, -2);
            ++this.modCount;
        }
    }

    @Override
    void moveLastEntry(int dstIndex) {
        int srcIndex = this.size() - 1;
        this.setSucceeds(this.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            this.setSucceeds(this.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds(dstIndex, this.getSuccessor(srcIndex));
        }
        super.moveLastEntry(dstIndex);
    }

    @Override
    void resizeEntries(int newCapacity) {
        super.resizeEntries(newCapacity);
        this.links = Arrays.copyOf(this.links, newCapacity);
    }

    @Override
    Set<Map.Entry<K, V>> createEntrySet() {
        class EntrySetImpl
        extends CompactHashMap.EntrySetView {
            EntrySetImpl() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Itr<Map.Entry<K, V>>(){

                    @Override
                    Map.Entry<K, V> getOutput(int entry) {
                        return new CompactHashMap.MapEntry(entry);
                    }
                };
            }
        }
        return new EntrySetImpl();
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends CompactHashMap.KeySetView {
            KeySetImpl() {
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ObjectArrays.toArrayImpl(this, a);
            }

            @Override
            public Iterator<K> iterator() {
                return new Itr<K>(){

                    @Override
                    K getOutput(int entry) {
                        return CompactLinkedHashMap.this.keys[entry];
                    }
                };
            }
        }
        return new KeySetImpl();
    }

    @Override
    Collection<V> createValues() {
        class ValuesImpl
        extends CompactHashMap.ValuesView {
            ValuesImpl() {
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ObjectArrays.toArrayImpl(this, a);
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(){

                    @Override
                    V getOutput(int entry) {
                        return CompactLinkedHashMap.this.values[entry];
                    }
                };
            }
        }
        return new ValuesImpl();
    }

    @Override
    public void clear() {
        super.clear();
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        private int next;
        private int toRemove;
        private int expectedModCount;

        private Itr() {
            this.next = CompactLinkedHashMap.this.firstEntry;
            this.toRemove = -1;
            this.expectedModCount = CompactLinkedHashMap.this.modCount;
        }

        private void checkForConcurrentModification() {
            if (CompactLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != -2;
        }

        abstract T getOutput(int var1);

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.getOutput(this.next);
            this.toRemove = this.next;
            this.next = CompactLinkedHashMap.this.getSuccessor(this.next);
            return result;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.toRemove != -1);
            CompactLinkedHashMap.this.remove(CompactLinkedHashMap.this.keys[this.toRemove]);
            if (this.next >= CompactLinkedHashMap.this.size()) {
                this.next = this.toRemove;
            }
            this.expectedModCount = CompactLinkedHashMap.this.modCount;
            this.toRemove = -1;
        }
    }
}

