/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.AbstractLogger;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLoggingApi;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.LogFormat;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteStackTrace;
import com.google.appengine.repackaged.com.google.common.flogger.StackSize;
import com.google.appengine.repackaged.com.google.common.flogger.parser.DefaultBraceStyleMessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.parser.MessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.util.CallerFinder;
import java.util.logging.Level;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class GoogleLogContext<LOGGER extends AbstractLogger<API>, API extends GoogleLoggingApi<API>>
extends LogContext<LOGGER, API>
implements GoogleLoggingApi<API> {
    private LogFormat format = LogFormat.PRINTF_STYLE;

    protected GoogleLogContext(Level level, boolean isForced) {
        super(level, isForced);
    }

    @Override
    public final API usingLegacyBraceFormat() {
        this.format = LogFormat.BRACE_STYLE;
        return (API)((GoogleLoggingApi)this.api());
    }

    @Override
    public API withStackTrace(StackSize size) {
        this.addMetadata("com.google.flogger/stack size", (Object)size);
        return (API)((GoogleLoggingApi)this.api());
    }

    @Override
    protected final MessageParser getMessageParser() {
        switch (this.format) {
            case PRINTF_STYLE: {
                return DefaultPrintfMessageParser.getInstance();
            }
            case BRACE_STYLE: {
                return DefaultBraceStyleMessageParser.getInstance();
            }
        }
        String string = String.valueOf((Object)this.format);
        throw new AssertionError((Object)new StringBuilder(25 + String.valueOf(string).length()).append("unsupported format type: ").append(string).toString());
    }

    @Override
    protected boolean postProcess(@Nullable LogSiteKey logSiteKey) {
        if (!super.postProcess(logSiteKey)) {
            return false;
        }
        StackSize stackSize = (StackSize)((Object)this.getMetadata().findValue("com.google.flogger/stack size"));
        if (stackSize != null) {
            this.removeMetadata("com.google.flogger/stack size");
            LogSiteStackTrace context = new LogSiteStackTrace((Throwable)this.getMetadata().findValue("/cause"), stackSize, CallerFinder.getStackForCallerOf(LogContext.class, new Throwable(), 2, stackSize.getMaxDepth()));
            this.setMetadata("/cause", context);
        }
        return true;
    }

    public static final class Key {
        public static final String CONTEXT_STACK_SIZE = "com.google.flogger/stack size";

        private Key() {
        }
    }
}

