/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.htmlform;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.html.HtmlEscapers;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.parameterset.ParameterSet;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.appengine.repackaged.com.google.io.protocol.HtmlFormGenerator;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.httputil.LegacyHttpHeaders;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Proto2HtmlFormGenerator {
    private final ParameterSet parameterSet;
    private final Map<String, String> errors = Maps.newHashMap();
    private final FormInfo formInfo;
    private final HtmlFormGenerator delegate;
    private final PrintWriter out;
    private final EnumSet<HtmlFormGenerator.Options> options;

    private static HtmlFormGenerator.FormInfo wrapFormInfo(final FormInfo formInfo) {
        return new HtmlFormGenerator.FormInfo(){

            @Override
            public String getURI() {
                return formInfo.getURI();
            }

            @Override
            public String getSubmitButtonName() {
                return formInfo.getSubmitButtonName();
            }

            @Override
            public LegacyHttpHeaders.Protocol getProtocolType() {
                return formInfo.getProtocolType();
            }

            @Override
            public Map<String, String> getHiddenInputs() {
                return formInfo.getHiddenInputs();
            }

            @Override
            public void generatePostMessageHtml(ProtocolMessage message) {
                formInfo.generatePostMessageHtml(message);
            }
        };
    }

    public Proto2HtmlFormGenerator(ParameterSet parameterSet, FormInfo formInfo, PrintWriter out, EnumSet<HtmlFormGenerator.Options> options) {
        this.delegate = new HtmlFormGenerator(parameterSet, Proto2HtmlFormGenerator.wrapFormInfo(formInfo), out, options);
        this.parameterSet = parameterSet;
        this.formInfo = formInfo;
        this.out = out;
        this.options = options;
    }

    public Proto2HtmlFormGenerator(ParameterSet parameterSet, FormInfo formInfo, PrintWriter out) {
        this.delegate = new HtmlFormGenerator(parameterSet, Proto2HtmlFormGenerator.wrapFormInfo(formInfo), out);
        this.parameterSet = parameterSet;
        this.formInfo = formInfo;
        this.out = out;
        this.options = EnumSet.noneOf(HtmlFormGenerator.Options.class);
    }

    public Proto2HtmlFormGenerator(ParameterSet parameterSet, String formName, PrintWriter out) {
        this.delegate = new HtmlFormGenerator(parameterSet, formName, out);
        this.parameterSet = parameterSet;
        this.formInfo = new BasicFormInfo(formName);
        this.out = out;
        this.options = EnumSet.noneOf(HtmlFormGenerator.Options.class);
    }

    public void renderHttpHeader(String contentType) {
        this.delegate.renderHttpHeader(contentType);
    }

    public void renderHeader(String title) {
        this.delegate.renderHeader(title);
    }

    public void renderFooter() {
        this.delegate.renderFooter();
    }

    public <T extends MessageLite> T handleFormSubmit(String title, Class<? extends T> clazz, T protoMessage) {
        if (protoMessage instanceof ProtocolMessage) {
            return (T)this.delegate.handleFormSubmit(title, clazz, (ProtocolMessage)protoMessage);
        }
        if (!(protoMessage instanceof Message)) {
            throw new UnsupportedOperationException();
        }
        Message request = this.parseRequest((Message)protoMessage);
        if (!this.hasErrors() && this.hasParameter("submit")) {
            return (T)request;
        }
        this.renderMessage(title, request);
        return null;
    }

    public void renderMessage(String title, MessageLite messageLite) {
        boolean debugging;
        if (messageLite instanceof ProtocolMessage) {
            this.delegate.renderMessage(title, (ProtocolMessage)messageLite);
            return;
        }
        Message message = (Message)messageLite;
        PrintWriter out = this.out;
        if (!this.options.contains((Object)HtmlFormGenerator.Options.EXCLUDE_HTML_HEADER_FOOTER)) {
            this.renderHeader(title);
        }
        out.print("<a name='top'></a>");
        if (title != null) {
            out.format("<h1>%s</h1>", title);
        }
        if ((debugging = this.options.contains((Object)HtmlFormGenerator.Options.DEBUG)) && this.hasErrors()) {
            out.println("<h2>Errors</h2>");
            this.showErrors();
            out.println("<hr />");
        }
        if (message != null) {
            this.renderTopLevelStructure(message);
        } else {
            this.renderHeader("Internal Error");
            out.format("<p><b>Unexpected error</b></p>\n", new Object[0]);
            out.format("<p>Internal message was '%s'</p>\n", this.errors.get("main"));
        }
        if (debugging && message != null) {
            out.println("<hr />");
            out.println("<h2>Message as string</h2>");
            out.println("<pre>");
            out.print(this.escapeContent(message));
            out.println("</pre>");
        }
        if (debugging) {
            out.println("<hr />");
            out.println("<h2>Parameter Map</h2>");
            this.showParameterMap();
        }
        out.println("<p><a href='#top'>Back to the top</a></p>\n");
        if (!this.options.contains((Object)HtmlFormGenerator.Options.EXCLUDE_HTML_HEADER_FOOTER)) {
            this.renderFooter();
        }
    }

    private void renderTopLevelStructure(Message message) {
        PrintWriter out = this.out;
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        String className = message.getClass().getSimpleName();
        out.format("<h2>%s</h2>", className);
        if (this.hasErrors()) {
            out.println("<p class='red'><b>Input has errors!</b></p>");
        }
        if (!readOnly) {
            out.format("<form method='%s' action='%s' name='%s' id='%s'>\n", this.formInfo.getProtocolType(), this.escapeAttribute(this.formInfo.getURI()), "Editor", "Editor");
            Map<String, String> hiddenInputs = this.formInfo.getHiddenInputs();
            for (String key : hiddenInputs.keySet()) {
                out.format("<input type='hidden' name='%s' value='%s' />\n", this.escapeAttribute(key), this.escapeAttribute(hiddenInputs.get(key)));
            }
            String buttonFormat = "<input type='submit' name='%s' value='%s' />\n";
            out.format(buttonFormat, "reload", "Reload");
            if (this.singleTextArea()) {
                out.format(buttonFormat, "formType", "Individual Fields");
            } else {
                out.format(buttonFormat, "expand", "Expand");
                out.format(buttonFormat, "formType", "Single Text Area");
            }
            out.format(buttonFormat, "clear", "Clear");
            out.format(buttonFormat, "submit", this.escapeAttribute(this.formInfo.getSubmitButtonName()));
            out.println("<br /><br />");
        }
        out.format("<table cellspacing='0' cellpadding='0' border='0'>\n", new Object[0]);
        this.renderProtocolMessage(message, "", 0);
        out.println("</table>");
        if (!readOnly) {
            this.formInfo.generatePostMessageHtml(message);
            out.println("</form>");
        }
    }

    private void renderProtocolMessage(Message message, String structureID, int indent) {
        String uninterpretedTags = this.encodeUninterpretedTagsFrom(message);
        if (uninterpretedTags != null) {
            this.out.format("<input type='hidden' name='%s%s' value='%s' />", "utags-", structureID, uninterpretedTags);
        }
        if (this.singleTextArea()) {
            boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
            this.out.append("<b>Text representation of protocol buffer:</b><br />");
            this.out.format("<textarea name='%s' %s rows='20' cols='75'>%s</textarea>", "primaryTextArea", readOnly ? "readonly " : "", message);
        } else {
            List<Descriptors.FieldDescriptor> fields = message.getDescriptorForType().getFields();
            for (Descriptors.FieldDescriptor field : fields) {
                int n = field.getNumber();
                this.renderOneField(message, new StringBuilder(11 + String.valueOf(structureID).length()).append(structureID).append(n).toString(), field, indent);
            }
        }
    }

    private boolean singleTextArea() {
        return "Single Text Area".equals(this.getParameter("formType"));
    }

    private void renderOneField(Message message, String fieldID, Descriptors.FieldDescriptor field, int indent) {
        int count;
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        Descriptors.FieldDescriptor.Type type = field.getType();
        boolean isStructure = type == Descriptors.FieldDescriptor.Type.GROUP || type == Descriptors.FieldDescriptor.Type.MESSAGE;
        String extra = "";
        int n = field.isRepeated() ? message.getRepeatedFieldCount(field) : (count = message.hasField(field) ? 1 : 0);
        if (!field.isRepeated()) {
            Object value = message.getField(field);
            if (field.isOptional()) {
                if (readOnly) {
                    extra = String.format("<span>Optional %s</span>", count == 0 ? "missing" : "present");
                } else if (isStructure) {
                    extra = Proto2HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(fieldID).concat("."), count == 0 ? "Create" : "Delete");
                } else {
                    String checked = count > 0 ? " checked='checked'" : "";
                    extra = String.format("<label><input type='checkbox' name='%s.' id='id%s' value='y'%s />include this field</label>", fieldID, fieldID, checked);
                }
            } else {
                count = 1;
            }
            this.renderOneValue(value, indent, message, field, fieldID, extra, count);
        } else if (count == 0) {
            char checked = '-';
            String elementID = new StringBuilder(2 + String.valueOf(fieldID).length()).append(fieldID).append(checked).append("0").toString();
            Object value = null;
            extra = readOnly ? "<span>Empty array</span>" : Proto2HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(elementID).concat("."), "Create");
            this.renderOneValue(value, indent, message, field, elementID, extra, 0);
        } else {
            for (int i = 0; i < count; ++i) {
                Object value = message.getRepeatedField(field, i);
                char c = '-';
                int n2 = i;
                String elementID = new StringBuilder(12 + String.valueOf(fieldID).length()).append(fieldID).append(c).append(n2).toString();
                if (!readOnly) {
                    extra = Proto2HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(elementID).concat("."), "Add", "Delete");
                }
                this.renderOneValue(value, indent, message, field, elementID, extra, i + 1);
            }
        }
    }

    private void renderOneValue(Object value, int indent, Message message, Descriptors.FieldDescriptor field, String valueID, String extra, int count) {
        String checkbox;
        PrintWriter out = this.out;
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        String fieldName = field.getName();
        Descriptors.FieldDescriptor.Type baseType = field.getType();
        boolean isStructure = baseType == Descriptors.FieldDescriptor.Type.GROUP || baseType == Descriptors.FieldDescriptor.Type.MESSAGE;
        boolean isRepeated = field.isRepeated();
        Descriptors.EnumDescriptor enumType = field.getType() == Descriptors.FieldDescriptor.Type.ENUM ? field.getEnumType() : null;
        String javaScript = "";
        if (field.isOptional() && !isStructure && !readOnly) {
            checkbox = this.options.contains((Object)HtmlFormGenerator.Options.XHTML) ? String.format("getElementById('id%s')", valueID) : String.format("%s.elements['%s.']", "Editor", valueID);
            javaScript = String.format(" onfocus=\"document.%s.checked=true;\"", checkbox);
        }
        if (extra.length() > 0) {
            checkbox = extra;
            extra = new StringBuilder(44 + String.valueOf(checkbox).length()).append("<td>&nbsp;</td><td class='smallgray'>\n").append(checkbox).append("\n</td>").toString();
        }
        out.format("<tr>", new Object[0]);
        for (int i = 0; i < indent; ++i) {
            out.format("<td class='stripe%s' />\n", i % HtmlFormGenerator.Constants.STRIPE_COLORS.length);
            out.format("<td class='nostripe' />\n", new Object[0]);
        }
        out.format("<td colspan='%s'>%s", 2 * (25 - indent), fieldName);
        if (isRepeated && count >= 1) {
            out.format(" #%d", count);
        }
        if (this.options.contains((Object)HtmlFormGenerator.Options.DEBUG)) {
            out.format("<span class='smalldebug'> %s </span>", valueID);
        }
        String errorValue = this.errors.get(valueID);
        out.format(":\n", new Object[0]);
        if (errorValue != null) {
            out.format("<span class='red'> Illegal %s value </span>\n", new Object[]{baseType});
        }
        if (count == 0 && (isRepeated || isStructure)) {
            out.format("</td>%s</tr>\n", extra);
        } else if (baseType == Descriptors.FieldDescriptor.Type.BYTES) {
            this.generateTextField(BaseEncoding.base64Url().encode(((ByteString)value).toByteArray()), valueID, baseType, errorValue, javaScript, extra);
        } else if (isStructure) {
            MessageLite subMessage = (Message)value;
            if (subMessage == null) {
                subMessage = message.newBuilderForType().newBuilderForField(field).getDefaultInstanceForType();
            }
            out.format("<input type='hidden' name='%s' value='t' />", valueID);
            out.format("</td>%s</tr>\n", extra);
            char c = '.';
            this.renderProtocolMessage((Message)subMessage, new StringBuilder(1 + String.valueOf(valueID).length()).append(valueID).append(c).toString(), indent + 1);
        } else if (enumType != null) {
            this.generateEnumerationField(value, valueID, enumType, javaScript, extra);
        } else if (baseType == Descriptors.FieldDescriptor.Type.BOOL) {
            this.generateBooleanField(value, valueID, javaScript, extra);
        } else {
            this.generateTextField(value, valueID, baseType, errorValue, javaScript, extra);
        }
    }

    public static String getSubmitButtonsMarkup(String name, String ... values) {
        return HtmlFormGenerator.getSubmitButtonsMarkup(name, values);
    }

    private void generateEnumerationField(Object value, String valueID, Descriptors.EnumDescriptor enumType, String javaScript, String extra) {
        boolean skipSelect;
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        boolean bl = skipSelect = readOnly || this.options.contains((Object)HtmlFormGenerator.Options.XHTML) || this.options.contains((Object)HtmlFormGenerator.Options.DEBUG) || this.options.contains((Object)HtmlFormGenerator.Options.USE_INPUT_FOR_ENUM);
        if (!skipSelect && value != null) {
            if (javaScript.length() > 0) {
                javaScript = javaScript.replaceFirst("onfocus=", "onchange=");
            }
            this.out.format("<select name='%s' %s %s>\n", valueID, readOnly ? "disabled" : "", javaScript);
            for (Descriptors.EnumValueDescriptor enumName : enumType.getValues()) {
                int evalue = enumName.getNumber();
                this.out.format("<option value='%s' %s>%s (%s)</option>\n", evalue, ((Descriptors.EnumValueDescriptor)value).getNumber() == enumName.getNumber() ? "selected" : "", enumName, evalue);
            }
            this.out.print("</select>");
        } else {
            this.out.format("<input type='text' name='%s' value='%s' %s %s/>", valueID, value, readOnly ? "disabled" : "", javaScript);
        }
        this.out.format("</label></td>%s</tr>\n", extra);
    }

    private void generateBooleanField(Object value, String valueID, String javaScript, String extra) {
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        if (javaScript.length() > 0) {
            javaScript = javaScript.replaceFirst("onfocus=", "onclick=");
        }
        boolean isTrue = (Boolean)value;
        this.out.format("<label><input type='radio' name='%s' value='t'%s%s %s/>true</label>\n", valueID, isTrue ? " checked='checked' " : " ", readOnly ? " disabled" : " ", javaScript);
        this.out.format("<label><input type='radio' name='%s' value='f'%s%s %s/>false</label>\n", valueID, isTrue ? " " : " checked='checked' ", readOnly ? " disabled" : " ", javaScript);
        this.out.format("</td>%s</tr>\n", extra);
    }

    private void generateTextField(Object value, String valueID, Descriptors.FieldDescriptor.Type baseType, String errorValue, String javaScript, String extra) {
        boolean readOnly = this.options.contains((Object)HtmlFormGenerator.Options.READONLY);
        if (errorValue != null) {
            this.out.format("<input class='red' type='text' name='%s' value='%s'%s /></td>%s</tr>\n", valueID, errorValue, javaScript, extra);
        } else {
            if (value == null) {
                value = "";
            }
            int rows = 10;
            boolean useTextArea = false;
            if (baseType == Descriptors.FieldDescriptor.Type.STRING && this.options.contains((Object)HtmlFormGenerator.Options.USE_TEXT_AREA) && value.toString().contains("\r\n")) {
                useTextArea = true;
            }
            boolean containsHtml = false;
            if (StringUtil.containsCharRef(value.toString())) {
                containsHtml = true;
                rows = 25;
            }
            if (this.options.contains((Object)HtmlFormGenerator.Options.HTML_ESCAPE_FIELDS)) {
                value = this.escapeContent(value);
            }
            if (readOnly) {
                if (containsHtml || useTextArea) {
                    this.out.format("<textarea rows='%s' cols='75' readonly>%s</textarea>", rows, value);
                } else {
                    this.out.format("<span class='result'>%s</span>", value);
                }
            } else if (containsHtml || useTextArea) {
                this.out.format("<textarea name='%s' rows='%s' cols='75'%s>%s</textarea>", valueID, rows, javaScript, value);
            } else {
                this.out.format("<input type='text' name='%s' value='%s'%s />", valueID, value, javaScript);
            }
            this.out.format("</td>%s</tr>\n", extra);
        }
    }

    private <T extends Message> T parseRequest(T protoMessage) {
        Message.Builder builder = protoMessage.newBuilderForType();
        if (this.hasParameter("clear")) {
            Message result = builder.buildPartial();
            return (T)result;
        }
        if (this.hasParameter("primaryTextArea")) {
            try {
                TextFormat.merge((CharSequence)this.getParameter("primaryTextArea"), builder);
                Message result = builder.buildPartial();
                return (T)result;
            }
            catch (Exception e) {
                this.errors.put("main", e.getMessage());
                return null;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream ps = CodedOutputStream.newInstance(baos);
        this.structureToSink("", "", protoMessage, ps);
        try {
            ps.flush();
            baos.flush();
            builder.mergeFrom(baos.toByteArray());
            Message result = builder.buildPartial();
            return (T)result;
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            this.errors.put("main", string.length() != 0 ? "Internal error parsing Data Sink: ".concat(string) : new String("Internal error parsing Data Sink: "));
            return null;
        }
    }

    private void structureToSink(String inStructureID, String outStructureID, Message message, CodedOutputStream sink) {
        List<Descriptors.FieldDescriptor> tags = message.getDescriptorForType().getFields();
        for (Descriptors.FieldDescriptor tag : tags) {
            int n = tag.getNumber();
            this.fieldToSink(new StringBuilder(11 + String.valueOf(inStructureID).length()).append(inStructureID).append(n).toString(), tag, sink, message);
        }
        String string = String.valueOf("utags-");
        String string2 = String.valueOf(inStructureID);
        String uninterpretedTags = this.getParameter(string2.length() != 0 ? string.concat(string2) : new String(string));
        if (uninterpretedTags != null) {
            this.mergeUninterpretedTagsInto(sink, uninterpretedTags);
        }
    }

    private void fieldToSink(String fieldId, Descriptors.FieldDescriptor field, CodedOutputStream sink, Message message) {
        boolean isStructure;
        Descriptors.FieldDescriptor.Type baseType = field.getType();
        boolean bl = isStructure = baseType == Descriptors.FieldDescriptor.Type.GROUP || baseType == Descriptors.FieldDescriptor.Type.MESSAGE;
        if (!field.isRepeated()) {
            String value = this.getParameter(fieldId);
            if (field.isOptional()) {
                String secondParameterKey = String.valueOf(fieldId).concat(".");
                String secondParameterValue = this.getParameter(secondParameterKey);
                if (!isStructure) {
                    if (secondParameterValue == null) {
                        return;
                    }
                } else if ("Create".equals(secondParameterValue)) {
                    value = null;
                } else {
                    if ("Delete".equals(secondParameterValue)) {
                        return;
                    }
                    if (value == null && !this.hasParameter("expand")) {
                        return;
                    }
                }
            }
            this.valueToSink(message, field, fieldId, fieldId, value, sink);
        } else {
            int count = 0;
            int i = 0;
            while (true) {
                char c = '-';
                int n = i;
                String inkey = new StringBuilder(12 + String.valueOf(fieldId).length()).append(fieldId).append(c).append(n).toString();
                n = 45;
                int n2 = count++;
                String outkey = new StringBuilder(12 + String.valueOf(fieldId).length()).append(fieldId).append((char)n).append(n2).toString();
                String actionKey = String.valueOf(inkey).concat(".");
                String value = this.getParameter(inkey);
                String actionValue = this.getParameter(actionKey);
                if (i == 0 && "Create".equals(actionValue)) {
                    this.valueToSink(message, field, inkey, outkey, null, sink);
                }
                if (value == null) break;
                if (!"Delete".equals(actionValue)) {
                    ++count;
                    this.valueToSink(message, field, inkey, outkey, value, sink);
                }
                if ("Add".equals(actionValue)) {
                    ++count;
                    this.valueToSink(message, field, inkey, outkey, null, sink);
                }
                ++i;
            }
            if (count == 0 && this.hasParameter("expand")) {
                char c = '-';
                String key = new StringBuilder(2 + String.valueOf(fieldId).length()).append(fieldId).append(c).append("0").toString();
                this.valueToSink(message, field, key, key, null, sink);
            }
        }
    }

    private void valueToSink(Message message, Descriptors.FieldDescriptor field, String inValueID, String outValueID, String value, CodedOutputStream sink) {
        if (value == null) {
            value = "";
        }
        try {
            block5 : switch (field.getType()) {
                case BOOL: {
                    boolean result = value.length() > 0 && value.charAt(0) == 't';
                    sink.writeBool(field.getNumber(), result);
                    break;
                }
                case FIXED32: 
                case SFIXED32: 
                case ENUM: 
                case UINT32: 
                case SINT32: 
                case INT32: {
                    int result;
                    try {
                        result = value.length() == 0 ? this.defaultFieldValue(message, field).intValue() : Integer.decode(value).intValue();
                    }
                    catch (NumberFormatException e) {
                        this.errors.put(outValueID, value);
                        result = 0;
                    }
                    switch (field.getType()) {
                        case FIXED32: {
                            sink.writeFixed32(field.getNumber(), result);
                            break block5;
                        }
                        case SFIXED32: {
                            sink.writeSFixed32(field.getNumber(), result);
                            break block5;
                        }
                        case ENUM: {
                            sink.writeEnum(field.getNumber(), result);
                            break block5;
                        }
                        case UINT32: {
                            sink.writeUInt32(field.getNumber(), result);
                            break block5;
                        }
                        case SINT32: {
                            sink.writeSInt32(field.getNumber(), result);
                            break block5;
                        }
                        case INT32: {
                            sink.writeInt32(field.getNumber(), result);
                            break block5;
                        }
                    }
                    String e = String.valueOf((Object)field.getType());
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(e).length()).append("Unknown int field type ").append(e).toString());
                }
                case FIXED64: 
                case SFIXED64: 
                case UINT64: 
                case SINT64: 
                case INT64: {
                    long result;
                    try {
                        result = value.length() == 0 ? this.defaultFieldValue(message, field).longValue() : Long.decode(value).longValue();
                    }
                    catch (NumberFormatException e) {
                        this.errors.put(outValueID, value);
                        result = 0L;
                    }
                    switch (field.getType()) {
                        case FIXED64: {
                            sink.writeFixed64(field.getNumber(), result);
                            break block5;
                        }
                        case SFIXED64: {
                            sink.writeSFixed64(field.getNumber(), result);
                            break block5;
                        }
                        case UINT64: {
                            sink.writeUInt64(field.getNumber(), result);
                            break block5;
                        }
                        case SINT64: {
                            sink.writeSInt64(field.getNumber(), result);
                            break block5;
                        }
                        case INT64: {
                            sink.writeInt64(field.getNumber(), result);
                            break block5;
                        }
                    }
                    String e = String.valueOf((Object)field.getType());
                    throw new IllegalStateException(new StringBuilder(18 + String.valueOf(e).length()).append("Unknown long type ").append(e).toString());
                }
                case DOUBLE: {
                    double result;
                    try {
                        result = value.length() == 0 ? this.defaultFieldValue(message, field).doubleValue() : Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        this.errors.put(outValueID, value);
                        result = 0.0;
                    }
                    sink.writeDouble(field.getNumber(), result);
                    break;
                }
                case FLOAT: {
                    float result;
                    try {
                        result = value.length() == 0 ? this.defaultFieldValue(message, field).floatValue() : Float.parseFloat(value);
                    }
                    catch (NumberFormatException e) {
                        this.errors.put(outValueID, value);
                        result = 0.0f;
                    }
                    sink.writeFloat(field.getNumber(), result);
                    break;
                }
                case MESSAGE: {
                    MessageLite subMessage = message.newBuilderForType().newBuilderForField(field).getDefaultInstanceForType();
                    if (value.length() == 0) {
                        sink.writeMessage(field.getNumber(), subMessage);
                        break;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    CodedOutputStream ps = CodedOutputStream.newInstance(baos);
                    char c = '.';
                    String string = new StringBuilder(1 + String.valueOf(inValueID).length()).append(inValueID).append(c).toString();
                    c = '.';
                    this.structureToSink(string, new StringBuilder(1 + String.valueOf(outValueID).length()).append(outValueID).append(c).toString(), (Message)subMessage, ps);
                    ps.flush();
                    baos.flush();
                    sink.writeMessage(field.getNumber(), subMessage.newBuilderForType().mergeFrom(baos.toByteArray()).buildPartial());
                    break;
                }
                case BYTES: {
                    if (value.length() == 0) {
                        ByteString defaultBytes = (ByteString)message.getDefaultInstanceForType().getField(field);
                        sink.writeBytes(field.getNumber(), defaultBytes);
                        break;
                    }
                    ByteString pSink = this.getByteString(outValueID, value);
                    sink.writeBytes(field.getNumber(), pSink);
                    break;
                }
                case GROUP: {
                    MessageLite subMessage = message.newBuilderForType().newBuilderForField(field).getDefaultInstanceForType();
                    if (value.length() == 0) {
                        sink.writeGroup(field.getNumber(), subMessage);
                        break;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    CodedOutputStream ps = CodedOutputStream.newInstance(baos);
                    char c = '.';
                    String string = new StringBuilder(1 + String.valueOf(inValueID).length()).append(inValueID).append(c).toString();
                    c = '.';
                    this.structureToSink(string, new StringBuilder(1 + String.valueOf(outValueID).length()).append(outValueID).append(c).toString(), (Message)subMessage, ps);
                    ps.flush();
                    baos.flush();
                    sink.writeGroup(field.getNumber(), subMessage.newBuilderForType().mergeFrom(baos.toByteArray()).buildPartial());
                    break;
                }
                case STRING: {
                    if (this.options.contains((Object)HtmlFormGenerator.Options.HTML_ESCAPE_FIELDS)) {
                        value = this.unescape(value);
                    }
                    sink.writeString(field.getNumber(), value);
                    break;
                }
                default: {
                    String subMessage = String.valueOf((Object)field.getType());
                    throw new IllegalStateException(new StringBuilder(19 + String.valueOf(subMessage).length()).append("Unknown field type ").append(subMessage).toString());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteString getByteString(String outValueID, String value) {
        byte[] result = new byte[]{};
        try {
            result = BaseEncoding.base64Url().decode(CharMatcher.whitespace().removeFrom(new String(value.getBytes(), StandardCharsets.US_ASCII)));
        }
        catch (IllegalArgumentException e) {
            this.errors.put(outValueID, value);
        }
        return ByteString.copyFrom(result);
    }

    private Number defaultFieldValue(Message message, Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                return field.getEnumType().getValues().get(0).getNumber();
            }
            return 0;
        }
        return (Number)message.getDefaultInstanceForType().getField(field);
    }

    protected void mergeUninterpretedTagsInto(CodedOutputStream sink, String uninterpretedTags) {
        if (uninterpretedTags == null) {
            return;
        }
        try {
            UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom(BaseEncoding.base64Url().decode(CharMatcher.whitespace().removeFrom(uninterpretedTags)));
            sink.writeGroupNoTag(unknownFieldSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String encodeUninterpretedTagsFrom(Message pb) {
        byte[] uninterpretedArray = pb.getUnknownFields().toByteArray();
        if (uninterpretedArray.length == 0) {
            return null;
        }
        return BaseEncoding.base64Url().encode(uninterpretedArray);
    }

    private void showParameterMap() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = this.parameterSet.getParameterNames();
        while (iterator.hasNext()) {
            list.add((String)iterator.next());
        }
        Collections.sort(list);
        this.out.println("<table border='1' cellpadding='2' summary='Arguments'>");
        this.out.println("<tr><th>Parameter</th> <th>Value</th></tr>");
        for (String key : list) {
            String value = this.getParameter(key);
            String ekey = this.escapeContent(key);
            String evalue = value.length() == 0 ? "<span class='red'>&lt;empty&gt;</span>" : this.escapeContent(value);
            this.out.format("<tr><td><code>%s</code></td><td><code>%s</code></td></tr>\n", ekey, evalue);
        }
        this.out.println("</table>");
    }

    private void showErrors() {
        this.out.println("<table border='1' cellpadding='2' summary='Errors'>");
        for (String key : this.errors.keySet()) {
            String value = this.errors.get(key);
            this.out.format("<tr><td><code>%s</code></td><td><code>%s</code></td></tr>\n", this.escapeContent(key), this.escapeContent(value));
        }
        this.out.println("</table>");
    }

    private boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private String getParameter(String key) {
        return this.parameterSet.getParameter(key);
    }

    private boolean hasParameter(String key) {
        return this.parameterSet.getParameter(key) != null;
    }

    private String escapeAttribute(Object obj) {
        return this.options.contains((Object)HtmlFormGenerator.Options.XHTML) ? XmlEscapers.xmlAttributeEscaper().escape(obj.toString()) : HtmlEscapers.htmlEscaper().escape(obj.toString());
    }

    private String escapeContent(Object obj) {
        return this.options.contains((Object)HtmlFormGenerator.Options.XHTML) ? XmlEscapers.xmlContentEscaper().escape(obj.toString()) : HtmlEscapers.htmlEscaper().escape(obj.toString());
    }

    private String unescape(String escapedString) {
        return StringUtil.unescapeHTML(escapedString);
    }

    public static class BasicFormInfo
    implements FormInfo {
        private final String uri;

        public BasicFormInfo(String uri) {
            this.uri = uri;
        }

        @Override
        public Map<String, String> getHiddenInputs() {
            return Maps.newHashMap();
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public LegacyHttpHeaders.Protocol getProtocolType() {
            return LegacyHttpHeaders.Protocol.GET;
        }

        @Override
        public String getSubmitButtonName() {
            return "Submit";
        }

        @Override
        public void generatePostMessageHtml(MessageLite message) {
        }
    }

    public static interface FormInfo {
        public Map<String, String> getHiddenInputs();

        public String getURI();

        public LegacyHttpHeaders.Protocol getProtocolType();

        public String getSubmitButtonName();

        public void generatePostMessageHtml(MessageLite var1);
    }
}

