/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.modules.dev.LocalModulesService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.ModulesController;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.apphosting.api.ApiProxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalModulesServiceTestConfig
implements LocalServiceTestConfig {
    private static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";
    public static final String DEFAULT_MODULE_NAME = "default";
    static final String DEFAULT_VERSION = "1";
    private static final Logger logger = Logger.getLogger(LocalModulesServiceTestConfig.class.getName());
    static final int MAIN_INSTANCE = -1;
    static final int DYNAMIC_INSTANCE_COUNT = -1;
    private TestModulesController testModulesController;
    private final Map<ModuleVersionKey, ModuleVersion> moduleVersionMap = new LinkedHashMap<ModuleVersionKey, ModuleVersion>();

    @Override
    public synchronized void setUp() {
        this.createModulesController(this.moduleVersionMap.isEmpty() ? this.generateModuleVersions() : this.moduleVersionMap.values());
        LocalModulesService localModulesService = LocalModulesServiceTestConfig.getLocalModulesService();
        localModulesService.setModulesController((ModulesController)this.testModulesController);
    }

    @Override
    public void tearDown() {
    }

    public LocalModulesServiceTestConfig addAutomaticScalingModuleVersion(String module, String version) {
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.AUTOMATIC, -1);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public LocalModulesServiceTestConfig addManualScalingModuleVersion(String module, String version, int numInstances) {
        this.validateInstances(numInstances);
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.MANUAL, numInstances);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public LocalModulesServiceTestConfig addBasicScalingModuleVersion(String module, String version, int numInstances) {
        this.validateInstances(numInstances);
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.BASIC, numInstances);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    private void validateInstances(int numInstances) {
        if (numInstances <= 0) {
            throw new IllegalArgumentException(new StringBuilder(30).append("instanceCount ").append(numInstances).append(" <= 0").toString());
        }
    }

    public LocalModulesServiceTestConfig addDefaultModuleVersion() {
        ModuleVersion moduleVersion = new ModuleVersion(DEFAULT_MODULE_NAME, DEFAULT_VERSION, ScalingType.AUTOMATIC, -1);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public synchronized void clearModuleVersions() {
        this.moduleVersionMap.clear();
    }

    private Iterable<ModuleVersion> generateModuleVersions() {
        String envModuleId = ApiProxy.getCurrentEnvironment().getModuleId();
        String envVersionId = LocalModulesServiceTestConfig.stripMinorVersion(ApiProxy.getCurrentEnvironment().getVersionId());
        String envInstance = (String)ApiProxy.getCurrentEnvironment().getAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE);
        ImmutableList.Builder versionsBuilder = ImmutableList.builder();
        if (!DEFAULT_MODULE_NAME.equals(envModuleId)) {
            versionsBuilder.add(this.generateModuleVersion(DEFAULT_MODULE_NAME, "1.0", null));
        }
        versionsBuilder.add(this.generateModuleVersion(envModuleId, envVersionId, envInstance));
        return versionsBuilder.build();
    }

    private ModuleVersion generateModuleVersion(String module, String version, String instance) {
        if (instance == null) {
            return new ModuleVersion(module, version, ScalingType.AUTOMATIC, -1);
        }
        return new ModuleVersion(module, version, ScalingType.MANUAL, Integer.parseInt(instance) + 1);
    }

    private synchronized void addModuleVersion(ModuleVersion moduleVersion) {
        Preconditions.checkArgument(!this.moduleVersionMap.containsKey(moduleVersion.getKey()), String.format("Module version module %s version %s is already defined: %s", moduleVersion.getModule(), moduleVersion.getVersion(), this.moduleVersionMap.values()));
        this.moduleVersionMap.put(moduleVersion.getKey(), moduleVersion);
    }

    public static LocalModulesService getLocalModulesService() {
        return (LocalModulesService)LocalServiceTestHelper.getLocalService("modules");
    }

    void verifyEnvironment(String module, String version, int instance) {
        version = LocalModulesServiceTestConfig.stripMinorVersion(version);
        this.testModulesController.verifyEnvironment(module, version, instance);
    }

    synchronized boolean requiresEnvironmentInstance(String module, String version) {
        ModuleVersion moduleVersion = this.moduleVersionMap.get(new ModuleVersionKey(module, version));
        return moduleVersion != null && moduleVersion.getInitialNumInstances() != -1;
    }

    private void createModulesController(Iterable<ModuleVersion> moduleVersions) {
        HashMap<String, String> defaultVersions = new HashMap<String, String>();
        ImmutableList.Builder modulesListBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder versionMapBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder<ModuleVersionKey, AbstractModuleVersionState> moduleVersionStateMapBuilder = ImmutableMap.builder();
        for (ModuleVersion moduleVersion : moduleVersions) {
            if (!defaultVersions.containsKey(moduleVersion.getModule())) {
                defaultVersions.put(moduleVersion.getModule(), moduleVersion.getVersion());
                modulesListBuilder.add(moduleVersion.getModule());
            }
            moduleVersionStateMapBuilder.put(moduleVersion.getKey(), moduleVersion.getScalingType().getModuleVersionState(moduleVersion));
            versionMapBuilder.put(moduleVersion.getModule(), moduleVersion.getVersion());
        }
        String string = String.valueOf(moduleVersions);
        Preconditions.checkArgument(defaultVersions.containsKey(DEFAULT_MODULE_NAME), new StringBuilder(63 + String.valueOf(string).length()).append("No version of the default module is configured: moduleVersions=").append(string).toString());
        ImmutableMap.Builder defaultVersionsBuilder = ImmutableMap.builder();
        defaultVersionsBuilder.putAll(defaultVersions);
        this.testModulesController = new TestModulesController(moduleVersionStateMapBuilder.build(), (ImmutableList<String>)modulesListBuilder.build(), (ImmutableMap<String, Collection<String>>)versionMapBuilder.build().asMap(), defaultVersionsBuilder.build());
    }

    private static String stripMinorVersion(String version) {
        return Splitter.on('.').split(version).iterator().next();
    }

    private static class ModuleVersion {
        private final ModuleVersionKey key;
        private final ScalingType scalingType;
        private final int initialNumInstances;

        ModuleVersion(String module, String version, ScalingType scalingType, int initialNumInstances) {
            Preconditions.checkNotNull(module);
            Preconditions.checkNotNull(version);
            if (scalingType == ScalingType.AUTOMATIC) {
                String string = version;
                Preconditions.checkArgument(initialNumInstances == -1, new StringBuilder(82 + String.valueOf(module).length() + String.valueOf(string).length()).append("Automatic scaling module version module ").append(module).append(" version ").append(string).append(" must have initialNumInstances ").append("-1").toString());
            } else {
                String string = version;
                Preconditions.checkArgument(initialNumInstances != -1, new StringBuilder(86 + String.valueOf(module).length() + String.valueOf(string).length()).append("Automatic scaling module version module ").append(module).append(" version ").append(string).append(" must not have initialNumInstances ").append("-1").toString());
            }
            version = LocalModulesServiceTestConfig.stripMinorVersion(version);
            this.key = new ModuleVersionKey(module, version);
            this.scalingType = scalingType;
            this.initialNumInstances = initialNumInstances;
        }

        String getModule() {
            return this.key.getModule();
        }

        String getVersion() {
            return this.key.getVersion();
        }

        int getInitialNumInstances() {
            return this.initialNumInstances;
        }

        ModuleVersionKey getKey() {
            return this.key;
        }

        ScalingType getScalingType() {
            return this.scalingType;
        }

        public String toString() {
            String string;
            String string2 = this.key.getModule();
            String string3 = this.key.getVersion();
            String string4 = String.valueOf((Object)this.scalingType);
            if (this.initialNumInstances == -1) {
                string = "";
            } else {
                int n = this.initialNumInstances;
                string = new StringBuilder(32).append(" initialNumInstances=").append(n).toString();
            }
            String string5 = string;
            return new StringBuilder(43 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("ModuleVersion module=").append(string2).append(" version=").append(string3).append(" scalingType=").append(string4).append(string5).toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.initialNumInstances;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.scalingType == null ? 0 : this.scalingType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleVersion other = (ModuleVersion)obj;
            if (this.initialNumInstances != other.initialNumInstances) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.scalingType == other.scalingType;
        }
    }

    static class BasicScalingModuleVersionState
    extends AbstractModuleVersionState {
        BasicScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }
    }

    static class ManualScalingModuleVersionState
    extends AbstractModuleVersionState {
        ManualScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }

        @Override
        int getNumInstances() {
            return this.numInstances.get();
        }

        @Override
        void setNumInstances(int numInstances) {
            if (numInstances <= 0) {
                String string = this.moduleVersion.getModule();
                String string2 = this.moduleVersion.getVersion();
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$ManualScalingModuleVersionState", "setNumInstances", new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Operation setNumInstances failed with invalid instances value ").append(numInstances).append(" for module ").append(string).append(" version ").append(string2).toString());
                throw new ApiProxy.ApplicationException(3, "The number of instances must be greater than 0.");
            }
            this.numInstances.set(numInstances);
        }
    }

    static class AutomaticScalingModuleVersionState
    extends AbstractModuleVersionState {
        AutomaticScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }

        @Override
        void start() {
            this.reportStartStop("startVersion");
        }

        @Override
        void stop() {
            this.reportStartStop("stopVersion");
        }

        @Override
        String getInstanceDot(int instance) {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AutomaticScalingModuleVersionState", "getInstanceDot", new StringBuilder(86 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Operation getInstanceHostname not allowed for dynamic module version  module ").append(string).append(" version ").append(string2).toString());
            throw new ApiProxy.ApplicationException(2, "The specified instance does not exist for this module/version.");
        }

        private void reportStartStop(String operation) {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AutomaticScalingModuleVersionState", "reportStartStop", new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(operation).length()).append("Automatic scaling module  module ").append(string).append(" version ").append(string2).append(" does not support ").append(operation).toString());
            throw new ApiProxy.ApplicationException(2, "Could not find the specified version.");
        }
    }

    private static abstract class AbstractModuleVersionState {
        protected final ModuleVersion moduleVersion;
        protected final AtomicInteger numInstances;

        AbstractModuleVersionState(ModuleVersion moduleVersion) {
            this.moduleVersion = moduleVersion;
            this.numInstances = new AtomicInteger(moduleVersion.getInitialNumInstances());
        }

        int getNumInstances() {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AbstractModuleVersionState", "getNumInstances", new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Operation getNumInstances requires a manually scaling module version but  Module ").append(string).append(" version ").append(string2).append(" is not manual scaling.").toString());
            throw new ApiProxy.ApplicationException(2, "Could not find the given version.");
        }

        int getNumInstancesInternal() {
            return this.numInstances.get();
        }

        void setNumInstances(int numInstances) {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AbstractModuleVersionState", "setNumInstances", new StringBuilder(106 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Operation setNumInstances requires a manually scaling version but  Module ").append(string).append(" version ").append(string2).append(" is not manual scaling.").toString());
            throw new ApiProxy.ApplicationException(2, "Cannot set the number of instances for a module that has automatic scaling.");
        }

        ModuleVersion getModuleVersion() {
            return this.moduleVersion;
        }

        void start() {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.INFO, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AbstractModuleVersionState", "start", new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Stopped  Module ").append(string).append(" version ").append(string2).toString());
        }

        void stop() {
            String string = this.moduleVersion.getModule();
            String string2 = this.moduleVersion.getVersion();
            logger.logp(Level.INFO, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AbstractModuleVersionState", "stop", new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Started  Module ").append(string).append(" version ").append(string2).toString());
        }

        String getInstanceDot(int instance) {
            if (instance >= this.numInstances.get()) {
                String string = this.moduleVersion.getModule();
                String string2 = this.moduleVersion.getVersion();
                int n = this.numInstances.get();
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$AbstractModuleVersionState", "getInstanceDot", new StringBuilder(134 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Operation getInstanceHostname failed because instances value ").append(instance).append(" is out of range for module ").append(string).append(" version ").append(string2).append(" numInstances ").append(n).toString());
                throw new ApiProxy.ApplicationException(3, "The specified instance does not exist for this module/version.");
            }
            return new StringBuilder(12).append(instance).append(".").toString();
        }

        public String toString() {
            String string;
            String string2 = String.valueOf(this.moduleVersion);
            if (this.numInstances.get() == -1) {
                string = "";
            } else {
                int n = this.numInstances.get();
                string = new StringBuilder(25).append("numInstances =").append(n).toString();
            }
            String string3 = string;
            return new StringBuilder(29 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AbstractModuleVersionState (").append(string2).append(")").append(string3).toString();
        }
    }

    private static class ModuleVersionKey {
        private final String module;
        private final String version;

        ModuleVersionKey(String module, String version) {
            this.module = module;
            this.version = version;
        }

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleVersionKey other = (ModuleVersionKey)obj;
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            String string = this.module;
            String string2 = this.version;
            return new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ModuleVersionKey: module=").append(string).append(" version=").append(string2).toString();
        }
    }

    static enum ScalingType {
        AUTOMATIC{

            @Override
            AutomaticScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new AutomaticScalingModuleVersionState(moduleVersion);
            }
        }
        ,
        BASIC{

            @Override
            BasicScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new BasicScalingModuleVersionState(moduleVersion);
            }
        }
        ,
        MANUAL{

            @Override
            ManualScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new ManualScalingModuleVersionState(moduleVersion);
            }
        };


        abstract AbstractModuleVersionState getModuleVersionState(ModuleVersion var1);
    }

    private static class TestModulesController
    implements ModulesController {
        private final ImmutableMap<ModuleVersionKey, AbstractModuleVersionState> moduleVersionStateMap;
        private final ImmutableList<String> modules;
        private final ImmutableMap<String, Collection<String>> versions;
        private final ImmutableMap<String, String> defaultVersions;

        TestModulesController(ImmutableMap<ModuleVersionKey, AbstractModuleVersionState> moduleVersionStateMap, ImmutableList<String> modules, ImmutableMap<String, Collection<String>> versions, ImmutableMap<String, String> defaultVersions) {
            this.moduleVersionStateMap = Preconditions.checkNotNull(moduleVersionStateMap);
            this.modules = Preconditions.checkNotNull(modules);
            this.versions = Preconditions.checkNotNull(versions);
            this.defaultVersions = Preconditions.checkNotNull(defaultVersions);
        }

        @Override
        public Iterable<String> getModuleNames() {
            return this.modules;
        }

        @Override
        public Iterable<String> getVersions(String moduleName) throws ApiProxy.ApplicationException {
            if (this.versions.containsKey(moduleName)) {
                return this.versions.get(moduleName);
            }
            logger.logp(Level.INFO, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$TestModulesController", "getVersions", new StringBuilder(60 + String.valueOf(moduleName).length()).append("Operation getVersions failed because module=").append(moduleName).append(" is not defined.").toString());
            throw new ApiProxy.ApplicationException(1, "The specified module does not exist.");
        }

        @Override
        public String getDefaultVersion(String moduleName) throws ApiProxy.ApplicationException {
            if (this.defaultVersions.containsKey(moduleName)) {
                return this.defaultVersions.get(moduleName);
            }
            logger.logp(Level.INFO, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$TestModulesController", "getDefaultVersion", new StringBuilder(66 + String.valueOf(moduleName).length()).append("Operation getDefaultVersion failed because module=").append(moduleName).append(" is not defined.").toString());
            throw new ApiProxy.ApplicationException(1, "Invalid module name.");
        }

        @Override
        public int getNumInstances(String moduleName, String version) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("getNumInstances", moduleName, version);
            return moduleVersionState.getNumInstances();
        }

        @Override
        public void setNumInstances(String moduleName, String version, int numInstances) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("setNumInstances", moduleName, version);
            moduleVersionState.setNumInstances(numInstances);
        }

        @Override
        public String getHostname(String moduleName, String version, int instance) throws ApiProxy.ApplicationException {
            String operation;
            String string = operation = instance == -1 ? "getHostName" : "getInstanceHostname";
            if (!this.versions.containsKey(moduleName)) {
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$TestModulesController", "getHostname", new StringBuilder(55 + String.valueOf(operation).length() + String.valueOf(moduleName).length()).append("Operation ").append(operation).append(" could not find the requested module  Module ").append(moduleName).toString());
                throw new ApiProxy.ApplicationException(1, "The specified module does not exist.");
            }
            StringBuilder sb = new StringBuilder();
            if (instance != -1) {
                AbstractModuleVersionState moduleVersionState = this.getModuleVersionState(operation, moduleName, version);
                sb.append(moduleVersionState.getInstanceDot(instance));
            }
            sb.append(version);
            sb.append(".");
            sb.append(moduleName);
            sb.append(".");
            sb.append(ApiProxy.getCurrentEnvironment().getAppId());
            sb.append(".");
            sb.append(LocalModulesServiceTestConfig.getLocalModulesService().getServerHostname());
            return sb.toString();
        }

        @Override
        public void startModule(String moduleName, String version) throws ApiProxy.ApplicationException {
            Preconditions.checkNotNull(moduleName);
            Preconditions.checkNotNull(version);
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("startVersion", moduleName, version);
            moduleVersionState.start();
        }

        @Override
        public void stopModule(String moduleName, String version) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("stopVersion", moduleName, version);
            moduleVersionState.stop();
        }

        @Override
        public String getScalingType(String moduleName) throws ApiProxy.ApplicationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModulesController.ModuleState getModuleState(String moduleName) throws ApiProxy.ApplicationException {
            throw new UnsupportedOperationException();
        }

        private AbstractModuleVersionState getModuleVersionState(String operation, String module, String version) {
            AbstractModuleVersionState moduleVersionState = this.moduleVersionStateMap.get(new ModuleVersionKey(module, version));
            if (moduleVersionState == null) {
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig$TestModulesController", "getModuleVersionState", new StringBuilder(72 + String.valueOf(operation).length() + String.valueOf(module).length() + String.valueOf(version).length()).append("Operation ").append(operation).append(" could not find the requested module version  Module ").append(module).append(" version ").append(version).toString());
                throw new ApiProxy.ApplicationException(2, "Could not find the given version.");
            }
            return moduleVersionState;
        }

        private void verifyEnvironment(String module, String version, int instance) {
            AbstractModuleVersionState moduleVersionState = this.moduleVersionStateMap.get(new ModuleVersionKey(module, version));
            if (moduleVersionState == null) {
                throw new IllegalStateException(new StringBuilder(529 + String.valueOf(module).length() + String.valueOf(version).length()).append("The LocalServiceTestHelper Environment module = '").append(module).append("' version = '").append(version).append("' specifies a module version that has not been configured, either add the needed module version (with one of LocalModulesServiceTestConfig.addDefaultModuleVersion, LocalModulesServiceTestConfig.addAutomaticScalingModuleeVersion, LocalModulesServiceTestConfig.addBasicScalingModuleVersion, or LocalModulesServiceTestConfig.addManualScalingModuleVersion) or correct the Environment (with LocalServiceTestHelper.setEnvModuleId and LocalServiceTestHelper.setEnvVersionId)").toString());
            }
            if (instance != -1) {
                if (moduleVersionState.getModuleVersion().getInitialNumInstances() == -1) {
                    throw new IllegalStateException(new StringBuilder(452 + String.valueOf(module).length() + String.valueOf(version).length()).append("The requested module version module = '").append(module).append("' version = '").append(version).append("' does not support instances but the LocalServiceTestHelper environment has instances set. You can correct this issue by providing a matching manually scaling or basic scaling module version to LocalModulesServiceTestConfig.setVersions or by calling LocalServiceTestHelper.setEnvModuleInstance with com.google.appengine.tools.development.LocalEnvironment.MAIN_INSTANCE (-1) which is the default value").toString());
                }
                if (instance >= moduleVersionState.getNumInstancesInternal()) {
                    int n = moduleVersionState.getNumInstancesInternal();
                    throw new IllegalStateException(new StringBuilder(493 + String.valueOf(module).length() + String.valueOf(version).length()).append("The requested module version module = '").append(module).append("' version = '").append(version).append("' has only ").append(n).append(" instances and the LocalServiceTestHelper environment has envInstance set to ").append(instance).append(" which is too big. You can correct this issue by defining more instances for the module version with LocalModulesServiceTestConfig.setVersions or by calling LocalServiceTestHelper.setEnvModuleInstance with a supported instance or com.google.appengine.tools.development.LocalEnvironment.MAIN_INSTANCE (-1) which is the default value").toString());
                }
            }
        }
    }
}

