/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import org.w3c.dom.Element;

public class DosXmlReader
extends AbstractConfigXmlReader<DosXml> {
    private static final String FILENAME = "WEB-INF/dos.xml";
    private static final String BLACKLISTENTRIES_TAG = "blacklistentries";
    private static final String BLACKLIST_TAG = "blacklist";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SUBNET_TAG = "subnet";

    public DosXmlReader(String appDir) {
        super(appDir, false);
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    public DosXml readDosXml() {
        return (DosXml)this.readConfigXml();
    }

    @Override
    protected DosXml processXml(InputStream is) {
        DosXml dosXml = new DosXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        if (!root.getTagName().equals(BLACKLISTENTRIES_TAG)) {
            String string = this.getFilename();
            String string2 = BLACKLISTENTRIES_TAG;
            throw new AppEngineConfigException(new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" does not contain <").append(string2).append(">").toString());
        }
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(BLACKLIST_TAG)) {
                this.parseBlacklist(child, dosXml.addNewBlacklistEntry());
                continue;
            }
            String string = this.getFilename();
            String string3 = child.getTagName();
            String string4 = BLACKLIST_TAG;
            throw new AppEngineConfigException(new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(" contains <").append(string3).append("> instead of <").append(string4).append("/>").toString());
        }
        dosXml.validateLastEntry();
        return dosXml;
    }

    private void parseBlacklist(Element blacklistElement, DosXml.BlacklistEntry blacklistEntry) {
        block8: for (Element child : XmlUtils.getChildren(blacklistElement)) {
            switch (child.getTagName()) {
                case "description": {
                    blacklistEntry.setDescription(this.stringContents(child));
                    continue block8;
                }
                case "subnet": {
                    blacklistEntry.setSubnet(this.stringContents(child));
                    continue block8;
                }
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            String string3 = BLACKLIST_TAG;
            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" contains unknown <").append(string2).append("> inside <").append(string3).append("/>").toString());
        }
    }
}

