/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppYaml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public final class AppYamlProcessor {
    public static void convert(File baseDir, String aewebPath, String webXmlPath) {
        AppYaml appYaml;
        File appYamlFile = new File(baseDir, "app.yaml");
        if (!appYamlFile.exists()) {
            return;
        }
        File aeweb = new File(aewebPath);
        File webXml = new File(webXmlPath);
        if (aeweb.exists() && webXml.exists() && aeweb.lastModified() >= appYamlFile.lastModified() && webXml.lastModified() >= appYamlFile.lastModified()) {
            return;
        }
        try {
            appYaml = AppYaml.parse(new FileReader(appYamlFile));
        }
        catch (FileNotFoundException ex) {
            String string = String.valueOf(appYamlFile);
            throw new AppEngineConfigException(new StringBuilder(16 + String.valueOf(string).length()).append("Unable to parse ").append(string).toString(), ex);
        }
        try {
            FileWriter aewebWriter = new FileWriter(aeweb);
            appYaml.generateAppEngineWebXml(aewebWriter);
            aewebWriter.close();
            aeweb.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            String string = String.valueOf(aeweb);
            throw new AppEngineConfigException(new StringBuilder(19 + String.valueOf(string).length()).append("Unable to generate ").append(string).toString(), ex);
        }
        try {
            FileWriter webXmlWriter = new FileWriter(webXml);
            appYaml.generateWebXml(webXmlWriter);
            webXmlWriter.close();
            webXml.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            String string = String.valueOf(webXml);
            throw new AppEngineConfigException(new StringBuilder(19 + String.valueOf(string).length()).append("Unable to generate ").append(string).toString(), ex);
        }
    }
}

