/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.backend.BaseMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.KeyValueFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataHandler;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataKeyValueHandlers;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataProcessor;
import com.google.appengine.repackaged.com.google.common.flogger.backend.SimpleMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SimpleCustomFormatter
extends LogMessageFormatter {
    private static final String DEFAULT_TEMPLATE_SPECIFIER = "${message}${!metadata/[CONTEXT / ]}";
    private static final Template DEFAULT_TEMPLATE = Template.parse("${message}${!metadata/[CONTEXT / ]}");
    private final Template template;

    public static LogMessageFormatter fromTemplateString(String template) {
        return new SimpleCustomFormatter(template, System.err);
    }

    SimpleCustomFormatter(String spec, PrintStream err) {
        Template template = DEFAULT_TEMPLATE;
        if (spec != null && !spec.equals(DEFAULT_TEMPLATE_SPECIFIER)) {
            try {
                template = Template.parse(spec);
            }
            catch (RuntimeException e) {
                err.format("Cannot parse Flogger formatter template '%s': %s\n", spec, e.getMessage());
                e.printStackTrace(err);
                err.flush();
            }
        }
        this.template = template;
    }

    @Override
    public StringBuilder append(LogData logData, MetadataProcessor metadata, StringBuilder buffer) {
        new FormatContext(logData, metadata, buffer).formatWith(this.template);
        return buffer;
    }

    @Override
    public String format(LogData logData, MetadataProcessor metadata) {
        if (this.template.mustBeFormatted(logData, metadata)) {
            return this.append(logData, metadata, new StringBuilder()).toString();
        }
        return SimpleMessageFormatter.getLiteralLogMessage(logData);
    }

    private static class CustomTagSegment
    extends KeyValueSegment {
        private final String tagName;
        private final MetadataHandler<MetadataKey.KeyValueHandler> singleTagHandler = new MetadataHandler<MetadataKey.KeyValueHandler>(){

            @Override
            protected <T> void handle(MetadataKey<T> key, T value, MetadataKey.KeyValueHandler context) {
                Tags tags = LogContext.Key.TAGS.cast(value);
                Set<Object> tagValues = tags.asMap().get(tagName);
                if (tagValues != null) {
                    this.emitTagValues(tagName, tagValues, context);
                }
            }
        };

        CustomTagSegment(String tagName, String prefix, String suffix, Set<Flag> flags) {
            super(prefix, suffix, flags, Flag.INSERT_SEPARATOR, Flag.VALUE_ONLY);
            this.tagName = tagName;
        }

        @Override
        void appendKeysAndValues(MetadataProcessor metadata, MetadataKey.KeyValueHandler context) {
            metadata.handle(LogContext.Key.TAGS, this.singleTagHandler, context);
        }
    }

    private static class CustomSegment
    extends KeyValueSegment {
        private static final MetadataHandler<MetadataKey.KeyValueHandler> APPEND_ANY_METADATA = MetadataHandler.builder(MetadataKeyValueHandlers.getDefaultValueHandler()).setDefaultRepeatedHandler(MetadataKeyValueHandlers.getDefaultRepeatedValueHandler()).build();
        private final MetadataKey<?> key;

        CustomSegment(MetadataKey<?> key, String prefix, String suffix, Set<Flag> flags) {
            super(prefix, suffix, flags, Flag.INSERT_SEPARATOR, Flag.VALUE_ONLY);
            this.key = key;
        }

        @Override
        void appendKeysAndValues(MetadataProcessor metadata, MetadataKey.KeyValueHandler context) {
            metadata.handle(this.key, APPEND_ANY_METADATA, context);
        }
    }

    private static class MetadataSegment
    extends KeyValueSegment {
        private final MetadataHandler<MetadataKey.KeyValueHandler> handler;

        MetadataSegment(Set<MetadataKey<?>> ignored, final Set<String> ignoredTags, String prefix, String suffix, Set<Flag> flags) {
            super(prefix, suffix, flags, Flag.INSERT_SEPARATOR);
            MetadataHandler.Builder<MetadataKey.KeyValueHandler> handler = MetadataKeyValueHandlers.getDefaultBuilder(ignored);
            if (!ignoredTags.isEmpty()) {
                handler.addHandler(LogContext.Key.TAGS, new MetadataHandler.ValueHandler<Tags, MetadataKey.KeyValueHandler>(){

                    @Override
                    public void handle(MetadataKey<Tags> key, Tags tags, MetadataKey.KeyValueHandler context) {
                        for (Map.Entry<String, Set<Object>> e : tags.asMap().entrySet()) {
                            String tagName = e.getKey();
                            if (ignoredTags.contains(tagName)) continue;
                            this.emitTagValues(tagName, e.getValue(), context);
                        }
                    }
                });
            }
            this.handler = handler.build();
        }

        @Override
        void appendKeysAndValues(MetadataProcessor metadata, MetadataKey.KeyValueHandler context) {
            metadata.process(this.handler, context);
        }
    }

    private static abstract class KeyValueSegment
    extends Segment {
        KeyValueSegment(String prefix, String suffix, Set<Flag> flags, Flag ... allowedFlags) {
            super(prefix, suffix, flags, allowedFlags);
        }

        @Override
        boolean appendValue(FormatContext context) {
            context.appendKeysAndValues(this);
            return false;
        }

        abstract void appendKeysAndValues(MetadataProcessor var1, MetadataKey.KeyValueHandler var2);

        void emitTagValues(String tagName, Set<Object> values, MetadataKey.KeyValueHandler context) {
            if (!values.isEmpty()) {
                for (Object v : values) {
                    context.handle(tagName, v);
                }
            } else {
                context.handle(tagName, null);
            }
        }
    }

    private static class MessageSegment
    extends Segment {
        MessageSegment(String prefix, String suffix, Set<Flag> flags) {
            super(prefix, suffix, flags, Flag.INSERT_SEPARATOR);
        }

        @Override
        boolean appendValue(FormatContext context) {
            return context.appendMessage();
        }

        @Override
        boolean mustBeFormatted() {
            return !this.getPrefix().isEmpty() || !this.getSuffix().isEmpty();
        }
    }

    private static abstract class Segment {
        private final String prefix;
        private final String suffix;
        private final Set<Flag> flags;

        Segment(String prefix, String suffix, Set<Flag> flags, Flag ... allowedFlags) {
            this.prefix = prefix != null ? prefix : "";
            this.suffix = suffix != null ? suffix : "";
            this.flags = flags;
            if (!Arrays.asList(allowedFlags).containsAll(flags)) {
                String string = String.valueOf(flags);
                throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("invalid flags for segment: ").append(string).toString());
            }
        }

        abstract boolean appendValue(FormatContext var1);

        boolean mustBeFormatted() {
            return false;
        }

        final String getPrefix() {
            return this.prefix;
        }

        final String getSuffix() {
            return this.suffix;
        }

        final Set<Flag> getFlags() {
            return this.flags;
        }
    }

    private static final class FormatContext {
        private static final int NEWLINE_LIMIT = 1000;
        private final MetadataKey.KeyValueHandler appendJsonKeyAndValue = new MetadataKey.KeyValueHandler(){

            @Override
            public void handle(String key, Object value) {
                KeyValueFormatter.appendJsonFormattedKeyAndValue(key, value, buffer);
                buffer.append(' ');
            }
        };
        private final MetadataKey.KeyValueHandler appendRawValue = new MetadataKey.KeyValueHandler(){

            @Override
            public void handle(String key, Object value) {
                buffer.append(value).append(' ');
            }
        };
        private final LogData logData;
        private final MetadataProcessor metadata;
        private final StringBuilder buffer;
        private final List<Integer> separators = new ArrayList<Integer>();

        FormatContext(LogData logData, MetadataProcessor metadata, StringBuilder buffer) {
            this.logData = logData;
            this.metadata = metadata;
            this.buffer = buffer;
        }

        void formatWith(Template template) {
            boolean isMultiLine = false;
            for (Segment segment : template.getSegments()) {
                isMultiLine |= this.appendSegment(segment);
            }
            this.tidyUpSeparators(isMultiLine);
        }

        private void tidyUpSeparators(boolean wasMultiLine) {
            int lastSeparatorIndex = this.separators.size() - 1;
            if (lastSeparatorIndex < 0) {
                return;
            }
            int lastCharIndex = this.buffer.length() - 1;
            if (this.separators.get(lastSeparatorIndex) == lastCharIndex) {
                this.buffer.setLength(lastCharIndex);
                this.separators.remove(lastSeparatorIndex);
            }
            if (wasMultiLine) {
                for (Integer n : this.separators) {
                    this.buffer.setCharAt(n, '\n');
                }
            }
        }

        boolean appendSegment(Segment segment) {
            int lastSeparatorIndex;
            int segmentStart = this.buffer.length();
            if (segmentStart > 0 && segment.getFlags().contains((Object)Flag.INSERT_SEPARATOR) && ((lastSeparatorIndex = this.separators.size() - 1) < 0 || this.separators.get(lastSeparatorIndex) < segmentStart - 1)) {
                this.buffer.append(' ');
                this.separators.add(segmentStart++);
            }
            this.buffer.append(segment.getPrefix());
            int valueStart = this.buffer.length();
            boolean wasMultiLine = segment.appendValue(this);
            if (this.buffer.length() > valueStart) {
                this.buffer.append(segment.getSuffix());
                return wasMultiLine;
            }
            this.buffer.setLength(segmentStart);
            return false;
        }

        boolean appendMessage() {
            int start = this.buffer.length();
            BaseMessageFormatter.appendFormattedMessage(this.logData, this.buffer);
            int end = this.buffer.length();
            return end - start > 1000 || this.buffer.indexOf("\n", start) != -1;
        }

        void appendKeysAndValues(KeyValueSegment segment) {
            int start = this.buffer.length();
            MetadataKey.KeyValueHandler handler = segment.getFlags().contains((Object)Flag.VALUE_ONLY) ? this.appendRawValue : this.appendJsonKeyAndValue;
            segment.appendKeysAndValues(this.metadata, handler);
            int end = this.buffer.length();
            if (end > start) {
                this.buffer.setLength(end - 1);
            }
        }
    }

    private static final class Template {
        private static final Pattern SEGMENT_PATTERN = Pattern.compile("\\$\\{([!=]+)?([^\\\\/{}]+)(?:/([^\\\\/{}]*)(?:/([^\\\\/{}]*))?)?\\}");
        private static final Pattern CUSTOM_SPEC = Pattern.compile("([^.]+(?:\\.[^.]+)*)#([^.]+)");
        private static final Set<MetadataKey<?>> ALWAYS_IGNORED_KEYS = Collections.singleton(LogContext.Key.LOG_CAUSE);
        private final List<Segment> segments;
        private final boolean someSegmentsMustBeFormatted;

        static Template parse(String template) {
            LinkedHashMap<String, MatchResult> segmentMap = new LinkedHashMap<String, MatchResult>();
            int nextStart = 0;
            Matcher m = SEGMENT_PATTERN.matcher(template);
            while (m.find() && m.start() == nextStart) {
                if (segmentMap.put(m.group(2), m.toMatchResult()) != null) {
                    String string = String.valueOf(template);
                    throw new IllegalArgumentException(string.length() != 0 ? "duplicate segment in template string: ".concat(string) : new String("duplicate segment in template string: "));
                }
                nextStart = m.end();
            }
            if (nextStart != template.length()) {
                String string = String.valueOf(template);
                throw new IllegalArgumentException(string.length() != 0 ? "invalid template string: ".concat(string) : new String("invalid template string: "));
            }
            HashMap customKeys = new HashMap();
            HashMap<String, String> customTags = new HashMap<String, String>();
            for (String name : segmentMap.keySet()) {
                Matcher s = CUSTOM_SPEC.matcher(name);
                if (!s.matches()) continue;
                String classNameOrTag = s.group(1);
                String fieldOrTagName = s.group(2);
                if ("TAG".equals(classNameOrTag)) {
                    customTags.put(name, fieldOrTagName);
                    continue;
                }
                customKeys.put(name, Template.loadMetadataKey(classNameOrTag, fieldOrTagName));
            }
            HashSet ignoredKeys = new HashSet(ALWAYS_IGNORED_KEYS);
            ignoredKeys.addAll(customKeys.values());
            HashSet<String> ignoredTags = new HashSet<String>(customTags.values());
            ArrayList<Segment> segments = new ArrayList<Segment>();
            for (Map.Entry e : segmentMap.entrySet()) {
                Segment segment;
                String name = (String)e.getKey();
                MatchResult spec = (MatchResult)e.getValue();
                String prefix = spec.group(3);
                String suffix = spec.group(4);
                Set<Flag> flags = Flag.parse(spec.group(1));
                if (name.equals("message")) {
                    segment = new MessageSegment(prefix, suffix, flags);
                } else if (name.equals("metadata")) {
                    segment = new MetadataSegment(ignoredKeys, ignoredTags, prefix, suffix, flags);
                } else if (customKeys.containsKey(name)) {
                    segment = new CustomSegment((MetadataKey)customKeys.get(name), prefix, suffix, flags);
                } else if (customTags.containsKey(name)) {
                    segment = new CustomTagSegment((String)customTags.get(name), prefix, suffix, flags);
                } else {
                    String string = String.valueOf(name);
                    throw new IllegalArgumentException(string.length() != 0 ? "invalid segment name: ".concat(string) : new String("invalid segment name: "));
                }
                segments.add(segment);
            }
            return new Template(segments);
        }

        private static MetadataKey<?> loadMetadataKey(String className, String fieldName) {
            try {
                MetadataKey key = (MetadataKey)Class.forName(className).getDeclaredField(fieldName).get(null);
                if (key != null) {
                    return key;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(className).length() + String.valueOf(fieldName).length()).append("invalid field specifier: ").append(className).append("#").append(fieldName).toString(), e);
            }
            throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(className).length() + String.valueOf(fieldName).length()).append("cannot load metadata key using reflection: ").append(className).append("#").append(fieldName).toString());
        }

        private Template(List<Segment> segments) {
            this.segments = segments;
            boolean someSegmentsMustBeFormatted = false;
            for (Segment segment : segments) {
                someSegmentsMustBeFormatted |= segment.mustBeFormatted();
            }
            this.someSegmentsMustBeFormatted = someSegmentsMustBeFormatted;
        }

        Iterable<Segment> getSegments() {
            return this.segments;
        }

        boolean mustBeFormatted(LogData logData, MetadataProcessor metadata) {
            return this.someSegmentsMustBeFormatted || SimpleMessageFormatter.mustBeFormatted(logData, metadata, ALWAYS_IGNORED_KEYS);
        }
    }

    private static enum Flag {
        INSERT_SEPARATOR,
        VALUE_ONLY;

        private static final String INDEX_LOOKUP = "!=";

        static Set<Flag> parse(String flags) {
            EnumSet<Flag> parsed = EnumSet.noneOf(Flag.class);
            if (flags != null) {
                for (int n = 0; n < flags.length(); ++n) {
                    int idx = INDEX_LOOKUP.indexOf(flags.charAt(n));
                    if (idx == -1) {
                        String string = String.valueOf(flags);
                        throw new IllegalArgumentException(string.length() != 0 ? "unknown flag(s): ".concat(string) : new String("unknown flag(s): "));
                    }
                    Flag flag = Flag.values()[idx];
                    if (parsed.add(flag)) continue;
                    String string = String.valueOf(flags);
                    throw new IllegalArgumentException(string.length() != 0 ? "duplicate flag(s): ".concat(string) : new String("duplicate flag(s): "));
                }
            }
            return parsed;
        }
    }
}

