/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class VersionComparator {
    private static final Map<String, Integer> SPECIAL_MEANINGS = new HashMap<String, Integer>();

    public static int compare(String selector, String candidate) {
        int i;
        if (selector.equals(candidate)) {
            return 0;
        }
        selector = selector.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
        selector = selector.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
        candidate = candidate.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
        candidate = candidate.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
        String[] parts1 = selector.split("[\\._\\-\\+]");
        String[] parts2 = candidate.split("[\\._\\-\\+]");
        for (i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].equals(parts2[i])) continue;
            boolean is1Number = VersionComparator.isNumber(parts1[i]);
            boolean is2Number = VersionComparator.isNumber(parts2[i]);
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
            }
            Integer sm1 = SPECIAL_MEANINGS.get(parts1[i].toLowerCase(Locale.US));
            Integer sm2 = SPECIAL_MEANINGS.get(parts2[i].toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? 0 : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return parts1[i].compareTo(parts2[i]);
        }
        if (i < parts1.length) {
            return VersionComparator.isNumber(parts1[i]) ? 1 : -1;
        }
        if (i < parts2.length) {
            return VersionComparator.isNumber(parts2[i]) ? -1 : 1;
        }
        return 0;
    }

    private static boolean isNumber(String str) {
        return str.matches("\\d+");
    }

    static {
        SPECIAL_MEANINGS.put("dev", -1);
        SPECIAL_MEANINGS.put("rc", 1);
        SPECIAL_MEANINGS.put("final", 2);
    }
}

