/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.gcloud.exec.io

/**
 * Trait for streamwatcher that allows a stream to be inspected line by line
 */
trait StreamWatcher {

    StreamInspector inspector

    void setInspector(StreamInspector inspector) {
        this.inspector = inspector
    }

    public static interface StreamInspector {
        void inspectLine(String line)
    }
}
