/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class Batcher<R extends MessageLiteOrBuilder, F, T extends MessageLite> {
    Batcher() {
    }

    abstract Object getGroup(F var1);

    abstract void addToBatch(T var1, R var2);

    abstract R newBatch(R var1);

    abstract int getMaxSize();

    abstract int getMaxCount();

    abstract int getMaxGroups();

    abstract T toPb(F var1);

    private static int getEmbeddedSize(MessageLite pb) {
        return Protocol.stringSize(pb.getSerializedSize()) + 1;
    }

    private <T2> void put(Map<Object, Collection<T2>> map, Object key, T2 value) {
        Collection<T2> col = map.get(key);
        if (col == null) {
            col = Lists.newArrayList();
            map.put(key, col);
        }
        col.add(value);
    }

    Iterator<R> getBatches(Collection<F> values, R baseBatch, int baseBatchSize, boolean group) {
        Iterator<Collection<Object>> groupItr;
        if (values.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (group) {
            LinkedHashMap groupedValues = Maps.newLinkedHashMap();
            for (F value : values) {
                this.put(groupedValues, this.getGroup(value), value);
            }
            groupItr = groupedValues.values().iterator();
        } else {
            groupItr = Iterators.singletonIterator(values);
        }
        return new BatchIterator<F>((MessageLiteOrBuilder)baseBatch, baseBatchSize, groupItr){

            @Override
            protected F getValue(F value) {
                return value;
            }
        };
    }

    Iterator<R> getBatches(Collection<F> values, R baseBatch, int baseBatchSize, boolean group, final List<Integer> order) {
        Iterator<ArrayList<Object>> groupItr;
        if (values.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (group) {
            LinkedHashMap groupedValues = Maps.newLinkedHashMap();
            int index = 0;
            for (F value : values) {
                this.put(groupedValues, this.getGroup(value), new IndexedItem<F>(index++, value));
            }
            groupItr = groupedValues.values().iterator();
        } else {
            ArrayList<IndexedItem<F>> indexedValue = Lists.newArrayList();
            int index = 0;
            for (F value : values) {
                indexedValue.add(new IndexedItem<F>(index++, value));
            }
            groupItr = Iterators.singletonIterator(indexedValue);
        }
        return new BatchIterator<IndexedItem<F>>((MessageLiteOrBuilder)baseBatch, baseBatchSize, groupItr){

            @Override
            protected F getValue(IndexedItem<F> value) {
                order.add(value.index);
                return value.item;
            }
        };
    }

    private static abstract class BatchIterator<V>
    implements Iterator<R> {
        final R baseBatch;
        final int baseSize;
        final int maxSize;
        final int maxCount;
        final int maxGroups;
        final Iterator<? extends Iterable<V>> groupItr;
        Iterator<V> valueItr;
        T nextValue;
        final /* synthetic */ Batcher this$0;

        protected abstract F getValue(V var1);

        BatchIterator(R baseBatch, int baseBatchSize, Iterator<? extends Iterable<V>> groupedValues) {
            this.this$0 = var1_1;
            this.maxSize = this.this$0.getMaxSize();
            this.maxCount = this.this$0.getMaxCount();
            this.baseBatch = baseBatch;
            this.baseSize = baseBatchSize;
            this.groupItr = groupedValues;
            this.valueItr = this.groupItr.next().iterator();
            this.nextValue = var1_1.toPb(this.getValue(this.valueItr.next()));
            this.maxGroups = var1_1.getMaxGroups();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object batch = this.this$0.newBatch(this.baseBatch);
            int size = this.baseSize;
            int numGroups = 1;
            for (int i = 0; i < this.maxCount && numGroups <= this.maxGroups; ++i) {
                int valueSize = Batcher.getEmbeddedSize(this.nextValue);
                if (i > 0 && size + valueSize > this.maxSize) break;
                size += valueSize;
                this.this$0.addToBatch(this.nextValue, batch);
                if (!this.valueItr.hasNext()) {
                    if (!this.groupItr.hasNext()) {
                        this.nextValue = null;
                        break;
                    }
                    this.valueItr = this.groupItr.next().iterator();
                    ++numGroups;
                }
                this.nextValue = this.this$0.toPb(this.getValue(this.valueItr.next()));
            }
            return batch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class ReorderingMultiFuture<K, V>
    extends FutureHelper.MultiFuture<K, V> {
        private final Collection<Integer> order;

        public ReorderingMultiFuture(Iterable<Future<K>> futures, Collection<Integer> order) {
            super(futures);
            this.order = order;
        }

        protected abstract V aggregate(K var1, Iterator<Integer> var2, V var3);

        protected abstract V initResult();

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            Iterator<Integer> indexItr = this.order.iterator();
            V result = this.initResult();
            for (Future future : this.futures) {
                result = this.aggregate(future.get(), indexItr, result);
            }
            return result;
        }

        @Override
        public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Iterator<Integer> indexItr = this.order.iterator();
            V result = this.initResult();
            for (Future future : this.futures) {
                result = this.aggregate(future.get(timeout, unit), indexItr, result);
            }
            return result;
        }
    }

    static class IndexedItem<F> {
        final int index;
        final F item;

        IndexedItem(int index, F item) {
            this.index = index;
            this.item = item;
        }

        public String toString() {
            return String.format("IndexedItem(%d,  %s)", this.index, this.item);
        }
    }
}

