/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashSet;
import java.util.Iterator;

class NormalizedQuery {
    static final ImmutableSet<DatastoreV3Pb.Query.Filter.Operator> INEQUALITY_OPERATORS = ImmutableSet.of(DatastoreV3Pb.Query.Filter.Operator.GREATER_THAN, DatastoreV3Pb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL, DatastoreV3Pb.Query.Filter.Operator.LESS_THAN, DatastoreV3Pb.Query.Filter.Operator.LESS_THAN_OR_EQUAL);
    protected final DatastoreV3Pb.Query query;

    public NormalizedQuery(DatastoreV3Pb.Query query) {
        this.query = (DatastoreV3Pb.Query)query.clone();
        this.normalizeQuery();
    }

    public DatastoreV3Pb.Query getQuery() {
        return this.query;
    }

    private void normalizeQuery() {
        HashSet<OnestoreEntity.Property> equalityFilterProperties = new HashSet<OnestoreEntity.Property>();
        HashSet<String> equalityProperties = new HashSet<String>();
        HashSet<String> inequalityProperties = new HashSet<String>();
        Iterator<ProtocolMessage> itr = this.query.mutableFilters().iterator();
        while (itr.hasNext()) {
            DatastoreV3Pb.Query.Filter f = itr.next();
            if (f.propertySize() == 1 && f.getOpEnum() == DatastoreV3Pb.Query.Filter.Operator.IN) {
                f.setOp(DatastoreV3Pb.Query.Filter.Operator.EQUAL);
            }
            if (f.propertySize() < 1) continue;
            String name = f.getProperty(0).getName();
            if (f.getOpEnum() == DatastoreV3Pb.Query.Filter.Operator.EQUAL) {
                if (!equalityFilterProperties.add(f.getProperty(0))) {
                    itr.remove();
                    continue;
                }
                equalityProperties.add(name);
                continue;
            }
            if (!INEQUALITY_OPERATORS.contains(f.getOpEnum())) continue;
            inequalityProperties.add(name);
        }
        equalityProperties.removeAll(inequalityProperties);
        itr = this.query.mutableOrders().iterator();
        while (itr.hasNext()) {
            if (equalityProperties.add(((DatastoreV3Pb.Query.Order)itr.next()).getProperty())) continue;
            itr.remove();
        }
        HashSet<String> allProperties = equalityProperties;
        allProperties.addAll(inequalityProperties);
        Iterator<Object> itr2 = this.query.mutableFilters().iterator();
        while (itr2.hasNext()) {
            DatastoreV3Pb.Query.Filter f = itr2.next();
            if (f.getOpEnum() != DatastoreV3Pb.Query.Filter.Operator.EXISTS || f.propertySize() < 1 || allProperties.add(f.getProperty(0).getName())) continue;
            itr2.remove();
        }
        for (String propName : Iterables.concat(this.query.propertyNames(), this.query.groupByPropertyNames())) {
            if (!allProperties.add(propName)) continue;
            this.query.addFilter().setOp(DatastoreV3Pb.Query.Filter.Operator.EXISTS).addProperty().setName(propName).setMultiple(false).getMutableValue();
        }
        for (DatastoreV3Pb.Query.Filter f : this.query.filters()) {
            if (f.getOpEnum() != DatastoreV3Pb.Query.Filter.Operator.EQUAL || f.propertySize() < 1 || !f.getProperty(0).getName().equals("__key__")) continue;
            this.query.clearOrder();
            break;
        }
        boolean foundKeyOrder = false;
        Iterator<DatastoreV3Pb.Query.Order> i = this.query.mutableOrders().iterator();
        while (i.hasNext()) {
            String property = i.next().getProperty();
            if (foundKeyOrder) {
                i.remove();
                continue;
            }
            if (!property.equals("__key__")) continue;
            foundKeyOrder = true;
        }
    }
}

