/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.InternalTransactionV3;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.QueryResultsSourceV3;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.concurrent.Future;

final class QueryRunnerV3
implements QueryRunner {
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final ApiProxy.ApiConfig apiConfig;

    QueryRunnerV3(DatastoreServiceConfig datastoreServiceConfig, ApiProxy.ApiConfig apiConfig) {
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.apiConfig = apiConfig;
    }

    @Override
    public QueryResultsSource runQuery(FetchOptions fetchOptions, Query query, Transaction txn) {
        final DatastoreV3Pb.Query queryProto = this.convertToPb(query, txn, fetchOptions);
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryProto.setFailoverMs(-1L);
            queryProto.setStrong(false);
        }
        FutureWrapper<DatastoreV3Pb.QueryResult, DatastoreV3Pb.QueryResult> result = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastoreV3Pb.DatastoreService_3.Method.RunQuery, queryProto, new DatastoreV3Pb.QueryResult());
        result = new FutureWrapper<DatastoreV3Pb.QueryResult, DatastoreV3Pb.QueryResult>(result){

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof DatastoreNeedIndexException) {
                    QueryRunnerV3.this.addMissingIndexData(queryProto, (DatastoreNeedIndexException)cause);
                }
                return cause;
            }

            @Override
            protected DatastoreV3Pb.QueryResult wrap(DatastoreV3Pb.QueryResult result) throws Exception {
                return result;
            }
        };
        return new QueryResultsSourceV3(this.datastoreServiceConfig.getDatastoreCallbacks(), fetchOptions, txn, query, (Future<DatastoreV3Pb.QueryResult>)result, this.apiConfig);
    }

    private void addMissingIndexData(DatastoreV3Pb.Query queryProto, DatastoreNeedIndexException e) {
        CompositeIndexManager mgr = new CompositeIndexManager();
        CompositeIndexManager.IndexComponentsOnlyQuery indexQuery = new CompositeIndexManager.IndexComponentsOnlyQuery(queryProto);
        OnestoreEntity.Index index = mgr.compositeIndexForQuery(indexQuery);
        if (index != null) {
            String xml = mgr.generateXmlForIndex(index, CompositeIndexManager.IndexSource.manual);
            e.setMissingIndexDefinitionXml(xml);
        }
    }

    private DatastoreV3Pb.Query convertToPb(Query q, Transaction txn, FetchOptions fetchOptions) {
        DatastoreV3Pb.Query queryProto = QueryTranslator.convertToPb(q, fetchOptions);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            queryProto.setTransaction(InternalTransactionV3.toProto(txn));
        }
        return queryProto;
    }
}

